/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.limine.snapper.formats.json1.CmdlineDetail;
import org.limine.snapper.formats.json1.ImageDetail;
import org.limine.snapper.formats.json1.KernelEntry;
import org.limine.snapper.formats.json1.Manifest;
import org.limine.snapper.formats.json1.OptionDetail;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.formats.limine8.LimineKey;
import org.limine.snapper.formats.snapper.SnapperProperty;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.EntryOptions;
import org.limine.snapper.objects.TreeNode;
import org.limine.snapper.processes.LimineReader;
import org.limine.snapper.processes.Utility;

public class LimineWriter {
    private final Config config;
    private final LimineReader limine;

    public LimineWriter(Config config, LimineReader limine) {
        this.config = config;
        this.limine = limine;
    }

    public void backup() {
        String limineConfigFilePath = Utility.buildPath(this.config.espPath(), "limine.conf");
        if (Utility.isFilePresent(limineConfigFilePath)) {
            String backupPath = limineConfigFilePath + ".old";
            boolean isBackupNeeded = true;
            if (Utility.isFilePresent(backupPath)) {
                isBackupNeeded = Utility.isFileOlderThan(backupPath, Config.CONFIG_BACKUP_THRESHOLD);
            }
            if (isBackupNeeded) {
                Utility.copyFile(limineConfigFilePath, backupPath, true, false, false);
            }
        }
    }

    public void setSnapshots(Manifest manifest) {
        TreeNode snapshotsNode;
        if (!this.limine.isSnapshotsNodeFound()) {
            LinkedList<TreeNode> kernelNodes = this.limine.getTargetOsNode().nodes;
            TreeNode snapshotsNode2 = new TreeNode(Config.SPACES + String.valueOf((Object)LimineKey.SNAPSHOTS_INSIDE_OS_NODE), 1, this.limine.getTargetOsNode().name);
            kernelNodes.add(kernelNodes.size(), snapshotsNode2);
        }
        if ((snapshotsNode = this.limine.getTargetOsNode().findNodeByName(LimineKey.SNAPSHOTS_INSIDE_OS_NODE.toString(), 1)) != null) {
            this.overwriteSnapshotsNode(snapshotsNode, manifest.getSnapshotEntries(), true);
            if (snapshotsNode.nodes.isEmpty()) {
                this.limine.getTargetOsNode().nodes.remove(snapshotsNode);
            }
            return;
        }
        snapshotsNode = this.limine.getRootNode().findNodeByName(LimineKey.SNAPSHOTS_OUTSIDE_OS_NODE.toString(), 1);
        if (snapshotsNode != null) {
            this.overwriteSnapshotsNode(snapshotsNode, manifest.getSnapshotEntries(), false);
            return;
        }
        String errMessage = "'" + String.valueOf((Object)LimineKey.SNAPSHOTS_INSIDE_OS_NODE) + "' or '" + String.valueOf((Object)LimineKey.SNAPSHOTS_OUTSIDE_OS_NODE) + "' is not found in " + Utility.buildPath(this.config.espPath(), "limine.conf");
        Utility.exitWithError(errMessage);
    }

    public void setTargetEntry(SnapshotEntry restoredOS) {
        TreeNode snapshotsNode = this.limine.getTargetOsNode().findNodeByName(LimineKey.SNAPSHOTS_INSIDE_OS_NODE.toString(), 1);
        List<TreeNode> kernelNodes = this.createKernelNodes(restoredOS.kernelEntries(), LimineKey.SUB_ENTRY_KEY.toString(), 2, Config.TARGET_OS_NAME);
        this.limine.getTargetOsNode().nodes.clear();
        this.limine.getTargetOsNode().nodes.addAll(kernelNodes);
        if (snapshotsNode != null) {
            this.limine.getTargetOsNode().nodes.add(snapshotsNode);
        }
        this.limine.getTargetOsNode().enableLineBreak = true;
    }

    private List<TreeNode> createKernelNodes(List<KernelEntry> kernels, String entryKey, int depth, String parentNodeName) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (KernelEntry k : kernels) {
            String entryName = k.leadingSpaces() + entryKey + k.kernelVersion();
            TreeNode node = new TreeNode(entryName, depth, parentNodeName);
            node.configLines.addAll(k.allInConfig());
            if (k.subKernels() != null && !k.subKernels().isEmpty()) {
                String newEntryKey = entryKey + String.valueOf((Object)LimineKey.ENTRY_KEY);
                List<TreeNode> subNodes = this.createKernelNodes(k.subKernels(), newEntryKey, depth + 1, k.kernelVersion());
                node.nodes.addAll(subNodes);
            }
            nodes.add(node);
        }
        return nodes;
    }

    public void save() {
        ArrayList<String> lines = new ArrayList<String>();
        this.writeNodeToLines(this.limine.getRootNode(), lines, 0);
        String limineConfigPath = Utility.buildPath(this.config.espPath(), "limine.conf");
        if (!Utility.isFilePresent(limineConfigPath)) {
            String errMessage = "File path: " + limineConfigPath + " does not exit!";
            Utility.exitWithError(errMessage);
            return;
        }
        Path limineTmpConfigPath = Paths.get(limineConfigPath + ".tmp", new String[0]);
        try {
            if (Config.COMMANDS_BEFORE_SAVE != null && !Config.COMMANDS_BEFORE_SAVE.isEmpty()) {
                Utility.runCommand(Config.COMMANDS_BEFORE_SAVE, !Config.QUIET, false);
            }
            Files.write(limineTmpConfigPath, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Utility.moveFile(limineTmpConfigPath.toString(), limineConfigPath, true, false, false);
            Utility.runCommand("sync -f " + limineConfigPath, false, false);
            Utility.infoMessage("Updated:", limineConfigPath);
            if (Config.COMMANDS_AFTER_SAVE != null && !Config.COMMANDS_AFTER_SAVE.isEmpty()) {
                Utility.runCommand(Config.COMMANDS_AFTER_SAVE, !Config.QUIET, false);
            }
        }
        catch (IOException e) {
            String errMessage = "Error writing file: " + e.getMessage();
            Utility.exitWithError(errMessage);
        }
    }

    private void overwriteSnapshotsNode(TreeNode snapshotsNode, List<SnapshotEntry> snapshotEntries, boolean isSnapshotsInsideOsNode) {
        if (snapshotsNode == null) {
            return;
        }
        int maxWidth = 0;
        if (!snapshotEntries.isEmpty()) {
            Integer lastSnapshotID = snapshotEntries.get(snapshotEntries.size() - 1).snapperEntry().snapshotID();
            maxWidth = String.valueOf(lastSnapshotID).length();
        }
        String snapshotsComment = this.config.maxSnapshotEntries() <= 10000 ? snapshotEntries.size() + " / " + this.config.maxSnapshotEntries() + " snapshots" : snapshotEntries.size() + " snapshots";
        if (isSnapshotsInsideOsNode) {
            snapshotsNode.configLines.clear();
            snapshotsNode.nodes.clear();
            snapshotsNode.addConfigLine(Config.SPACES + String.valueOf((Object)LimineKey.COMMENT) + " " + snapshotsComment);
            snapshotsNode.enableLineBreak = true;
            for (SnapshotEntry snapshotEntry : snapshotEntries) {
                String snapshotName = this.snapshotNameFormat(maxWidth, snapshotEntry.snapperEntry().snapshotID(), snapshotEntry.snapperEntry().localTime());
                TreeNode snapshotNode = new TreeNode(snapshotName, 3, Config.TARGET_OS_NAME);
                String description = snapshotEntry.snapperEntry().properties().get(SnapperProperty.DESCRIPTION.replace);
                if (description == null) {
                    description = "";
                }
                snapshotNode.addConfigLine(Config.SPACES + String.valueOf((Object)LimineKey.COMMENT) + " " + description);
                for (KernelEntry kernel : snapshotEntry.kernelEntries()) {
                    TreeNode kernelNode = this.buildBootNode(kernel, LimineKey.SUB_X3_ENTRY_KEY.toString(), 4, "Snapshots");
                    if (kernelNode.configLines.isEmpty() && kernelNode.nodes.isEmpty()) continue;
                    snapshotNode.addNode(kernelNode);
                }
                if (snapshotNode.nodes.isEmpty()) continue;
                snapshotsNode.nodes.addFirst(snapshotNode);
            }
        } else {
            TreeNode osNode = snapshotsNode.findNodeByIDorName(this.config, Config.TARGET_OS_NAME, 1);
            if (osNode == null) {
                String osName = Config.SPACES + String.valueOf((Object)LimineKey.SUB_ENTRY_KEY) + Config.TARGET_OS_NAME;
                osNode = new TreeNode(osName, 2, LimineKey.SNAPSHOTS_OUTSIDE_OS_NODE.toString());
                snapshotsNode.addNode(osNode);
            } else {
                osNode.configLines.clear();
                osNode.nodes.clear();
            }
            osNode.name = Config.SPACES + String.valueOf((Object)LimineKey.SUB_ENTRY_KEY) + Config.TARGET_OS_NAME;
            osNode.cleanName = Config.TARGET_OS_NAME;
            osNode.addConfigLine(Config.SPACES + String.valueOf((Object)LimineKey.COMMENT) + " " + snapshotsComment);
            osNode.addConfigLine(Config.SPACES + String.valueOf((Object)LimineKey.COMMENT) + " " + String.valueOf((Object)EntryOptions.Name.MACHINE_ID) + this.config.machineID());
            osNode.enableLineBreak = true;
            for (SnapshotEntry snapshotEntry : snapshotEntries) {
                String snapshotName = this.snapshotNameFormat(maxWidth, snapshotEntry.snapperEntry().snapshotID(), snapshotEntry.snapperEntry().localTime());
                TreeNode snapshotNode = new TreeNode(snapshotName, 3, Config.TARGET_OS_NAME);
                String description = snapshotEntry.snapperEntry().properties().get(SnapperProperty.DESCRIPTION.replace);
                if (description == null) {
                    description = "";
                }
                snapshotNode.addConfigLine(Config.SPACES + String.valueOf((Object)LimineKey.COMMENT) + " " + description);
                for (KernelEntry kernel : snapshotEntry.kernelEntries()) {
                    TreeNode kernelNode = this.buildBootNode(kernel, LimineKey.SUB_X3_ENTRY_KEY.toString(), 4, "Snapshots");
                    if (kernelNode.configLines.isEmpty() && kernelNode.nodes.isEmpty()) continue;
                    snapshotNode.addNode(kernelNode);
                }
                if (snapshotNode.nodes.isEmpty()) continue;
                osNode.nodes.addFirst(snapshotNode);
            }
        }
    }

    private TreeNode buildBootNode(KernelEntry kernel, String entryKey, int depth, String parentName) {
        String kernelName = Config.SPACES + entryKey + kernel.kernelVersion();
        TreeNode kernelNode = new TreeNode(kernelName, 3, parentName);
        if (kernel.allInSnapshotConfig().isEmpty()) {
            for (OptionDetail option : kernel.optionDetails()) {
                kernelNode.configLines.add(Config.SPACES + option.getSnapshotLine());
            }
            for (ImageDetail image : kernel.imageDetails()) {
                kernelNode.configLines.add(Config.SPACES + image.getSnapshotLine());
            }
            for (CmdlineDetail cmdline : kernel.cmdlineDetails()) {
                kernelNode.configLines.add(Config.SPACES + cmdline.getSnapshotLine());
            }
        } else {
            for (String snapConfigLine : kernel.allInSnapshotConfig()) {
                kernelNode.configLines.add(Config.SPACES + snapConfigLine.trim());
            }
        }
        if (kernel.subKernels() != null && !kernel.subKernels().isEmpty()) {
            for (KernelEntry subKernel : kernel.subKernels()) {
                TreeNode subKernelNode = this.buildBootNode(subKernel, entryKey + String.valueOf((Object)LimineKey.ENTRY_KEY), depth + 1, kernel.kernelVersion());
                if (subKernelNode.configLines.isEmpty() && subKernelNode.nodes.isEmpty()) continue;
                kernelNode.addNode(subKernelNode);
            }
        }
        return kernelNode;
    }

    private String snapshotNameFormat(int maxWidth, Integer snapshotID, String timestamp) {
        String formattedSnapshotID = String.format("%-" + maxWidth + "d", snapshotID);
        return switch (Config.SNAPSHOT_FORMAT_CHOICE) {
            case "1" -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + formattedSnapshotID + "\u2502" + timestamp;
            case "2" -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + formattedSnapshotID + " \u2502 " + timestamp;
            case "3" -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + timestamp + "\u2502" + snapshotID;
            case "4" -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + timestamp + " \u2502 " + snapshotID;
            case "5" -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + timestamp;
            case "6" -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + snapshotID;
            default -> Config.SPACES + String.valueOf((Object)LimineKey.SUB_X2_ENTRY_KEY) + "ID=" + formattedSnapshotID + " " + timestamp;
        };
    }

    private void writeNodeToLines(TreeNode node, List<String> lines, int depth) {
        if (depth > 0) {
            lines.add(node.name);
        }
        lines.addAll(node.configLines);
        for (TreeNode childNode : node.nodes) {
            this.writeNodeToLines(childNode, lines, depth + 1);
        }
        if (node.enableLineBreak) {
            lines.add("");
        }
    }
}

