/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.limine.snapper.formats.json1.ImageDetail;
import org.limine.snapper.formats.json1.KernelEntry;
import org.limine.snapper.formats.json1.SnapperEntry;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.formats.limine8.LimineKey;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.TreeNode;
import org.limine.snapper.processes.KernelReader;
import org.limine.snapper.processes.MacroReplacer;
import org.limine.snapper.processes.Utility;

public class LimineReader {
    private final String limineConfigPath;
    private final TreeNode rootNode;
    private final Config config;
    private final TreeNode targetOsNode;

    public LimineReader(Config config) {
        this(config, false);
    }

    public LimineReader(Config config, boolean askUserIfOSnotFound) {
        this.config = config;
        this.limineConfigPath = Utility.buildPath(config.espPath(), "limine.conf");
        TreeNode root = this.readLimineConfig();
        String osName = Config.TARGET_OS_NAME;
        TreeNode os = root.findNodeByIDorName(config, osName, 1);
        if (os == null && askUserIfOSnotFound) {
            do {
                String warn = "Target OS name: '" + osName + "' is not found in " + config.espPath() + "/limine.conf";
                Utility.warnMessage(warn);
                osName = Utility.cleanName(Utility.userInput("Please enter name that should match OS name in the config:"));
            } while ((os = (root = this.readLimineConfig()).findNodeByIDorName(config, osName, 1)) == null);
        }
        if (os == null) {
            String errMessage = "Target OS name: '" + osName + "' is not found in " + config.espPath() + "/limine.conf";
            Utility.exitWithError(errMessage);
        } else {
            Config.TARGET_OS_NAME = osName;
        }
        this.rootNode = root;
        this.targetOsNode = os;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public TreeNode getTargetOsNode() {
        return this.targetOsNode;
    }

    private TreeNode readLimineConfig() {
        TreeNode root = new TreeNode("root", 0, null);
        try {
            List<String> lines = Files.readAllLines(Paths.get(this.limineConfigPath, new String[0]));
            this.parseLinesToTree(lines, root, 0, lines.size());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return root;
    }

    public boolean isTargetOsNotFound() {
        return this.targetOsNode == null;
    }

    public boolean isSnapshotsNodeFound() {
        if (this.targetOsNode == null) {
            return false;
        }
        return this.isSnapshotsNodeInsideOS() || this.isSnapshotsNodeOutsideOS();
    }

    public boolean isSnapshotsNodeInsideOS() {
        return this.targetOsNode.searchNodeByName(LimineKey.SNAPSHOTS_INSIDE_OS_NODE.toString(), 1);
    }

    public boolean isSnapshotsNodeOutsideOS() {
        return this.rootNode.searchNodeByName(LimineKey.SNAPSHOTS_OUTSIDE_OS_NODE.toString(), 1);
    }

    public SnapshotEntry createCurrentLimineEntry(SnapperEntry lastSnapperEntry) {
        List<KernelEntry> kernelEntries = this.createKernelEntries(this.targetOsNode, lastSnapperEntry, this.config);
        return new SnapshotEntry(lastSnapperEntry, kernelEntries, null);
    }

    public SnapshotEntry createCurrentLimineEntry() {
        SnapperEntry snapperEntry = new SnapperEntry(0, null, null, null);
        return this.createCurrentLimineEntry(snapperEntry);
    }

    private List<KernelEntry> createKernelEntries(TreeNode targetOsNode, SnapperEntry lastSnapperEntry, Config config) {
        ArrayList<KernelEntry> kernelEntries = new ArrayList<KernelEntry>();
        HashMap<String, ImageDetail> deduplicateImages = new HashMap<String, ImageDetail>();
        KernelReader kernelReader = new KernelReader(config, deduplicateImages);
        for (TreeNode kernelNode : targetOsNode.nodes) {
            if (kernelNode.configLines.isEmpty() || LimineKey.SNAPSHOTS_INSIDE_OS_NODE.toString().equals(kernelNode.name.trim())) continue;
            String leadingSpaces = Utility.getLeadingSpaces(kernelNode.name);
            KernelEntry kernelEntry = kernelReader.createKernelEntry(kernelNode, leadingSpaces, lastSnapperEntry.snapshotID(), kernelNode.configLines);
            if (kernelReader.isBootConfigValid()) {
                kernelEntries.add(kernelEntry);
                continue;
            }
            kernelReader.resetBootConfigValid();
        }
        return kernelEntries;
    }

    private int parseLinesToTree(List<String> lines, TreeNode currentNode, int startIndex, int endIndex) {
        int index = startIndex;
        while (index < endIndex) {
            String line = lines.get(index);
            String trimLine = line.trim();
            if (trimLine.startsWith(LimineKey.ENTRY_KEY.toString())) {
                int depth = this.calculateDepth(trimLine);
                TreeNode childNode = new TreeNode(line, depth, currentNode.name);
                currentNode.addNode(childNode);
                int nextIndex = this.findNextNodeIndex(lines, index + 1, endIndex, depth);
                index = this.parseLinesToTree(lines, childNode, index + 1, nextIndex);
                continue;
            }
            MacroReplacer.parseMacro(line);
            currentNode.addConfigLine(line);
            ++index;
        }
        return index;
    }

    private int findNextNodeIndex(List<String> lines, int startIndex, int endIndex, int currentDepth) {
        for (int i = startIndex; i < endIndex; ++i) {
            String line = lines.get(i).trim();
            if (!line.startsWith(LimineKey.ENTRY_KEY.toString()) || this.calculateDepth(line) > currentDepth) continue;
            return i;
        }
        return endIndex;
    }

    private int calculateDepth(String line) {
        int depth;
        for (depth = 0; depth < line.length() && line.startsWith(LimineKey.ENTRY_KEY.toString(), depth); ++depth) {
        }
        return depth;
    }
}

