/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limine.snapper.formats.json1.CmdlineDetail;
import org.limine.snapper.formats.json1.ImageDetail;
import org.limine.snapper.formats.json1.KernelEntry;
import org.limine.snapper.formats.json1.OptionDetail;
import org.limine.snapper.formats.limine8.LimineKey;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.TreeNode;
import org.limine.snapper.processes.MacroReplacer;
import org.limine.snapper.processes.Utility;

public class KernelReader {
    private final Config config;
    private final HashMap<String, ImageDetail> deduplicateImages;
    private boolean isBootConfigValid;

    public KernelReader(Config config, HashMap<String, ImageDetail> deduplicateImages) {
        this.config = config;
        this.deduplicateImages = deduplicateImages;
        this.isBootConfigValid = true;
    }

    public String applyKernelParameterChanges(String value) {
        if (!Config.KERNEL_PARAMETERS_TO_REPLACE.isEmpty()) {
            value = String.join((CharSequence)" ", Config.KERNEL_PARAMETERS_TO_REPLACE);
        }
        if (Config.KERNEL_PARAMETERS_TO_ADD.isEmpty() && Config.KERNEL_PARAMETERS_TO_REMOVE.isEmpty()) {
            return value;
        }
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        if (value != null && !value.isEmpty()) {
            String[] parts;
            for (String part : parts = value.trim().split("\\s+")) {
                if (part.isEmpty()) continue;
                tokens.add(part);
            }
        }
        for (String param : Config.KERNEL_PARAMETERS_TO_REMOVE) {
            tokens.remove(param);
        }
        tokens.addAll(Config.KERNEL_PARAMETERS_TO_ADD);
        return String.join((CharSequence)" ", tokens);
    }

    public KernelEntry createKernelEntry(TreeNode kernelNode, String leadingSpaces, int rootSnapshotID, List<String> bootConfig) {
        ArrayList<String> clearBootConfigs = new ArrayList<String>();
        ArrayList<String> snapshotBootConfigs = new ArrayList<String>();
        ArrayList<ImageDetail> imageDetails = new ArrayList<ImageDetail>();
        ArrayList<CmdlineDetail> cmdlineDetails = new ArrayList<CmdlineDetail>();
        ArrayList<OptionDetail> optionDetails = new ArrayList<OptionDetail>();
        ArrayList<KernelEntry> subKernels = new ArrayList<KernelEntry>();
        int lineIndex = 0;
        for (String configLine : bootConfig) {
            Object snapshotConfigLine;
            configLine = MacroReplacer.replaceMacros(configLine);
            clearBootConfigs.add(configLine);
            String spaces = Utility.getLeadingSpaces(configLine);
            String lowerCaseTrimLine = configLine.toLowerCase().trim();
            String extractValue = LimineKey.extractValue(configLine);
            if (lowerCaseTrimLine.startsWith("#") || lowerCaseTrimLine.isBlank()) continue;
            if (lowerCaseTrimLine.startsWith(LimineKey.PATH.toString())) {
                imageDetail = this.convertToImageDetail(LimineKey.PATH.name(), spaces, lineIndex, extractValue);
                if (imageDetail == null) continue;
                imageDetails.add(imageDetail);
                snapshotConfigLine = String.valueOf((Object)LimineKey.PATH) + " " + imageDetail.properties().get(LimineKey.PATH_RESOURCE.name()) + imageDetail.snapshotFilePathLine();
            } else if (lowerCaseTrimLine.startsWith(LimineKey.KERNEL_PATH.toString())) {
                imageDetail = this.convertToImageDetail(LimineKey.KERNEL_PATH.name(), spaces, lineIndex, extractValue);
                if (imageDetail == null) continue;
                imageDetails.add(imageDetail);
                snapshotConfigLine = String.valueOf((Object)LimineKey.KERNEL_PATH) + " " + imageDetail.properties().get(LimineKey.PATH_RESOURCE.name()) + imageDetail.snapshotFilePathLine();
            } else if (lowerCaseTrimLine.startsWith(LimineKey.IMAGE_PATH.toString())) {
                imageDetail = this.convertToImageDetail(LimineKey.IMAGE_PATH.name(), spaces, lineIndex, extractValue);
                if (imageDetail == null) continue;
                imageDetails.add(imageDetail);
                snapshotConfigLine = String.valueOf((Object)LimineKey.IMAGE_PATH) + " " + imageDetail.properties().get(LimineKey.PATH_RESOURCE.name()) + imageDetail.snapshotFilePathLine();
            } else if (lowerCaseTrimLine.startsWith(LimineKey.MODULE_PATH.toString())) {
                imageDetail = this.convertToImageDetail(LimineKey.MODULE_PATH.name(), spaces, lineIndex, extractValue);
                if (imageDetail == null) continue;
                imageDetails.add(imageDetail);
                snapshotConfigLine = String.valueOf((Object)LimineKey.MODULE_PATH) + " " + imageDetail.properties().get(LimineKey.PATH_RESOURCE.name()) + imageDetail.snapshotFilePathLine();
            } else if (lowerCaseTrimLine.startsWith(LimineKey.CMDLINE.toString())) {
                rootSubvolumePath = this.config.rootSubvolumePath();
                rootSnapshotPath = Utility.buildPath(this.config.rootSnapshotsPath(), rootSnapshotID + "/snapshot");
                kernelCmdline = this.applyKernelParameterChanges(extractValue);
                snapshotCmdline = this.replaceSubvolPath(kernelCmdline, rootSubvolumePath, rootSnapshotPath);
                cmdlineDetails.add(new CmdlineDetail(LimineKey.CMDLINE.name(), spaces, lineIndex, extractValue, snapshotCmdline, null));
                snapshotConfigLine = String.valueOf((Object)LimineKey.CMDLINE) + " " + snapshotCmdline;
            } else if (lowerCaseTrimLine.startsWith(LimineKey.KERNEL_CMDLINE.toString())) {
                rootSubvolumePath = this.config.rootSubvolumePath();
                rootSnapshotPath = Utility.buildPath(this.config.rootSnapshotsPath(), rootSnapshotID + "/snapshot");
                kernelCmdline = this.applyKernelParameterChanges(extractValue);
                snapshotCmdline = this.replaceSubvolPath(kernelCmdline, rootSubvolumePath, rootSnapshotPath);
                cmdlineDetails.add(new CmdlineDetail(LimineKey.KERNEL_CMDLINE.name(), spaces, lineIndex, extractValue, snapshotCmdline, null));
                snapshotConfigLine = String.valueOf((Object)LimineKey.KERNEL_CMDLINE) + " " + snapshotCmdline;
            } else if (lowerCaseTrimLine.startsWith(LimineKey.COMMENT.toString())) {
                optionDetails.add(new OptionDetail(LimineKey.COMMENT.name(), spaces, lineIndex, extractValue, extractValue, null));
                snapshotConfigLine = configLine;
            } else if (lowerCaseTrimLine.startsWith(LimineKey.PROTOCOL.toString())) {
                optionDetails.add(new OptionDetail(LimineKey.PROTOCOL.name(), spaces, lineIndex, extractValue, extractValue, null));
                snapshotConfigLine = configLine;
            } else {
                if (lowerCaseTrimLine.startsWith(LimineKey.SUB_ENTRY_KEY.toString())) {
                    String errMessage = "Incorrect config or some bug, an entry should not be in the kernel entry :  " + configLine.trim();
                    Utility.exitWithError(errMessage);
                    return null;
                }
                optionDetails.add(new OptionDetail(LimineKey.extractKey(configLine), spaces, lineIndex, extractValue, extractValue, null));
                snapshotConfigLine = configLine;
            }
            if (!((String)snapshotConfigLine).trim().isEmpty()) {
                snapshotBootConfigs.add((String)snapshotConfigLine);
            }
            ++lineIndex;
        }
        for (TreeNode subKernelNode : kernelNode.nodes) {
            KernelEntry subKernelEntry = this.createKernelEntry(subKernelNode, Utility.getLeadingSpaces(subKernelNode.name), rootSnapshotID, subKernelNode.configLines);
            subKernels.add(subKernelEntry);
        }
        return new KernelEntry(kernelNode.cleanName, leadingSpaces, optionDetails, imageDetails, cmdlineDetails, clearBootConfigs, subKernels, snapshotBootConfigs, null);
    }

    private ImageDetail convertToImageDetail(String limineKey, String leadingSpaces, int lineIndex, String pathLine) {
        String hashSum;
        String fileName;
        if (this.deduplicateImages.containsKey(pathLine)) {
            return this.deduplicateImages.get(pathLine);
        }
        HashMap<String, String> imageProperties = new HashMap<String, String>();
        Pattern pathResourceRegex = Pattern.compile(LimineKey.PATH_RESOURCE_PATTERN.toString());
        Pattern hashRegex = Pattern.compile(LimineKey.HASH_PATTERN.toString());
        Matcher pathResourceMatcher = pathResourceRegex.matcher(pathLine);
        Matcher hashMatcher = hashRegex.matcher(pathLine);
        String pathValue = pathLine;
        String blake2sum = "";
        if (!pathResourceMatcher.find()) {
            String errMessage = "The boot path config line is incorrect or the regular expression has some bug: " + pathLine;
            Utility.exitWithError(errMessage);
            return null;
        }
        String pathResource = pathResourceMatcher.group();
        pathValue = pathLine.substring(pathValue.indexOf(pathResource) + pathResource.length()).trim();
        if (hashMatcher.find()) {
            blake2sum = hashMatcher.group();
            pathValue = pathValue.substring(0, pathValue.indexOf(blake2sum)).trim();
        }
        String espDirPath = "";
        int lastSlashIndex = pathValue.lastIndexOf(47);
        if (lastSlashIndex == -1) {
            fileName = pathValue;
        } else {
            fileName = pathValue.substring(lastSlashIndex + 1);
            espDirPath = pathValue.substring(0, lastSlashIndex + 1);
        }
        String filePath = Utility.buildPath(this.config.espPath(), espDirPath, fileName);
        if (Utility.isFilePresent(filePath)) {
            hashSum = Utility.calculateHash(filePath);
        } else if (!Config.IS_TIME_FOR_RESTORE) {
            String errMessage = "Cannot create a kernel entry for the snapshot, as the file " + filePath + " is missing.";
            Utility.errorMessage(errMessage);
            hashSum = "is_not_available";
            this.isBootConfigValid = false;
        } else {
            hashSum = "is_not_available";
            this.isBootConfigValid = false;
        }
        String fileHashName = fileName + Config.HASH_FUNCTION.hashName + hashSum;
        String snapshotPathValue = Utility.buildPath(this.config.machineID(), "limine_history", fileHashName + blake2sum);
        imageProperties.put(LimineKey.PATH_RESOURCE.name(), pathResource);
        imageProperties.put(LimineKey.HASH.name(), blake2sum);
        ImageDetail newImage = new ImageDetail(limineKey, leadingSpaces, lineIndex, fileName, fileHashName, espDirPath, espDirPath, pathValue, snapshotPathValue, imageProperties);
        this.deduplicateImages.put(pathLine, newImage);
        return newImage;
    }

    public String replaceSubvolPath(String kernelCmdline, String subvolumePath, String snapshotPath) {
        if (!Config.KERNEL_PARAMETERS_TO_REPLACE.isEmpty()) {
            return kernelCmdline;
        }
        StringBuilder keyword = new StringBuilder();
        if (kernelCmdline.contains(LimineKey.KERNEL_CMDLINE.toString()) || kernelCmdline.contains(LimineKey.CMDLINE.toString())) {
            for (int i = 0; i < kernelCmdline.length(); ++i) {
                char c = kernelCmdline.charAt(i);
                keyword.append(c);
                if (c != ':') continue;
                kernelCmdline = kernelCmdline.substring(i + 1).trim();
                break;
            }
        }
        String[] kernelParameters = kernelCmdline.split(" ");
        boolean isRootFlagsFound = false;
        boolean isSubvolFlagFound = false;
        for (int i = 0; i < kernelParameters.length; ++i) {
            String[] rootflags = Utility.readRootFlags(kernelParameters[i]);
            if (rootflags == null) continue;
            kernelParameters[i] = "rootflags=";
            isRootFlagsFound = true;
            for (int f = 0; f < rootflags.length; ++f) {
                if (rootflags[f].startsWith("subvol=")) {
                    isSubvolFlagFound = true;
                    String subvol = rootflags[f].substring("subvol=".length());
                    if (!((subvol = Utility.buildPath(subvol)).equals(subvolumePath) || Config.IS_TIME_FOR_RESTORE || Config.USE_OPENSUSE_LAYOUT)) {
                        Utility.errorMessage("ROOT_SUBVOLUME_PATH=\"" + subvolumePath + "\" doesn't match 'subvol=" + subvol + "' in the kernel cmdline in limine.conf");
                    }
                    rootflags[f] = "subvol=" + snapshotPath;
                }
                int n = i;
                kernelParameters[n] = kernelParameters[n] + rootflags[f] + (f + 1 == rootflags.length ? "" : ",");
            }
            if (isSubvolFlagFound) continue;
            if (!Config.IS_TIME_FOR_RESTORE && !Config.USE_OPENSUSE_LAYOUT) {
                Utility.errorMessage("'subvol=" + this.config.rootSubvolumePath() + "' flag not found in the kernel cmdline in limine.conf");
            }
            if (0 < rootflags.length) {
                int n = i;
                kernelParameters[n] = kernelParameters[n] + ",subvol=" + snapshotPath;
                continue;
            }
            int n = i;
            kernelParameters[n] = kernelParameters[n] + "subvol=" + snapshotPath;
        }
        if (!isRootFlagsFound) {
            int n = kernelParameters.length - 1;
            kernelParameters[n] = kernelParameters[n] + " rootflags=subvol=" + snapshotPath;
            if (!Config.IS_TIME_FOR_RESTORE && !Config.USE_OPENSUSE_LAYOUT) {
                Utility.errorMessage("'rootflags=subvol=" + this.config.rootSubvolumePath() + "' parameter not found in the kernel cmdline in limine.conf");
            }
        }
        StringBuilder cmdline = new StringBuilder();
        cmdline.append((CharSequence)keyword);
        for (int i = 0; i < kernelParameters.length; ++i) {
            cmdline.append(kernelParameters[i]);
            if (i >= kernelParameters.length - 1) continue;
            cmdline.append(" ");
        }
        return cmdline.toString();
    }

    public boolean isBootConfigValid() {
        return this.isBootConfigValid;
    }

    public void resetBootConfigValid() {
        this.isBootConfigValid = true;
    }
}

