/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limine.snapper.formats.json1.ImageDetail;
import org.limine.snapper.formats.json1.Manifest;
import org.limine.snapper.formats.json1.SnapperEntry;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.formats.snapper.SnapperProperty;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.ConsoleColor;
import org.limine.snapper.objects.Hash;
import org.limine.snapper.objects.Output;
import org.limine.snapper.processes.Utility;

public class HistoryReader {
    public static Manifest load(String filePath) {
        if (Utility.isFilePresent(filePath)) {
            JsonMapper jsonMapper = new JsonMapper();
            jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            jsonMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true);
            try {
                return jsonMapper.readValue(new File(filePath), Manifest.class);
            }
            catch (Exception e) {
                String errMessage = "The manifest is broken or incompatible:";
                Utility.errorMessage(errMessage, e.getMessage());
                if (Utility.isFilePresent(filePath + ".old")) {
                    Utility.errorMessage("Then loading the old file from the backup:", filePath + ".old");
                    return HistoryReader.load(filePath + ".old");
                }
                System.exit(1);
                return null;
            }
        }
        Utility.ensurePathExists(filePath);
        Manifest manifest = new Manifest();
        manifest.setVersion("1.3.0");
        manifest.setLastSnapshotID(0);
        manifest.setUuid(null);
        manifest.setLastLocalTime("1970-01-01 00:00:00");
        manifest.setLastUTCTime("1970-01-01 00:00:00");
        return manifest;
    }

    public static HashSet<String> displaySnapshotList(Manifest manifest) {
        System.out.println();
        ArrayList<String[]> data = new ArrayList<String[]>();
        HashSet<String> IDs = new HashSet<String>();
        int columnWidth1 = "ID".length();
        int columnWidth2 = "Timestamp".length();
        int columnWidth3 = "Description".length();
        for (SnapshotEntry snapshot : manifest.getSnapshotEntries()) {
            String description;
            SnapperEntry entry = snapshot.snapperEntry();
            String id = String.valueOf(entry.snapshotID());
            IDs.add(id);
            if (columnWidth1 < id.length()) {
                columnWidth1 = id.length();
            }
            if (columnWidth2 < entry.localTime().length()) {
                columnWidth2 = entry.localTime().length();
            }
            if ((description = entry.properties().get(SnapperProperty.DESCRIPTION.replace)) != null) {
                if (columnWidth3 < description.length()) {
                    columnWidth3 = description.length();
                }
            } else {
                description = "";
            }
            String[] line = new String[]{id, entry.localTime(), description};
            data.add(line);
        }
        Utility.printTable(data, columnWidth1, columnWidth2, columnWidth3);
        return IDs;
    }

    public static void displayInfo(Manifest manifest, Config config) {
        String limineVersion;
        Output output;
        System.out.println();
        HistoryReader.printFormattedInfo("Version", Utility.getVersion(), true, ConsoleColor.GREEN_BOLD);
        if (Utility.isCommandPresent("limine") && (output = Utility.getTextFromCommand("limine --version", false, "")).isSuccess() && (limineVersion = HistoryReader.extractVersion(output.text().get(0))) != null && HistoryReader.isLimineMajorUnsupported(limineVersion)) {
            HistoryReader.printFormattedInfo("Limine version", limineVersion + " is not supported.", true, ConsoleColor.RED_BOLD);
        }
        HistoryReader.printFormattedInfo("Manifest version", manifest.getVersion(), true, ConsoleColor.GREEN_BOLD);
        String uuid = manifest.getUuid();
        if (uuid != null) {
            HistoryReader.printFormattedInfo("UUID", manifest.getUuid(), true, ConsoleColor.GREEN_BOLD);
        } else {
            HistoryReader.printFormattedInfo("UUID", "No UUID", true, ConsoleColor.RED_BOLD);
        }
        HistoryReader.printFormattedInfo("Last snapshot", "ID: " + manifest.getLastSnapshotID() + ", date: " + manifest.getLastLocalTime(), true, ConsoleColor.GREEN_BOLD);
        String snapshotsInfo = "" + manifest.getSnapshotEntries().size();
        if (config.maxSnapshotEntries() <= 10000) {
            snapshotsInfo = snapshotsInfo + " (max " + config.maxSnapshotEntries() + ")";
        }
        if (manifest.getSnapshotEntries().size() < config.maxSnapshotEntries()) {
            HistoryReader.printFormattedInfo("Snapshots", snapshotsInfo, true, ConsoleColor.GREEN_BOLD);
        } else {
            HistoryReader.printFormattedInfo("Snapshots", snapshotsInfo, true, ConsoleColor.YELLOW_BOLD);
        }
        double usagePercent = Utility.getUsagePercent(config.espPath());
        String usageInfo = usagePercent + "% of " + Utility.getTotalSpace(config.espPath()) + " (max " + Config.LIMIT_USAGE_PERCENT + "%)";
        if (usagePercent + 10.0 < Config.LIMIT_USAGE_PERCENT) {
            HistoryReader.printFormattedInfo("ESP usage", usageInfo, true, ConsoleColor.GREEN_BOLD);
        } else if (usagePercent + 5.0 > Config.LIMIT_USAGE_PERCENT) {
            HistoryReader.printFormattedInfo("ESP usage", usageInfo, true, ConsoleColor.RED_BOLD);
        } else {
            HistoryReader.printFormattedInfo("ESP usage", usageInfo, true, ConsoleColor.YELLOW_BOLD);
        }
        HistoryReader.verifyFiles(manifest, config);
        System.out.println();
    }

    public static void verifyFiles(Manifest manifest, Config config) {
        ArrayList<String> unusedFiles = new ArrayList<String>();
        ArrayList<String> missedFiles = new ArrayList<String>();
        ArrayList<String> corruptedFiles = new ArrayList<String>();
        HashSet<String> neededFiles = new HashSet<String>();
        for (SnapshotEntry entry : manifest.getSnapshotEntries()) {
            for (ImageDetail image : entry.allImages()) {
                neededFiles.add(image.fileHashName());
            }
        }
        String dirPath = Utility.buildPath(config.espPath(), config.machineID(), "limine_history");
        List<String> directory = Utility.collectFilesFromDirectory(dirPath);
        for (String file : directory) {
            if (neededFiles.contains(file) || "snapshots.json.old".startsWith(file)) continue;
            unusedFiles.add(file);
        }
        for (String file : neededFiles) {
            if (directory.contains(file)) {
                String filePath = Utility.buildPath(dirPath, file);
                Hash hashFunction = Hash.getHash(file);
                if (hashFunction != null) {
                    String hashcode = Utility.fileHashIntegrityCheck(filePath, hashFunction, 2);
                    if (file.endsWith(hashcode)) continue;
                    corruptedFiles.add(file);
                    continue;
                }
                corruptedFiles.add(file);
                continue;
            }
            missedFiles.add(file);
        }
        if (unusedFiles.isEmpty()) {
            HistoryReader.printFormattedInfo("Unused files", String.valueOf(0), true, ConsoleColor.GREEN_BOLD);
        } else {
            HistoryReader.printFormattedInfo("Unused files", String.valueOf(unusedFiles.size()), true, ConsoleColor.YELLOW_BOLD);
            for (String file : unusedFiles) {
                HistoryReader.printFormattedInfo("", file, false, ConsoleColor.YELLOW);
            }
        }
        if (missedFiles.isEmpty()) {
            HistoryReader.printFormattedInfo("Missed files", String.valueOf(0), true, ConsoleColor.GREEN_BOLD);
        } else {
            HistoryReader.printFormattedInfo("Missed files", String.valueOf(missedFiles.size()), true, ConsoleColor.RED_BOLD);
            for (String file : missedFiles) {
                HistoryReader.printFormattedInfo("", file, false, ConsoleColor.RED);
            }
        }
        if (corruptedFiles.isEmpty()) {
            HistoryReader.printFormattedInfo("Corrupted files", String.valueOf(0), true, ConsoleColor.GREEN_BOLD);
        } else {
            HistoryReader.printFormattedInfo("Corrupted files", String.valueOf(corruptedFiles.size()), true, ConsoleColor.RED_BOLD);
            for (String file : corruptedFiles) {
                HistoryReader.printFormattedInfo("", file, false, ConsoleColor.RED);
            }
        }
    }

    private static void printFormattedInfo(String label, String value, boolean showColon, ConsoleColor color) {
        int labelWidth = 18;
        String formattedLabel = String.format("%-" + labelWidth + "s", label);
        if (showColon) {
            System.out.println(String.valueOf((Object)color) + formattedLabel + ": " + String.valueOf((Object)ConsoleColor.RESET) + value);
        } else {
            System.out.println(String.valueOf((Object)color) + formattedLabel + "  " + String.valueOf((Object)ConsoleColor.RESET) + value);
        }
    }

    private static String extractVersion(String input) {
        Pattern versionPattern = Pattern.compile("\\b(\\d+\\.\\d+\\.\\d+)\\b");
        Matcher matcher = versionPattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isLimineMajorUnsupported(String versionString) {
        String regex = "^([0-9]+)\\.";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(versionString);
        if (matcher.find()) {
            try {
                int majorVersion = Integer.parseInt(matcher.group(1));
                return Config.UNSUPPORTED_LIMINE_MAJOR_VERSIONS.contains(majorVersion);
            }
            catch (NumberFormatException e) {
                Utility.errorMessage("Invalid version format:", versionString);
            }
        } else {
            Utility.errorMessage("No valid version format found:", versionString);
        }
        return false;
    }
}

