/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.Hash;
import org.limine.snapper.objects.Output;
import org.limine.snapper.objects.RestoreMethod;
import org.limine.snapper.processes.Utility;

public class ConfigReader {
    private final Map<String, String> configs = new HashMap<String, String>();

    public ConfigReader() {
        this.loadConfigFile("/etc/limine-snapper-sync.conf");
        this.loadConfigFile("/etc/default/limine");
        if (Config.ENABLE_TMP_CONFIG && Utility.isFilePresent("/tmp/limine-snapper-sync.conf")) {
            if (Utility.isRootOwnedFile("/tmp/limine-snapper-sync.conf")) {
                this.loadConfigFile("/tmp/limine-snapper-sync.conf");
            } else {
                Utility.warnMessage("The temporary config file /tmp/limine-snapper-sync.conf is ignored because it is not owned by root.");
            }
        }
    }

    private List<String> getKernelParams(String input) {
        String[] parts;
        ArrayList<String> params = new ArrayList<String>();
        if (input == null || input.isEmpty()) {
            return params;
        }
        for (String part : parts = input.split("\\s+")) {
            if (part.isEmpty()) continue;
            params.add(part);
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfigFile(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            String line;
            block17: while ((line = reader.readLine()) != null) {
                int eqIndex;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || (eqIndex = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, eqIndex).trim();
                String value = Utility.removeSurrounding(line.substring(eqIndex + 1).trim(), "\"");
                switch (key) {
                    case "SNAPSHOT_KERNEL_PARAMETERS+": {
                        Config.KERNEL_PARAMETERS_TO_ADD.addAll(this.getKernelParams(value));
                        continue block17;
                    }
                    case "SNAPSHOT_KERNEL_PARAMETERS-": {
                        Config.KERNEL_PARAMETERS_TO_REMOVE.addAll(this.getKernelParams(value));
                        continue block17;
                    }
                    case "SNAPSHOT_KERNEL_PARAMETERS": {
                        Config.KERNEL_PARAMETERS_TO_REPLACE.addAll(this.getKernelParams(value));
                        break;
                    }
                }
                this.configs.put(key, value);
            }
            return;
        }
        catch (IOException e) {
            Utility.exitWithError("Failed to load config file:", filePath + " due to " + e.getMessage());
        }
    }

    public Config readConfig() {
        String commands;
        String configBackupThreshold;
        String hashName;
        String snapshotFormatChoice;
        String uuid;
        String limitUsagePercent;
        String errMessage;
        String restoreMethod;
        String setSnapshotAsDefault;
        Output output;
        String espPath;
        String targetOs = this.configs.get("TARGET_OS_NAME");
        if (targetOs != null && !targetOs.isBlank()) {
            Config.TARGET_OS_NAME = Utility.cleanName(targetOs);
        }
        int maxSnapshots = Integer.MAX_VALUE;
        String maxSnapshotEntries = this.configs.get("MAX_SNAPSHOT_ENTRIES");
        if (maxSnapshotEntries == null && (maxSnapshotEntries = this.configs.get("LIMIT_NUMBER")) != null) {
            String warnMessage = "In /etc/default/limine, 'LIMIT_NUMBER' is deprecated. Use 'MAX_SNAPSHOT_ENTRIES' instead.\n";
            Utility.warnMessage(warnMessage);
        }
        if (maxSnapshotEntries != null) {
            try {
                maxSnapshots = Integer.parseInt(maxSnapshotEntries);
            }
            catch (NumberFormatException ignored) {
                Utility.errorMessage("Invalid value: MAX_SNAPSHOT_ENTRIES must be numeric and no more than 9 digits.");
            }
        }
        if ((espPath = this.configs.get("ESP_PATH")) == null && Utility.isSystemEfi() && Utility.isCommandPresent("bootctl") && (output = Utility.getTextFromCommand("bootctl --print-esp-path", false, null)).isSuccess()) {
            espPath = output.text().get(0);
        }
        if (espPath != null) {
            String limineConfigPath = Utility.buildPath(espPath = Utility.buildPath(espPath.trim()), "limine.conf");
            if (!Utility.isFilePresent(limineConfigPath)) {
                String errMessage2 = "The file: " + limineConfigPath + " is not found.";
                Utility.exitWithError(errMessage2);
                return null;
            }
        } else {
            String errMessage3 = "Please set ESP_PATH in /etc/default/limine";
            Utility.exitWithError(errMessage3);
            return null;
        }
        String rootSubvolumePath = this.configs.get("ROOT_SUBVOLUME_PATH");
        if (rootSubvolumePath != null) {
            rootSubvolumePath = !rootSubvolumePath.isBlank() ? Utility.buildPath(rootSubvolumePath) : null;
        }
        if (rootSubvolumePath == null) {
            String errMessage4 = "No ROOT_SUBVOLUME_PATH. Please set ROOT_SUBVOLUME_PATH in /etc/default/limine";
            Utility.exitWithError(errMessage4);
            return null;
        }
        String rootSnapshotsPath = this.configs.get("ROOT_SNAPSHOTS_PATH");
        if (rootSnapshotsPath != null) {
            rootSnapshotsPath = !rootSnapshotsPath.isBlank() ? Utility.buildPath(rootSnapshotsPath) : null;
        }
        if (rootSnapshotsPath == null) {
            String errMessage5 = "No ROOT_SNAPSHOTS_PATH. Please set ROOT_SNAPSHOTS_PATH in /etc/default/limine";
            Utility.exitWithError(errMessage5);
            return null;
        }
        if (!Utility.isCommandPresent("snapper")) {
            String errMessage6 = "Snapper is not installed.";
            Utility.exitWithError(errMessage6);
            return null;
        }
        String snapshotWritable = this.configs.get("SNAPSHOT_WRITABLE");
        if (snapshotWritable != null) {
            Config.SNAPSHOT_WRITABLE = "yes".equalsIgnoreCase(snapshotWritable);
        }
        if ((setSnapshotAsDefault = this.configs.get("SET_SNAPSHOT_AS_DEFAULT")) != null) {
            Config.SET_SNAPSHOT_AS_DEFAULT = "yes".equalsIgnoreCase(setSnapshotAsDefault);
        }
        if ((restoreMethod = this.configs.get("RESTORE_METHOD")) != null) {
            switch (restoreMethod) {
                case "snapper": 
                case "opensuse": {
                    Config.RESTORE_METHOD = RestoreMethod.SNAPPER;
                    break;
                }
                case "rsync": {
                    if (Utility.isCommandPresent("rsync")) {
                        Config.RESTORE_METHOD = RestoreMethod.RSYNC;
                        break;
                    }
                    errMessage = "'RESTORE_METHOD=rsync' can not be used, as command 'rsync' is not installed.";
                    Utility.errorMessage(errMessage);
                    Config.RESTORE_METHOD = RestoreMethod.REPLACE;
                    break;
                }
                case "replace": {
                    Config.RESTORE_METHOD = RestoreMethod.REPLACE;
                    break;
                }
                default: {
                    errMessage = "Invalid 'RESTORE_METHOD'. Available options: replace, rsync, snapper.";
                    Utility.errorMessage(errMessage);
                    Config.RESTORE_METHOD = RestoreMethod.REPLACE;
                    break;
                }
            }
        } else {
            String enableRsync = this.configs.get("ENABLE_RSYNC_ASK");
            if ("yes".equalsIgnoreCase(enableRsync) && Utility.isCommandPresent("rsync")) {
                Config.RESTORE_METHOD = RestoreMethod.RSYNC;
                Utility.warnMessage("Config: 'ENABLE_RSYNC_ASK=yes' is deprecated. Please set 'RESTORE_METHOD=rsync' instead");
            } else {
                Config.RESTORE_METHOD = RestoreMethod.REPLACE;
            }
        }
        Config.USE_OPENSUSE_LAYOUT = Config.RESTORE_METHOD == RestoreMethod.SNAPPER;
        String spaceNumber = this.configs.get("SPACE_NUMBER");
        if (spaceNumber != null) {
            try {
                StringBuilder spaces = new StringBuilder();
                for (int number = Integer.parseInt(spaceNumber); number > 0; --number) {
                    spaces.append(" ");
                }
                Config.SPACES = spaces.toString();
            }
            catch (NumberFormatException ignored) {
                errMessage = "Invalid value: SPACE_NUMBER must be numeric.";
                Utility.errorMessage(errMessage);
            }
        }
        if ((limitUsagePercent = this.configs.get("LIMIT_USAGE_PERCENT")) != null) {
            try {
                double percent = Double.parseDouble(limitUsagePercent);
                if (0.0 < percent && percent < 100.0) {
                    Config.LIMIT_USAGE_PERCENT = percent;
                }
            }
            catch (NumberFormatException e) {
                String errMessage7 = "Invalid value: LIMIT_USAGE_PERCENT should be from 1 to 99!";
                Utility.errorMessage(errMessage7);
            }
        }
        if ((uuid = this.configs.get("UUID")) != null && Utility.isValidUUID(uuid)) {
            Config.UUID = uuid;
        }
        if ((snapshotFormatChoice = this.configs.get("SNAPSHOT_FORMAT_CHOICE")) != null) {
            Config.SNAPSHOT_FORMAT_CHOICE = snapshotFormatChoice;
        }
        if ((hashName = this.configs.get("HASH_FUNCTION")) != null) {
            Hash hashFunction = Hash.getHashFunction(hashName);
            if (hashFunction != null && Utility.isCommandPresent(hashFunction.command)) {
                Config.HASH_FUNCTION = hashFunction;
            } else {
                String errMessage8 = "The hash function '" + hashName + "' is not found or supported.";
                Utility.errorMessage(errMessage8);
            }
        }
        if ((configBackupThreshold = this.configs.get("CONFIG_BACKUP_THRESHOLD")) != null) {
            try {
                Config.CONFIG_BACKUP_THRESHOLD = Integer.parseInt(configBackupThreshold);
            }
            catch (NumberFormatException e) {
                Utility.errorMessage("'CONFIG_BACKUP_THRESHOLD=" + configBackupThreshold + "' is invalid, it should be in hours format.");
            }
        }
        if ((commands = this.configs.get("COMMANDS_BEFORE_SAVE")) != null) {
            Config.COMMANDS_BEFORE_SAVE = commands;
        }
        if ((commands = this.configs.get("COMMANDS_AFTER_SAVE")) != null) {
            Config.COMMANDS_AFTER_SAVE = commands;
        }
        return new Config(Utility.readMachineID(), maxSnapshots, espPath, rootSubvolumePath, rootSnapshotsPath);
    }

    public void loadQuietMode() {
        Config.QUIET = "yes".equalsIgnoreCase(this.configs.get("QUIET_MODE"));
    }

    public void readSnapperConfig() {
        String snapperConfigName = this.configs.get("SNAPPER_CONFIG_NAME");
        if (snapperConfigName != null) {
            Config.SNAPPER_CONFIG_NAME = !snapperConfigName.isBlank() ? snapperConfigName : null;
        }
        if (Config.SNAPPER_CONFIG_NAME == null) {
            Config.SNAPPER_CONFIG_NAME = Utility.snapperConfigName();
        }
        if (Config.SNAPPER_CONFIG_NAME == null && Utility.areYouInBtrfs()) {
            String warnMessage = "No Snapper config found for '/'. Creating a Snapper config named 'root' and single root snapshot.";
            Utility.warnMessage(warnMessage);
            Config.SNAPPER_CONFIG_NAME = this.initSnapperConfig();
        }
        if (Config.SNAPPER_CONFIG_NAME != null) {
            Config.SNAPPER_LIST_CMDLINE = "snapper --no-headers --utc --machine-readable csv -c " + Config.SNAPPER_CONFIG_NAME + " list --disable-used-space --columns number,date,description";
        } else {
            String errMessage = Utility.areYouInBtrfs() ? "No Snapper config found for '/'. Please configure Snapper and set SNAPPER_CONFIG_NAME in /etc/default/limine." : "The '/' partition is not using Btrfs.";
            Utility.exitWithError(errMessage);
        }
    }

    private String initSnapperConfig() {
        List<String> commands = List.of("snapper -c root create-config /", "snapper -c root create --description 'limine-snapper-sync' --cleanup-algorithm number --read-only");
        if (Utility.runCommands(commands, true, true, true)) {
            return "root";
        }
        return null;
    }

    public void checkMountPaths(Config config) {
        String rootMount = Utility.getSubvolFromProcMounts("/");
        String snapMount = Utility.getSubvolFromProcMounts("/.snapshots");
        if (Config.USE_OPENSUSE_LAYOUT) {
            boolean isLayoutOpenSuse = true;
            Object errMessages = "\"RESTORE_METHOD=snapper\" cannot be used: snapper rollback is incompatible with your Btrfs layout and requires OpenSUSE-style layout.";
            errMessages = (String)errMessages + "\nOpenSUSE-style layout requires removing hardcoded 'subvol=' and 'subvolid=' kernel parameters for normal boot";
            if (rootMount == null || !rootMount.endsWith("/snapshot")) {
                errMessages = (String)errMessages + "\nOpenSUSE-style layout requires system running on a default writable snapshot, not on a root subvolume.";
                isLayoutOpenSuse = false;
            }
            if (snapMount == null || !snapMount.endsWith("/.snapshots")) {
                errMessages = (String)errMessages + "\nOpenSUSE-style layout requires '/.snapshots' subvolume permanently mounted via /etc/fstab.";
                isLayoutOpenSuse = false;
            }
            if (!isLayoutOpenSuse) {
                Utility.exitWithError((String)errMessages);
            }
        } else {
            String errMessages;
            if (rootMount != null && !rootMount.equals(config.rootSubvolumePath())) {
                errMessages = "ROOT_SUBVOLUME_PATH=\"" + config.rootSubvolumePath() + "\" doesn't match the expected path \"" + rootMount + "\" from /proc/mounts";
                errMessages = errMessages + "\nPlease set 'ROOT_SUBVOLUME_PATH=" + rootMount + "' in /etc/default/limine";
                if (!rootMount.endsWith("/snapshot")) {
                    Utility.exitWithError(errMessages);
                }
            }
            if (snapMount != null && !snapMount.equals(config.rootSnapshotsPath())) {
                errMessages = "ROOT_SNAPSHOTS_PATH=\"" + config.rootSnapshotsPath() + "\" doesn't match the expected path \"" + snapMount + "\" from /proc/mounts";
                errMessages = errMessages + "\nPlease set 'ROOT_SNAPSHOTS_PATH=" + snapMount + "' in /etc/default/limine";
                Utility.exitWithError(errMessages);
            } else if (snapMount == null) {
                String rootSubvolPath = config.rootSubvolumePath();
                if ("/".equals(rootSubvolPath)) {
                    rootSubvolPath = "";
                }
                if (!(rootSubvolPath + "/.snapshots").equals(config.rootSnapshotsPath())) {
                    String errMessages2 = "ROOT_SNAPSHOTS_PATH=\"" + config.rootSnapshotsPath() + "\" doesn't match the expected path \"" + rootSubvolPath + "/.snapshots\"";
                    errMessages2 = errMessages2 + "\nPlease set 'ROOT_SNAPSHOTS_PATH=" + rootSubvolPath + "/.snapshots' in /etc/default/limine";
                    Utility.exitWithError(errMessages2);
                }
            }
        }
    }
}

