/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.objects;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.limine.snapper.formats.limine8.LimineKey;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.EntryOptions;
import org.limine.snapper.processes.MacroReplacer;
import org.limine.snapper.processes.Utility;

public class TreeNode
implements Comparable<TreeNode> {
    public final List<String> configLines;
    public final LinkedList<TreeNode> nodes;
    public final int depth;
    public final String parentNodeName;
    public String name;
    public String cleanName;
    public boolean enableLineBreak;
    private EntryOptions options;

    public TreeNode(String name, int depth, String parentNodeName) {
        this.name = name;
        this.cleanName = Utility.cleanName(name);
        this.configLines = new ArrayList<String>();
        this.nodes = new LinkedList();
        this.depth = depth;
        this.parentNodeName = parentNodeName;
        this.enableLineBreak = false;
        this.options = null;
    }

    public void addConfigLine(String line) {
        this.configLines.add(line);
    }

    public void addNode(TreeNode node) {
        this.nodes.add(node);
    }

    public TreeNode findNodeByIDorName(Config config, String osName, int selectedDepth) {
        TreeNode node = this.findNodeByMachineID(config.machineID(), selectedDepth);
        if (node == null) {
            return this.findNodeByCleanName(osName, config.machineID(), selectedDepth);
        }
        return node;
    }

    public TreeNode findNodeByCleanName(String nodeCleanName, String machineID, int selectedDepth) {
        if (nodeCleanName == null) {
            return null;
        }
        if (nodeCleanName.isEmpty()) {
            return null;
        }
        if (0 >= selectedDepth) {
            if (Objects.equals(this.cleanName, nodeCleanName)) {
                if (this.options != null && this.options.machineID != null) {
                    if (this.options.machineID.isEmpty() || this.options.machineID.equals(machineID)) {
                        return this;
                    }
                    return null;
                }
                return this;
            }
            return null;
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            TreeNode result = node.findNodeByCleanName(nodeCleanName, machineID, selectedDepth);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TreeNode findNodeByName(String nodeName, int selectedDepth) {
        if (nodeName == null) {
            return null;
        }
        if (nodeName.isEmpty()) {
            return null;
        }
        if (0 >= selectedDepth) {
            if (this.name.trim().equals(nodeName)) {
                return this;
            }
            return null;
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            TreeNode result = node.findNodeByName(nodeName, selectedDepth);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TreeNode findNodeByMachineID(String machineID, int selectedDepth) {
        if (0 >= selectedDepth) {
            if (machineID.equals(this.getOrCreateOptions().machineID)) {
                return this;
            }
            return null;
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            TreeNode result = node.findNodeByMachineID(machineID, selectedDepth);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean searchNodeByName(String nodeName, int selectedDepth) {
        if (0 >= selectedDepth) {
            return this.name.trim().equals(nodeName);
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            if (!node.searchNodeByName(nodeName, selectedDepth)) continue;
            return true;
        }
        return false;
    }

    private EntryOptions getOrCreateOptions() {
        if (this.options == null) {
            this.options = new EntryOptions();
            for (String line : this.configLines) {
                if (!line.trim().startsWith(LimineKey.COMMENT.toString())) continue;
                this.options.parseComment(MacroReplacer.replaceMacros(line));
            }
        }
        return this.options;
    }

    public void printTree(String prefix) {
        System.out.println(prefix + this.name + " (Depth: " + this.depth + ", Parent: " + this.parentNodeName + ")");
        for (String line : this.configLines) {
            System.out.println(prefix + line);
        }
        for (TreeNode node : this.nodes) {
            node.printTree(prefix);
        }
    }

    public String toString() {
        return "TreeNode{name='" + this.name + "', configBlock=" + String.valueOf(this.configLines) + ", depth=" + this.depth + ", parentNodeName='" + this.parentNodeName + "'}";
    }

    @Override
    public int compareTo(TreeNode other) {
        return this.cleanName.compareTo(other.cleanName);
    }
}

