/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.formats.limine8;

import java.util.Map;
import java.util.Objects;

public enum LimineKey {
    COMMENT("comment:"),
    PROTOCOL("protocol:"),
    PATH("path:"),
    CMDLINE("cmdline:"),
    KERNEL_CMDLINE("kernel_cmdline:"),
    MODULE_PATH("module_path:"),
    KERNEL_PATH("kernel_path:"),
    IMAGE_PATH("image_path:"),
    UNKNOWN("unknown:"),
    ENTRY_KEY("/"),
    SUB_ENTRY_KEY("//"),
    SUB_X2_ENTRY_KEY("///"),
    SUB_X3_ENTRY_KEY("////"),
    EXPAND("+"),
    SNAPSHOTS_INSIDE_OS_NODE("//Snapshots"),
    SNAPSHOTS_OUTSIDE_OS_NODE("/Snapshots"),
    HASH("#"),
    PATH_RESOURCE("${PATH_RESOURCE}"),
    PATH_RESOURCE_PATTERN("boot\\(\\d*\\):|guid\\([^)]*\\):|hdd\\(\\d+:\\d*\\):|odd\\(\\d+:\\d*\\):|uuid\\([^)]*\\):"),
    HASH_PATTERN("#[a-fA-F0-9]*");

    private final String replace;

    private LimineKey(String replace) {
        this.replace = replace;
    }

    public static String extractValue(String input) {
        if (input == null) {
            return "";
        }
        int colonIndex = input.indexOf(58);
        return input.substring(colonIndex + 1).trim();
    }

    public static String extractKey(String input) {
        if (input == null) {
            return "";
        }
        int colonIndex = input.indexOf(58);
        return input.substring(0, colonIndex + 1).trim();
    }

    public static String replace(String key) {
        for (LimineKey value : LimineKey.values()) {
            if (UNKNOWN.equals((Object)value)) break;
            if (!value.name().equals(key)) continue;
            return value.replace;
        }
        return key;
    }

    public static String uri(Map<String, String> properties, String path) {
        String pathResource = properties.get(PATH_RESOURCE.name());
        return Objects.requireNonNullElse(pathResource, "boot():") + path;
    }

    public String toString() {
        return this.replace;
    }
}

