/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.formats.json1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.limine.snapper.processes.Utility;

public record SnapperEntry(@JsonProperty(value="snapshotID") Integer snapshotID, @JsonProperty(value="utcTime") String utcTime, @JsonProperty(value="timestamp") String localTime, @JsonProperty(value="properties") Map<String, String> properties) {
    public SnapperEntry {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        if ((utcTime == null || utcTime.isEmpty()) && localTime != null) {
            utcTime = Utility.convertLocalToUTC(localTime);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapperEntry that = (SnapperEntry)o;
        return Objects.equals(this.snapshotID, that.snapshotID) && Objects.equals(this.utcTime, that.utcTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.snapshotID, this.utcTime);
    }

    @JsonIgnore
    public String timeId() {
        return this.snapshotID + this.utcTime;
    }
}

