/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.limine.snapper.formats.json1.ImageDetail;
import org.limine.snapper.formats.json1.Manifest;
import org.limine.snapper.formats.json1.SnapperEntry;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.formats.snapper.SnapperProperty;
import org.limine.snapper.objects.Config;
import org.limine.snapper.objects.ConsoleColor;
import org.limine.snapper.objects.Output;
import org.limine.snapper.processes.HistoryReader;
import org.limine.snapper.processes.LimineReader;
import org.limine.snapper.processes.SnapperReader;
import org.limine.snapper.processes.SnapperWriter;
import org.limine.snapper.processes.Utility;

public class SnapshotManager {
    private final Config config;
    private boolean isUpdateNeeded;
    private boolean isAddingSnapshotNeeded;
    private boolean isBackupNeeded;

    public SnapshotManager(Config config) {
        this.config = config;
        this.isUpdateNeeded = false;
        this.isAddingSnapshotNeeded = false;
        this.isBackupNeeded = true;
    }

    public void sync(Manifest manifest, SnapperReader snapper) {
        String lastUTCTime = manifest.getLastUTCTime();
        if (Utility.isTimeFormatNotValid(lastUTCTime)) {
            String errMessage = "Stop the tool due to a mismatch in the UTC time format: " + lastUTCTime;
            Utility.exitWithError(errMessage);
            return;
        }
        this.update(manifest.getSnapshotEntries(), snapper.getSnapperEntries());
        SnapperEntry lastSnapperEntry = snapper.getLastSnapperEntry();
        if (snapper.getSnapperEntries().isEmpty() || lastSnapperEntry == null) {
            this.isAddingSnapshotNeeded = false;
            return;
        }
        int result = Utility.compareTimestamps(lastUTCTime, lastSnapperEntry.utcTime());
        this.isAddingSnapshotNeeded = result < 0 ? true : (result > 0 ? false : manifest.getLastSnapshotID() != lastSnapperEntry.snapshotID().intValue());
        int max = this.config.maxSnapshotEntries();
        if (this.isAddingSnapshotNeeded && max > 0) {
            --max;
        }
        this.pruneSnapshots(manifest.getSnapshotEntries(), max, snapper.getSnapperEntries().size());
    }

    private void pruneSnapshots(List<SnapshotEntry> limineSnapshots, int max, int total) {
        boolean shouldBeDeleted;
        boolean warningVisible;
        boolean bl = warningVisible = max < total && 8 == max;
        if (warningVisible) {
            Utility.warnMessage("Snapshot limit mismatch:", total + " Snapper snapshots exceed the default Limine menu limit (8)");
            Utility.infoMessage("Remove this warning by changing MAX_SNAPSHOT_ENTRIES from the default or lowering the Snapper snapshot limit.");
        }
        int index = limineSnapshots.size() - max;
        HashSet<ImageDetail> outdatedImageFiles = new HashSet<ImageDetail>();
        boolean bl2 = shouldBeDeleted = index > 0;
        if (shouldBeDeleted && warningVisible) {
            Utility.warnMessage("Snapshot limit reached:", "Time to prune older snapshots based on the configured MAX_SNAPSHOT_ENTRIES (" + max + ")");
        }
        while (index > 0) {
            SnapshotEntry limineSnapshot = limineSnapshots.get(0);
            outdatedImageFiles.addAll(limineSnapshot.allImages());
            limineSnapshots.remove(0);
            --index;
        }
        if (shouldBeDeleted) {
            this.isUpdateNeeded = true;
            this.deleteImageFiles(limineSnapshots, outdatedImageFiles);
        }
    }

    private void update(List<SnapshotEntry> limineSnapshots, HashMap<String, SnapperEntry> snapperList) {
        Iterator<SnapshotEntry> iterator = limineSnapshots.iterator();
        HashSet<ImageDetail> outdatedImageFiles = new HashSet<ImageDetail>();
        boolean shouldFilesBeDeleted = false;
        while (iterator.hasNext()) {
            String newDescription;
            SnapshotEntry limineSnapshot = iterator.next();
            SnapperEntry snapperEntry = snapperList.get(limineSnapshot.snapperEntry().timeId());
            if (snapperEntry == null) {
                outdatedImageFiles.addAll(limineSnapshot.allImages());
                iterator.remove();
                this.isUpdateNeeded = true;
                shouldFilesBeDeleted = true;
                continue;
            }
            String oldDescription = limineSnapshot.snapperEntry().properties().get(SnapperProperty.DESCRIPTION.replace);
            if (Objects.equals(oldDescription, newDescription = snapperEntry.properties().get(SnapperProperty.DESCRIPTION.replace))) continue;
            limineSnapshot.snapperEntry().properties().put(SnapperProperty.DESCRIPTION.replace, newDescription);
            this.isUpdateNeeded = true;
        }
        if (shouldFilesBeDeleted) {
            this.deleteImageFiles(limineSnapshots, outdatedImageFiles);
        }
    }

    private void deleteImageFiles(List<SnapshotEntry> limineSnapshots, HashSet<ImageDetail> outdatedImageFiles) {
        HashSet<String> allImageFiles = this.getCurrentImageFiles(limineSnapshots);
        for (ImageDetail imageDetail : outdatedImageFiles) {
            if (allImageFiles.contains(imageDetail.fileHashName())) continue;
            String targetHashFile = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
            Utility.deleteFile(targetHashFile);
        }
    }

    private HashSet<String> getCurrentImageFiles(List<SnapshotEntry> limineSnapshots) {
        HashSet<String> allImageFiles = new HashSet<String>();
        for (SnapshotEntry snapshotEntry : limineSnapshots) {
            for (ImageDetail imageDetail : snapshotEntry.allImages()) {
                allImageFiles.add(imageDetail.fileHashName());
            }
        }
        return allImageFiles;
    }

    public void historyAddSnapshot(Manifest manifest, SnapshotEntry lastSnapshotEntry) {
        if (lastSnapshotEntry.kernelEntries().isEmpty()) {
            if (!Config.IS_TIME_FOR_RESTORE) {
                String errMessage = "The Limine snapshot entry cannot be created because it has no kernel.";
                Utility.errorMessage(errMessage);
            }
            return;
        }
        for (ImageDetail imageDetail : lastSnapshotEntry.allImages()) {
            if (Config.IS_TIME_FOR_RESTORE && imageDetail.fileHashName().endsWith("is_not_available")) continue;
            String sourceFilePath = Utility.buildPath(this.config.espPath(), imageDetail.dirPath(), imageDetail.fileName());
            String targetFilePath = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
            if (Utility.isFilePresent(targetFilePath)) {
                this.repairIfCorrupted(sourceFilePath, targetFilePath);
                if (!Config.IS_TIME_FOR_RESTORE || !Utility.isFilePresent(sourceFilePath)) continue;
                Utility.deleteFile(sourceFilePath);
                continue;
            }
            this.isUpdateNeeded = true;
            if (Config.IS_TIME_FOR_RESTORE) {
                Utility.moveFile(sourceFilePath, targetFilePath, true);
                continue;
            }
            Utility.copyFile(sourceFilePath, targetFilePath, true);
        }
        manifest.getSnapshotEntries().add(lastSnapshotEntry);
        this.updateManifest(manifest, lastSnapshotEntry.snapperEntry());
    }

    public void updateManifest(Manifest manifest, SnapperEntry lastSnapperEntry) {
        manifest.setLastLocalTime(lastSnapperEntry.localTime());
        manifest.setLastUTCTime(lastSnapperEntry.utcTime());
        manifest.setLastSnapshotID(lastSnapperEntry.snapshotID());
    }

    public int checkAndSelectSnapshotID(Manifest manifest) {
        int snapshotID = Utility.validateAndGetSnapshotID();
        SnapshotEntry snapshotEntry = null;
        for (SnapshotEntry entry : manifest.getSnapshotEntries()) {
            if (entry.snapperEntry().snapshotID() != snapshotID) continue;
            snapshotEntry = entry;
            break;
        }
        if (snapshotEntry == null) {
            snapshotID = -1;
        } else {
            System.out.println(String.valueOf((Object)ConsoleColor.GREEN_BOLD) + "Snapshot ID : " + String.valueOf((Object)ConsoleColor.RESET) + snapshotID);
            System.out.println(String.valueOf((Object)ConsoleColor.GREEN_BOLD) + "Date        : " + String.valueOf((Object)ConsoleColor.RESET) + snapshotEntry.snapperEntry().localTime());
            System.out.println(String.valueOf((Object)ConsoleColor.GREEN_BOLD) + "Description : " + String.valueOf((Object)ConsoleColor.RESET) + snapshotEntry.snapperEntry().properties().get(SnapperProperty.DESCRIPTION.replace));
        }
        if (snapshotID > 0) {
            boolean isConfirmed = Utility.askUser("\n Confirm that you want to restore snapshot ID: " + snapshotID + "?\n If no, all Limine snapshots will be displayed for selection.\n Type \"[y]es\" to confirm, \"[n]o\" to list available snapshots, or \"[c]ancel\" to abort the restore.\n");
            if (!isConfirmed) {
                snapshotID = this.selectSnapshot(manifest);
            }
        } else {
            snapshotID = this.selectSnapshot(manifest);
        }
        return snapshotID;
    }

    public SnapshotEntry restore(Manifest manifest, LimineReader limineReader) {
        String sourceFilePath;
        String errMessage;
        String errMessage2;
        String backupSubvolumeDirPath;
        boolean isSnapshot;
        boolean areYouInSnapshot = Utility.areYouInSnapshot();
        int snapshotID = this.checkAndSelectSnapshotID(manifest);
        SnapshotEntry limineEntry = limineReader.createCurrentLimineEntry();
        SnapshotEntry snapshotEntry = null;
        for (SnapshotEntry entry : manifest.getSnapshotEntries()) {
            if (entry.snapperEntry().snapshotID() != snapshotID) continue;
            snapshotEntry = entry;
            break;
        }
        if (snapshotEntry == null) {
            String errMessage3 = "No snapshot " + snapshotID + " is found";
            Utility.errorMessage(errMessage3);
            return null;
        }
        boolean isRsyncInstalled = Utility.isCommandPresent("rsync");
        boolean bl = Config.ENABLE_RSYNC_ASK = Config.ENABLE_RSYNC_ASK && isRsyncInstalled;
        if (Config.ENABLE_RSYNC_ASK) {
            boolean isRsyncEnabled = Utility.askUser(" \n Do you want to use \"rsync\" for restore?\n If not, \"btrfs\" restore will be used.\n Type \"[y]es\", \"[n]o\", or \"[c]ancel\" to abort the restore.\n ");
            if (isRsyncEnabled) {
                this.isBackupNeeded = Utility.askUser(" \n Do you want to create a new \"backup\" snapshot before starting rsync?\n Type \"[y]es\", \"[n]o\", or \"[c]ancel\" to abort the restore.\n ");
            } else {
                Config.ENABLE_RSYNC_ASK = false;
            }
        }
        if (!this.predictSpaceUsage(limineEntry, snapshotEntry)) {
            String errMessage4 = "Stopping restore to prevent the ESP from running out of space, which could break restored boot files.";
            Utility.errorMessage(errMessage4);
            return null;
        }
        String mountDir = "/run/lss/";
        String timestamp = Utility.getCurrentIsoFormattedTime();
        String subvolumePath = Utility.removeSurroundingSlashes(this.config.rootSubvolumePath());
        String backupSubvolume = subvolumePath + "_backup_" + timestamp;
        String newSubvolume = subvolumePath + "_lss_" + timestamp;
        String snapshotPath = Utility.removeSurroundingSlashes(this.config.rootSnapshotsPath());
        String backupDescription = "Backup";
        String uuid = Config.UUID != null ? Config.UUID : manifest.getUuid();
        if (!Config.ENABLE_RSYNC_ASK && subvolumePath.isEmpty()) {
            String errMessage5 = " \nError: No root subvolume detected. You are using the entire volume as the root partition.\n Btrfs restore isn't supported by this Btrfs layout without a root subvolume.\n\n Possible solution:\n 1. Install 'rsync'\n 2. Set 'ENABLE_RSYNC_ASK=yes' in /etc/default/limine or /tmp/limine-snapper-sync.conf\n 3. Retry the restore, this will use 'rsync' instead of 'btrfs'\n \n";
            Utility.errorMessage(errMessage5);
            return null;
        }
        if (this.isBackupNeeded && (backupDescription = Utility.userInput("\n Enter a description for the \"backup\" of the subvolume: " + subvolumePath)).isEmpty()) {
            backupDescription = "Backup";
        }
        List<CallSite> commands = List.of("mount -t btrfs -o subvol=/ /dev/disk/by-uuid/" + uuid + " " + mountDir);
        Utility.infoMessage("\nTime to start mounting Btrfs.");
        if (!Utility.ensureDirectoryExists(mountDir)) {
            return null;
        }
        if (!Utility.runCommands(commands, true, true, true)) {
            String errMessage6 = "Failed to mount " + mountDir;
            Utility.errorMessage(errMessage6);
            Utility.runCommand("umount " + mountDir, false, false);
            return null;
        }
        ArrayList<String> childSubvolumePaths = new ArrayList<String>();
        String btrfsCommand = "btrfs subvolume list -o '" + Utility.buildPath(mountDir, subvolumePath) + "'";
        Output subvolumePathsOutput = Utility.getTextFromCommand(btrfsCommand, true, null);
        if (subvolumePathsOutput.isSuccess()) {
            for (String fullLine : subvolumePathsOutput.text()) {
                String path = "";
                int index = fullLine.indexOf(subvolumePath + File.separator);
                if (index != -1) {
                    path = fullLine.substring(index + subvolumePath.length() + 1);
                }
                if (!path.isEmpty()) {
                    childSubvolumePaths.add(path);
                    continue;
                }
                if (fullLine.isBlank()) continue;
                String errMessage7 = "The output format of '" + btrfsCommand + "' was changed. Please report the issue.";
                Utility.errorMessage(errMessage7);
                return null;
            }
        }
        if ((isSnapshot = Utility.isDirectoryPresent(Utility.buildPath(mountDir, snapshotPath, snapshotID + "/snapshot/"))) && Config.ENABLE_RSYNC_ASK) {
            StringBuilder excludes = new StringBuilder();
            if (!childSubvolumePaths.isEmpty()) {
                excludes.append(" --exclude={");
                for (int i = 0; i < childSubvolumePaths.size(); ++i) {
                    excludes.append("'/").append((String)childSubvolumePaths.get(i)).append("'");
                    if (i >= childSubvolumePaths.size() - 1) continue;
                    excludes.append(",");
                }
                excludes.append("}");
            }
            String snapshotDirPath = Utility.buildPath(mountDir, snapshotPath, snapshotID + "/snapshot") + File.separator;
            subvolumeDirPath = Utility.buildPath(mountDir, subvolumePath) + File.separator;
            String rsyncCmdline = "rsync -aAhHxX --delete --verbose " + String.valueOf(excludes) + " '" + snapshotDirPath + "' '" + (String)subvolumeDirPath + "'";
            commands = this.isBackupNeeded ? List.of("btrfs subvolume snapshot '" + Utility.buildPath(mountDir, subvolumePath) + "' '" + Utility.buildPath(mountDir, backupSubvolume) + "'", rsyncCmdline) : List.of(rsyncCmdline);
            if (this.isSubvolumeReadOnly((String)subvolumeDirPath)) {
                Utility.warnMessage("WARNING:", "The subvolume '" + subvolumePath + "' is read-only. Rsync must be stopped.");
                return null;
            }
        } else if (isSnapshot) {
            String snapshotDirPath = Utility.buildPath(mountDir, snapshotPath, snapshotID + "/snapshot");
            String newSubvolumeDirPath = Utility.buildPath(mountDir, newSubvolume);
            subvolumeDirPath = Utility.buildPath(mountDir, subvolumePath);
            backupSubvolumeDirPath = Utility.buildPath(mountDir, backupSubvolume);
            commands = List.of("btrfs subvolume snapshot '" + snapshotDirPath + "' '" + newSubvolumeDirPath + "'", "mv '" + (String)subvolumeDirPath + "' '" + backupSubvolumeDirPath + "'", "mv '" + newSubvolumeDirPath + "' '" + (String)subvolumeDirPath + "'");
            if (this.isSubvolumeReadOnly((String)subvolumeDirPath)) {
                Utility.warnMessage("WARNING:", "The subvolume '" + subvolumePath + "' is read-only. It will be unlocked so restoration can continue.");
                this.setSubvolumeProperty((String)subvolumeDirPath, false);
            }
        } else {
            errMessage2 = "It does not support your Btrfs layout without Snapper.";
            Utility.errorMessage(errMessage2);
            return null;
        }
        Utility.infoMessage("Time to start restoring snapshot ID: " + snapshotID);
        if (!Utility.runCommands(commands, true, true, true)) {
            if (!Config.ENABLE_RSYNC_ASK && Utility.isDirectoryPresent(Utility.buildPath(mountDir, backupSubvolume))) {
                List<CallSite> revert;
                if (Utility.isDirectoryPresent(Utility.buildPath(mountDir, subvolumePath))) {
                    String subvolumeDirPath = Utility.buildPath(mountDir, subvolumePath);
                    String newSubvolumeDirPath = Utility.buildPath(mountDir, newSubvolume);
                    backupSubvolumeDirPath = Utility.buildPath(mountDir, backupSubvolume);
                    revert = List.of("mv '" + (String)subvolumeDirPath + "' '" + newSubvolumeDirPath + "'", "mv '" + backupSubvolumeDirPath + "' '" + (String)subvolumeDirPath + "'");
                } else {
                    revert = List.of("mv '" + Utility.buildPath(mountDir, backupSubvolume) + "' '" + Utility.buildPath(mountDir, subvolumePath) + "'");
                }
                Utility.runCommands(revert, true, true, true);
            }
            errMessage2 = "Failed to restore.";
            Utility.errorMessage(errMessage2);
            return null;
        }
        if (!Config.ENABLE_RSYNC_ASK) {
            if (Config.SET_SNAPSHOT_AS_DEFAULT) {
                String setDefaultSubvolumeCommand = "btrfs subvolume set-default '" + Utility.buildPath(mountDir, subvolumePath) + "'";
                Utility.runCommand(setDefaultSubvolumeCommand, true, true);
            }
            ArrayList<String> movedChildSubvolumeCommands = new ArrayList<String>();
            for (String childSubvolumePath : childSubvolumePaths) {
                String sourceDirPath = Utility.buildPath(mountDir, backupSubvolume, childSubvolumePath);
                String extractDirectoryPath = Utility.extractParentDirectoryPath(childSubvolumePath);
                String targetDirPath = Utility.buildPath(mountDir, subvolumePath, extractDirectoryPath) + File.separator;
                movedChildSubvolumeCommands.add("mv '" + sourceDirPath + "' '" + targetDirPath + "'");
            }
            if (!movedChildSubvolumeCommands.isEmpty()) {
                Utility.infoMessage("Time to move all child subvolumes back to the parent subvolume: " + subvolumePath);
                if (!Utility.runCommands(movedChildSubvolumeCommands, false, true, true)) {
                    errMessage = "Failed to moved the child subvolumes.";
                    Utility.errorMessage(errMessage);
                }
            }
        }
        if (this.isBackupNeeded) {
            Utility.infoMessage("Time to add the \"" + backupDescription + "\" entry to the Snapper list and Limine snapshot list.");
            int latestSnapshotID = Utility.findLatestSnapperNumber(Utility.buildPath(mountDir, snapshotPath));
            if (latestSnapshotID < 1) {
                errMessage = "Oops, but after the restore there is no snapshot in the Snapper list. That is strange.";
                Utility.errorMessage(errMessage);
            } else {
                latestSnapshotID = areYouInSnapshot ? ++latestSnapshotID : (latestSnapshotID += 2);
                String backupSubvolumeDirPath2 = Utility.buildPath(mountDir, backupSubvolume);
                String newSnapshotDirPath = Utility.buildPath(mountDir, snapshotPath, String.valueOf(latestSnapshotID));
                Utility.ensureDirectoryExists(newSnapshotDirPath);
                List<CallSite> moveSubvolumeToSnapper = List.of("mv '" + backupSubvolumeDirPath2 + "' '" + newSnapshotDirPath + "/snapshot'");
                if (Utility.runCommands(moveSubvolumeToSnapper, false, true, true)) {
                    this.setSubvolumeProperty("'" + newSnapshotDirPath + "/snapshot'", !Config.SNAPSHOT_WRITABLE);
                    String utcTime = Utility.getCurrentUTCTime();
                    SnapperWriter.writeInfoXml(latestSnapshotID, utcTime, backupDescription, newSnapshotDirPath + "/info.xml");
                    String localTime = Utility.convertUTCtoLocal(utcTime);
                    SnapperEntry snapperEntry = new SnapperEntry(latestSnapshotID, utcTime, localTime, null);
                    snapperEntry.properties().put(SnapperProperty.DESCRIPTION.replace, backupDescription);
                    SnapshotEntry backupEntry = limineReader.createCurrentLimineEntry(snapperEntry);
                    this.historyAddSnapshot(manifest, backupEntry);
                } else {
                    String errMessage8 = "Failed to move the \"backup\" snapshot to the Snapper list.";
                    Utility.errorMessage(errMessage8);
                }
            }
        } else {
            for (ImageDetail imageDetail : limineEntry.allImages()) {
                if (imageDetail.fileHashName().endsWith("is_not_available") || !Utility.isFilePresent(sourceFilePath = Utility.buildPath(this.config.espPath(), imageDetail.dirPath(), imageDetail.fileName()))) continue;
                String targetFilePath = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
                this.repairIfCorrupted(sourceFilePath, targetFilePath);
                Utility.deleteFile(sourceFilePath);
            }
        }
        Utility.infoMessage("Time to restore matching kernel versions.");
        for (ImageDetail imageDetail : snapshotEntry.allImages()) {
            if (imageDetail.fileHashName().endsWith("is_not_available")) continue;
            sourceFilePath = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
            String targetDirPath = Utility.buildPath(this.config.espPath(), imageDetail.dirPath()) + File.separator;
            Utility.ensureDirectoryExists(targetDirPath);
            String targetFilePath = targetDirPath + imageDetail.fileName();
            if (Utility.isFilePresent(targetFilePath)) {
                String hashCode = Utility.calculateHash(targetFilePath);
                if (imageDetail.fileHashName().endsWith(hashCode)) continue;
                Utility.copyFile(sourceFilePath, targetFilePath, true);
                continue;
            }
            Utility.copyFile(sourceFilePath, targetFilePath, true);
        }
        limineEntry.kernelEntries().clear();
        limineEntry.kernelEntries().addAll(snapshotEntry.kernelEntries());
        return limineEntry;
    }

    private void repairIfCorrupted(String sourceFilePath, String targetFilePath) {
        String hashCode;
        if (Utility.isFilePresent(targetFilePath) && !targetFilePath.endsWith(hashCode = Utility.calculateHash(targetFilePath))) {
            Utility.copyFile(sourceFilePath, targetFilePath, true);
            String errMessage = "A corrupted file was detected at: '" + targetFilePath + "' and has been replaced with a healthy one.";
            Utility.errorMessage(errMessage);
        }
    }

    private int selectSnapshot(Manifest manifest) {
        String input;
        HashSet<String> IDs = HistoryReader.displaySnapshotList(manifest);
        while (true) {
            if (IDs.contains((input = Utility.userSelect(" \n Which snapshot ID do you want to restore?\n Type an ID or \"[c]ancel\" to abort the restore.\n ")).trim())) break;
            System.err.println(String.valueOf((Object)ConsoleColor.RED) + "Selected ID is invalid or not available: " + String.valueOf((Object)ConsoleColor.RESET) + input);
        }
        int selectedID = Integer.parseInt(input.trim());
        return selectedID;
    }

    public boolean predictSpaceUsage(SnapshotEntry currentEntry) {
        HashSet<String> addedFilePaths = new HashSet<String>();
        for (ImageDetail imageDetail : currentEntry.allImages()) {
            String snapshotFilePath = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
            if (Utility.isFilePresent(snapshotFilePath)) continue;
            String filePath = Utility.buildPath(this.config.espPath(), imageDetail.dirPath(), imageDetail.fileName());
            addedFilePaths.add(filePath);
        }
        return Utility.doesPartitionHaveSpace(Config.LIMIT_USAGE_PERCENT, this.config.espPath(), addedFilePaths, new HashSet<String>());
    }

    private boolean predictSpaceUsage(SnapshotEntry currentEntry, SnapshotEntry snapshotEntry) {
        HashSet<String> addedFilePaths = new HashSet<String>();
        HashSet<String> deletedFilePaths = new HashSet<String>();
        for (ImageDetail imageDetail : currentEntry.allImages()) {
            String filePath = Utility.buildPath(this.config.espPath(), imageDetail.dirPath(), imageDetail.fileName());
            if (this.isBackupNeeded) {
                String snapshotFilePath = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
                if (!Utility.isFilePresent(filePath) || !Utility.isFilePresent(snapshotFilePath)) continue;
                deletedFilePaths.add(filePath);
                continue;
            }
            if (!Utility.isFilePresent(filePath)) continue;
            deletedFilePaths.add(filePath);
        }
        for (ImageDetail imageDetail : snapshotEntry.allImages()) {
            String snapshotFilePath = Utility.buildPath(this.config.espPath(), this.config.machineID(), "limine_history", imageDetail.fileHashName());
            if (!Utility.isFilePresent(snapshotFilePath)) continue;
            addedFilePaths.add(snapshotFilePath);
        }
        return Utility.doesPartitionHaveSpace(100.0, this.config.espPath(), addedFilePaths, deletedFilePaths);
    }

    private void setSubvolumeProperty(String subvolumePath, boolean readOnly) {
        Utility.runCommand("btrfs property set '" + subvolumePath + "' ro " + readOnly, false, false);
    }

    private boolean isSubvolumeReadOnly(String subvolumePath) {
        Output output = Utility.getTextFromCommand("btrfs property get '" + subvolumePath + "' ro", true, null);
        if (output.isSuccess() && !output.text().isEmpty()) {
            return output.text().get(0).contains("true");
        }
        return false;
    }

    public boolean checkUpdate() {
        return this.isUpdateNeeded || this.isAddingSnapshotNeeded;
    }

    public boolean isAllowedToAddSnapshot() {
        return this.isAddingSnapshotNeeded;
    }

    public boolean isBackupNeeded() {
        return this.isBackupNeeded;
    }
}

