/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.io.FileWriter;
import org.limine.snapper.processes.Utility;

public class SnapperWriter {
    public static void writeInfoXml(int snapshotID, String utcTime, String description, String filePath) {
        String content = SnapperWriter.buildXml(snapshotID, utcTime, description);
        try (FileWriter writer = new FileWriter(filePath);){
            writer.write(content);
            Utility.infoMessage("Saved", filePath);
        }
        catch (Exception e) {
            Utility.errorMessage("Save failed", filePath);
            Utility.errorMessage("Reason", e.getMessage());
        }
    }

    private static String buildXml(int snapshotID, String utcTime, String description) {
        return "<?xml version=\"1.0\"?>\n<snapshot>\n  <type>single</type>\n  <num>" + snapshotID + "</num>\n  <date>" + utcTime + "</date>\n  <description>" + SnapperWriter.escapeXml(description) + "</description>\n</snapshot>\n";
    }

    private static String escapeXml(String input) {
        StringBuilder sb = new StringBuilder();
        block7: for (char c : input.toCharArray()) {
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

