/*
 * Decompiled with CFR 0.152.
 */
package org.limine.snapper.processes;

import java.util.List;
import org.limine.snapper.formats.json1.Manifest;
import org.limine.snapper.formats.json1.SnapperEntry;
import org.limine.snapper.formats.json1.SnapshotEntry;
import org.limine.snapper.processes.Utility;

public class FormatConverter {
    public static boolean upgradeManifest(Manifest manifest) {
        if ("1.3.0".equals(manifest.getVersion())) {
            return false;
        }
        if ("1.0.0".equals(manifest.getVersion())) {
            FormatConverter.upgradeToV110(manifest);
            Utility.infoMessage("The manifest version 1.0.0 upgraded to " + manifest.getVersion());
        }
        if ("1.1.0".equals(manifest.getVersion())) {
            FormatConverter.upgradeToV120(manifest);
            Utility.infoMessage("The manifest version 1.1.0 upgraded to " + manifest.getVersion());
        }
        if ("1.2.0".equals(manifest.getVersion())) {
            FormatConverter.upgradeToV130(manifest);
            Utility.infoMessage("The manifest version 1.2.0 upgraded to " + manifest.getVersion());
        }
        return true;
    }

    private static void upgradeToV110(Manifest manifest) {
        List<SnapshotEntry> snapshotEntries = manifest.getSnapshotEntries();
        for (int i = 0; i < snapshotEntries.size(); ++i) {
            SnapshotEntry snapshotEntry = snapshotEntries.get(i);
            SnapperEntry snapperEntry = snapshotEntry.snapperEntry();
            if (snapperEntry.utcTime() != null && !snapperEntry.utcTime().isEmpty()) continue;
            SnapperEntry updatedSnapperEntry = new SnapperEntry(snapperEntry.snapshotID(), Utility.convertLocalToUTC(snapperEntry.localTime()), snapperEntry.localTime(), snapperEntry.properties());
            snapshotEntries.set(i, new SnapshotEntry(updatedSnapperEntry, snapshotEntry.kernelEntries(), snapperEntry.properties()));
        }
        manifest.setLastUTCTime(Utility.convertLocalToUTC(manifest.getLastLocalTime()));
        manifest.setVersion("1.1.0");
    }

    private static void upgradeToV120(Manifest manifest) {
        manifest.setVersion("1.2.0");
    }

    private static void upgradeToV130(Manifest manifest) {
        manifest.setVersion("1.3.0");
    }
}

