# limine-entry-tool

### Contents

- [Description](#description)
- [Usage](#usage)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Planned version 2.0.0](#donate)

## Description

This tool manages boot entries for the Limine bootloader on UEFI systems. It can create, update, or delete boot entries.

**Note:** 
Legacy BIOS, ARM, and RISC-V are also supported, but with limited functionality:

* Automatic EFI binary deployment is disabled.
* UKI auto-generation is disabled.
* Automatic config enrollment is disabled.
* UEFI entry scanning is not supported.

## Usage

<details>
<summary>Add UEFI boot entries (e.g., dual boot)</summary>

```shell
limine-entry-tool --scan
```
This scans all active UEFI entries from NVRAM, allowing you to select one to add to Limine.

`limine-scan` is an alias for this command. 

</details>

<details>
<summary>Create or update kernel entry under OS</summary>

```shell
limine-entry-tool --add "<kernel name>" "<path to initramfs>" "<path to vmlinuz>" "<any suffix name>" --comment "<any comment>" --quiet
```
**Note:** The `<kernel name>` must follow FAT32 naming rules (letters, digits, `_`,`.`,`-` only).
Spaces or other special characters are not allowed, as the name is used to creates a FAT32 directory.

**Examples:**
```shell
# Create a boot entry for "kernel-6.10.1":
limine-entry-tool --add "kernel-6.10.1" "/tmp/initramfs" "/usr/lib/modules/6.10.1/vmlinuz"

# Create a boot entry for "kernel-6.10.1" with a "-fallback" suffix:
limine-entry-tool --add "kernel-6.10.1" "/tmp/initramfs-fallback" "/usr/lib/modules/6.10.1/vmlinuz" "-fallback"
```
These create (or update) a kernel boot entry named `kernel-6.10.1` under its OS entry,
and copy the files (`initramfs`,`initramfs-fallback` and `vmlinuz`) to the directory `$ESP_PATH/${machine_id}/kernel-6.10.1/`.

</details>

<details>
<summary>Create or update UKI entry under OS</summary>

```shell
limine-entry-tool --add-uki "<kernel name>" "<path to UKI>" --comment "<any comment>"  --quiet
```
**Note:** The `<kernel name>` must follow FAT32 naming rules (letters, digits, `_`,`.`,`-` only).
Spaces or other special characters are not allowed, as the name is used to creates a FAT32 file.

**Example:**
```sh
limine-entry-tool --add-uki "kernel-6.12.1" "/tmp/uki.img"
```
This creates (or updates) a UKI boot entry named `kernel-6.12.1` under its OS entry,
and copies the UKI file to `$ESP_PATH/EFI/Linux/${machine_id}_kernel-6.12.1.efi`.

</details>

<details>
<summary>Create or update EFI boot entry</summary>

```shell
limine-entry-tool --add-efi "<EFI entry name>" "<path to EFI loader file>" --comment "<Any comment>" --priority "<Number>" --overwrite --quiet
```

Arguments:

- `--priority <Number>`: Set position in the boot order (default: **50**, middle of range)
- `--overwrite`: Replace existing entry if present

**Example:**
```shell
limine-entry-tool --add-efi "Default fallback loader" "/boot/EFI/BOOT/BOOTX64.EFI" --priority 10
```
Adds an EFI boot entry to limine.conf.<br>
If an entry with the same name exists, it will not be overwritten.

</details>

<details>
<summary>Remove kernel entry under OS</summary>

```shell
limine-entry-tool --remove "<kernel name>" --quiet
# Example:
limine-entry-tool --remove "kernel-6.10.1"
```

This removes kernel entry under OS entry and its directory `$ESP_PATH/${machine_id}/<kernel name>/` if present.

</details>

<details>
<summary>Remove UKI entry under OS</summary>

```sh
limine-entry-tool --remove-uki "<kernel name>" --quiet
# Example:
limine-entry-tool --remove-uki "kernel-6.10.1"
```

This removes UKI boot entry under OS entry and its UKI file at `$ESP_PATH/EFI/Linux/${machine_id}_<kernel name>.efi` if present

</details>

<details>
<summary>Remove boot entry under OS (keep its files)</summary>

```shell
limine-entry-tool --remove-entry "<kernel name>" --quiet
# Example:
limine-entry-tool --remove-entry "kernel-6.10.1"
```

This removes a boot entry under its OS entry while **keeping its files and directory**.

</details>

<details>
<summary>Remove EFI entry</summary>

```shell
limine-entry-tool --remove-efi "<path to an EFI file>"
# Example:
limine-entry-tool --remove-efi "/boot/EFI/BOOT/BOOTX64.EFI"
```

This removes any EFI boot entries matching the specified EFI file path.<br>
**Note:** This keeps the EFI file.

</details>

<details>
<summary>Remove OS entry</summary>

```shell
limine-entry-tool --remove-os "<OS name or machine-ID>"
# Examples:
limine-entry-tool --remove-os "Arch Linux"
limine-entry-tool --remove-os "d647abee5e264f469d7a38b751d9d1db"
```
This removes an OS entry matching the specified machine-ID or OS name.

</details>

## Requirements

* Limine version **8** or newer
* A FAT32 boot partition with at least 1 GiB of free space
* Java runtime version 17 or newer
* Standard `coreutils` and `util-linux`
* `bash`, `grep` and `tar` must be installed
* `efibootmgr` for UEFI boot entry registration (but not required on legacy BIOS systems)

## Installation

**Note:**<br>

This automation generates only the default at `$ESP_PATH/limine.conf` and does not touch any other Limine config locations.
If you plan to use `$ESP_PATH/limine.conf` as the default Limine boot config,
remove any other alternative Limine config files to prevent them from overriding the default in the Limine boot menu.

<details>
<summary>Some UEFI motherboards (e.g., certain MSI models) may not be fully compatible</summary>

Some motherboards implement EFI in a non-standard or broken way.
This can prevent tools like `efibootmgr` or kernel-based UEFI detection from working correctly.<br>

**How to fix:**<br>

**Step 1:** Skip UEFI detection and make Limine the default bootloader:
```sh
limine-install --skip-uefi --fallback
```
**Step 2:** Make it permanent, create or edit `/etc/default/limine` and add:
```ini
SKIP_UEFI=yes
ENABLE_LIMINE_FALLBACK=yes
```
**Step 3:** Adjust BIOS boot order<br>
Restart your system, enter the BIOS setup, and set the correct boot partition (the standard EFI path) as the default boot option.
</details>

### Arch Linux

<details>
<summary>Easy setup</summary>

1. Install one of the following packages:
   * [limine-dracut-support](https://aur.archlinux.org/packages/limine-dracut-support/) for Dracut
   * [limine-mkinitcpio-hook](https://aur.archlinux.org/packages/limine-mkinitcpio-hook/) for mkinitcpio <br />
These packages provide hooks to automatically manage kernel installation and removal via `limine-entry-tool`.
2. Create or edit `/etc/default/limine` (You can optionally copy default settings from `/etc/limine-entry-tool.conf`):
   * Check if your ESP is detected by `bootctl --print-esp-path`:
      * If detected, no further configuration is required.
      * If not detected, set `ESP_PATH=` to point to any FAT32 boot partition of your choice, then run `limine-install` to verify.
   * (Optional) Set your kernel parameters:
      ```
      KERNEL_CMDLINE[default]+="<your kernel options>"
      ```
      (If unsure, copy them from `cat /proc/cmdline` but make sure you are running on your actual installed system, not from a live ISO.)
   * (Optional) Enable UKI creation by adding:
      ```
      ENABLE_UKI=yes
      ```
   * (Optional) Set Limine as the default fallback bootloader in case UEFI boot entries stored in NVRAM are lost or wiped 
      (e.g., due to UEFI firmware or BIOS updates): 
      ```
      ENABLE_LIMINE_FALLBACK=yes
      ```
      Alternatively, run `limine-install --fallback` in a terminal.
      
3. Run `limine-update` to regenerate initramfs or UKIs and add (update) kernel boot entries to Limine.
4. (Optional) Run `limine-scan` to detect existing UEFI boot entries (dual-boot) and add them to Limine.
5. (Optional) Install `kernel-modules-hook` to safely preserve a kernel in case of kernel upgrade failure or power outage.

**Note:**
* On UEFI (x86_64) systems, Limine is automatically deployed during updates or reinstallation.
* On legacy BIOS systems, you must manually copy an appropriate Limine binary to your boot partition.
Follow the instructions: [Limine – BIOS systems](https://wiki.archlinux.org/title/Limine#BIOS_systems_with_MBR)

</details>

**or**

<details>
<summary>Manual setup (for advanced users)</summary>

1. Install `limine-entry-tool` from [AUR](https://aur.archlinux.org/packages/limine-entry-tool/).<br/>
This tool provides full control, but does not include automatic kernel & initramfs handling.
1. Create or edit `/etc/default/limine` (You can optionally copy default settings from `/etc/limine-entry-tool.conf`):
   * Run `bootctl --print-esp-path` to check if an ESP path is detected:
      * If not detected, set `ESP_PATH=` to the path of any FAT32 boot partition of your choice.
   * Set `KERNEL_CMDLINE[default]=` with your preferred kernel parameters.
1. Install an initramfs tool of your choice (e.g., `mkinitcpio`, `dracut`, `booster`, or another preferred tool).
1. **Create your own script and pacman hooks** to automate the addition and removal of kernels 
   using `limine-entry-tool` with different options.
1. Deploy the Limine EFI binary to your ESP by running `limine-install` <br/>
This installs Limine to `$ESP_PATH/EFI/limine/limine_x86.efi` (for x86_64 UEFI systems).
1. (Optional) Run `limine-install --fallback` to make Limine the default fallback bootloader.
1. (Optional) Run `limine-scan` to detect existing UEFI boot entries (dual-boot) and add them to Limine.

</details>

### Other Linux distributions

There are no pre-built packages for various package managers.
Package maintainers are welcome to create them.

**Note:** This setup below is not suitable for NixOS and some immutable distros as they do not
follow [FHS](https://en.wikipedia.org/wiki/Filesystem_Hierarchy_Standard).

<details>
<summary>Manual installation</summary>

1. Install `limine` and deploy it to your boot partition manually.
2. Clone the repository:
    ```shell
    git clone https://gitlab.com/Zesko/limine-entry-tool.git
    cd limine-entry-tool
    ```
3. Build the project
    ```shell
    mvn clean package
    ```
4. Install the necessary files:
    ```shell
    cp target/limine-entry-tool.jar /usr/share/java/
    cp install/arch-linux/limine-entry-tool/usr/bin/limine* /usr/local/bin/
    cp -r install/arch-linux/limine-entry-tool/usr/lib/limine /usr/lib/
    ```
5. Create or edit a file `/etc/default/limine` and set: 
    ```
    ESP_PATH=/path/to/esp
    KERNEL_CMDLINE[default]="<Copy your kernel parameters from /proc/cmdline>"
    LIMINE_BINARY_PATH=/usr/share/limine/BOOTX64.EFI
    ```
   * Replace `/path/to/esp` with your actual boot partition (ESP) mount point (must be FAT32).
   * `LIMINE_BINARY_PATH=` is the path to Limine EFI binary that will be copied to the ESP by `limine-install` for UEFI.
6. Write your own automation script (or use system hooks) to invoke `limine-entry-tool`
for creating or removing boot entries when kernels are installed or removed.
7. Run `limine-install` to copy the Limine EFI binary to the ESP.

</details>

## Configuration

Copy this to `/etc/default/limine` and configure it.

```properties
### OS Entry Targeting
### If TARGET_OS_NAME is not set, the tool will generate a new OS entry with the default distro name and machine-ID.
### Alternatively, you can add "comment: machine-id=${machine_id}" to your OS entry block in '$ESP_PATH/limine.conf'.
### The machine-ID helps the tool to automatically target the OS entry. Changing the OS name does not matter.
#TARGET_OS_NAME="Arch Linux"


### Boot Partition Path
### Specify the mount path of your boot partition if you are running on legacy BIOS, ARM, or RISC-V.
### Note: 
### If you are using systemd with UEFI, the path is detected automatically via 'bootctl --print-esp-path'.
### If detection fails, set this path manually.
#ESP_PATH="/boot"


### Skip UEFI Check and Registration
### Skip UEFI check and bootloader registration on certain non-compliant UEFI boards (e.g., some MSI boards) (yes|no)
### If skipped, Limine will be used as the fallback bootloader on the standard UEFI path for all UEFI systems.
### Note:
### When set to yes, run 'limine-install' and manually set the BIOS boot order to make the standard UEFI path the default boot.
SKIP_UEFI=no


### Kernel Command Line Configuration
### Define one or more kernel command lines (parameters) for specific kernel entries.
### If unset, the tool will try to read them from '/etc/kernel/cmdline' or '/proc/cmdline'.
###
### Rules:
### * KERNEL_CMDLINE[default] applies to any kernel entries without specific configuration.
### * KERNEL_CMDLINE[fallback] applies to kernel entries with names containing *fallback*
### * KERNEL_CMDLINE[kernel name] applies to a specific kernel entry.
###
### Operators:
### * `+=` appends parameters to an existing cmdline for the same KERNEL_CMDLINE[<key>]
###    Commonly used in drop-in configs: /etc/limine-entry-tool.d/*.conf
###    Ignores /etc/kernel/cmdline and /proc/cmdline
### * `=` replaces an existing cmdline for the same KERNEL_CMDLINE[<key>]
###    Note: /etc/default/limine overrides any drop-in configs, so `+=` is recommended in that file.
###
### Tip:
### If unsure which parameters to use, copy them from `/proc/cmdline` into KERNEL_CMDLINE[default],
### but ensure your system is not a live ISO, temporary environment, or snapshot.
###
### Examples:
#KERNEL_CMDLINE[default]+="rw root=UUID=..."
#KERNEL_CMDLINE[default]+="quiet splash"
#KERNEL_CMDLINE[fallback]=
#KERNEL_CMDLINE[linux-zen]=


### Formatting Boot Entry
### Define the number of spaces to indent each line of the boot entry in '$ESP_PATH/limine.conf'.
### If not set, the default is 2.
#SPACE_NUMBER=2


### Boot Integrity Check
### Enable BLAKE2 checksum verification for bootable files. (yes|no)
ENABLE_VERIFICATION=yes


### Automatic Config Backup
### Creates a backup of '$ESP_PATH/limine.conf' before saving any changes,
### but only if '$ESP_PATH/limine.conf.old' is older than the specified time (in hours).
### Default: 6 hours if unset.
#CONFIG_BACKUP_THRESHOLD=6


### Kernel Entries Order
### Wildcard "*" matches any letter in kernel-entry name 
### If ENABLE_SORT is set to "yes", only wildcard "*" entries are sorted alphabetically.
BOOT_ORDER="*, *fallback, Snapshots"
ENABLE_SORT=no


### Custom Java Binary Path
### Set this to specify a custom Java binary path instead of using the system default.
### If left unset, the default system Java will be used.
#JAVA_BIN_PATH="/usr/lib/jvm/java-21-openjdk/bin"


### Limine UEFI Binary Path
### Set the path to the Limine UEFI binary. Default: '/usr/share/limine/BOOTX64.EFI' (from the limine package on Arch Linux)
### It will be copied to '$ESP_PATH/EFI/limine/limine_x64.efi' when running 'limine-install'.
#LIMINE_BINARY_PATH="/usr/share/limine/BOOTX64.EFI"


### Default Boot Fallback
### Set Limine as the default boot fallback at '$ESP_PATH/EFI/BOOT/BOOTX64.EFI'. (yes|no)
ENABLE_LIMINE_FALLBACK=no


### Find Bootloaders
### Automatically add systemd-boot, rEFInd, or the default EFI loader to Limine if they are found in the ESP. (yes|no)
FIND_BOOTLOADERS=yes


### Quiet Mode
### Set to "yes" to hide all success messages and avoid log spam. (yes|no)
#QUIET_MODE=no


### Enroll Limine Config
### Automatically enrolls the Limine config '$ESP_PATH/limine.conf' into the Limine binary to protect it from modifications.
###
### WARNING and RISK:
### Enabling this will PREVENT booting if you modify limine.conf and forget to re-enroll it manually.
###
### If you are unsure but want to try it, set 'ENABLE_LIMINE_FALLBACK=yes' and run 'limine-update'.
### This allows you to boot into the Limine fallback if booting is blocked due to a config mismatch.
###
### IMPORTANT REMINDER:
### After editing limine.conf, always run 'limine-enroll-config', otherwise Limine will refuse to boot due to a config mismatch.
###
### Notes:
### * Remove all other alternative Limine configs in different locations to avoid boot failure.
### * If using limine-snapper-sync, set 'COMMANDS_BEFORE_SAVE=limine-reset-enroll' and 'COMMANDS_AFTER_SAVE=limine-enroll-config' to automate config enrollment.
### * If multiple systems share the same limine.conf, ensure each one handles enrollment automatically.
### * To enable, copy this option to /etc/default/limine and set it to (yes|no).
###
#ENABLE_ENROLL_LIMINE_CONFIG=no


### Custom UKI Name
### Set a shorter, custom name for your UKI files instead of using the default machine-id.
### This can help when booting UKIs directly via EFISTUB (without any bootloader),
### since some buggy UEFI firmware (e.g. Asus AMI BIOS) may crash or freeze if UKI filenames are too long when registered in UEFI.
###
### Rules:
### * Custom name must be unique (like an ID) to avoid conflicts with other installations, otherwise UKIs will be overwritten.
### * Use only lowercase letters (a–z) and digits (0–9) for maximum compatibility with UEFI firmware and devices.
###
### Example: ${CUSTOM_UKI_NAME}_${kernel_version}.efi -> arch_linux-lts.efi (when CUSTOM_UKI_NAME="arch" is set)
### Default: The machine-id is used if the custom name is invalid or not set.
###
### WARNING:
### If you change the name, old UKI files with the previous prefix (name or ID) remain unused on the ESP;
### remove them manually to free up ESP space if not needed: $ESP_PATH/EFI/Linux/{machine-id or old name}_{kernel_version}.efi
#CUSTOM_UKI_NAME="arch"


##########  The below options apply to Arch Linux when 'limine-dracut-support' or 'limine-mkinitcpio-hook' is installed ###########

### UKI (Unified Kernel Image)
### Automatically create UKIs in '$ESP_PATH/EFI/Linux/' for UEFI. (yes|no)
###
### Advantage:
###  - UKIs are automatically loaded by bootloaders like 'systemd-boot' and 'rEFInd'.
### Disadvantage:
###  - UKIs use more ESP space compared to separate 'initramfs' and 'vmlinuz' files, especially with multiple Limine snapshots.
###
### Additional notes:
### - Duplicate 'initramfs' and 'vmlinuz' files are removed when 'limine-update' is run to generate a UKI.
### - UKI ignores booting into a snapshot when Secure Boot is enabled. To resolve this, any embedded kernel cmdline is removed from the UKI, which will then read the external kernel cmdline.
ENABLE_UKI=no


### Dracut Fallback Configuration
### Automatically create a kernel fallback image using Dracut. (yes|no)
### If set to 'yes,' this will consume a lot of storage space, especially when taking multiple snapshots.
DRACUT_FALLBACK=no
```

______________________

### Donate

If you would like to support the project, feel free to donate:

[<img src="https://gitlab.com/Zesko/resources/-/raw/main/kofiButton.png" width=110px>](https://ko-fi.com/zeskotron)
&nbsp;[<img src="https://gitlab.com/Zesko/resources/-/raw/main/PayPalButton.png" width=160px/>](https://www.paypal.com/donate/?hosted_button_id=XKP36D62AY5HY)

##### Planned version 2.0.0

- **Support for smaller ESP sizes** by storing bootable files on a separate FAT32 partition.
- **BLS support:** Automatically parses existing BLS files and generates corresponding Limine boot entries.
- **Multiple cmdlines per kernel:** Allow multiple boot profiles for the same kernel via `KERNEL_CMDLINE[x][y]` config.
- **Support for `initrd=`** parameters parsed from a kernel cmdline into Limine module paths.
- **Configurable Limine protocol options** for individual kernel entries.
- **Full Kotlin rewrite:** Optimized code using standard libraries to improve performance compared to version 1.
- **Full compatibility** with version 1.
