#!/bin/bash
function mount_snapshot_overlay() {
	local root_mnt="${NEWROOT}"
	local fstype source_path ro_state tmp_dir

	# Check: Is $root_mnt mounted on Btrfs?
	fstype=$(findmnt --mountpoint "${root_mnt}" -no FSTYPE) || return 0
	[[ "${fstype}" != "btrfs" ]] && return 0

	# Check: Does $root_mnt source path contain '/snapshot'?
	source_path=$(findmnt --mountpoint "${root_mnt}" -no SOURCE) || return 0
	[[ "${source_path}" != *"/snapshot"* ]] && return 0

	# Check: Is the subvolume read-only?
	ro_state=$(btrfs property get -t subvol "${root_mnt}" ro 2>/dev/null)
	[[ "${ro_state}" != "ro=true" ]] && return 0

	echo "[OverlayFS setup] ${root_mnt} is a read-only Btrfs subvolume. Setting up OverlayFS..."

	# Prepare overlay structure, create tmpfs for overlay
	tmp_dir=$(mktemp -d -p / cowspace.XXXXXX) || {
		echo "[OverlayFS setup] Failed to create tmp_dir for overlay"
		logger -t "overlayfs-setup" -p err "Failed to create tmp_dir for overlay"
		return 1
	}
	mount -t tmpfs cowspace "${tmp_dir}" || {
		echo "[OverlayFS setup] Failed to mount tmpfs"
		logger -t "overlayfs-setup" -p err "Failed to mount tmpfs"
		return 1
	}
	mkdir -p "${tmp_dir}"/{upper,work}

	# Mount overlayfs
	if mount -t overlay rootfs \
		-o "lowerdir=${root_mnt},upperdir=${tmp_dir}/upper,workdir=${tmp_dir}/work" \
		"${root_mnt}"; then
		echo "[OverlayFS setup] OverlayFS mounted on ${root_mnt}"
	else
		echo "[OverlayFS setup] Overlay mount failed"
		logger -t "overlayfs-setup" -p err "Overlay mount failed"
		return 1
	fi
}

mount_snapshot_overlay
