/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.processes;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limine.entry.tool.objects.ConsoleColor;
import org.limine.entry.tool.objects.EfiBootEntry;
import org.limine.entry.tool.objects.Output;
import org.limine.entry.tool.processes.Utility;

public class EfiScanner {
    private static final Scanner SCANNER = new Scanner(System.in);

    public static EfiBootEntry showEfiEntriesAndSelect() {
        List<EfiBootEntry> entries = EfiScanner.getEfiBootEntries();
        if (entries.isEmpty()) {
            System.out.println(String.valueOf((Object)ConsoleColor.RED) + "No EFI boot entries found." + String.valueOf((Object)ConsoleColor.RESET));
            return null;
        }
        Utility.infoMessage("Available EFI Boot Entries:");
        for (int i = 0; i < entries.size(); ++i) {
            EfiBootEntry entry = entries.get(i);
            System.out.printf("%d: %s - GPT UUID: %s - EFI path: %s%n", i + 1, entry.name(), entry.gptUuid(), entry.efiPath());
        }
        System.out.printf(String.valueOf((Object)ConsoleColor.YELLOW) + "Choose a boot entry number (1-%d) to add to Limine, or press [c] to cancel:%n" + String.valueOf((Object)ConsoleColor.RESET), entries.size());
        String input = SCANNER.nextLine().trim();
        if (input.equalsIgnoreCase("c")) {
            return null;
        }
        try {
            int selectedIndex = Integer.parseInt(input);
            if (selectedIndex < 1 || selectedIndex > entries.size()) {
                System.out.println(String.valueOf((Object)ConsoleColor.RED) + "Invalid selection." + String.valueOf((Object)ConsoleColor.RESET));
                return null;
            }
            return entries.get(selectedIndex - 1);
        }
        catch (NumberFormatException e) {
            System.out.println(String.valueOf((Object)ConsoleColor.RED) + "Invalid selection." + String.valueOf((Object)ConsoleColor.RESET));
            return null;
        }
    }

    public static List<EfiBootEntry> getEfiBootEntries() {
        ArrayList<EfiBootEntry> efiEntries = new ArrayList<EfiBootEntry>();
        Output output = Utility.getTextFromCommand("efibootmgr", true, true);
        if (!output.isSuccess()) {
            return efiEntries;
        }
        Pattern regex = Pattern.compile("\\s+(.+?)\\s+HD\\(\\d+,GPT,([0-9a-fA-F-]+),[^)]+\\)(/\\S+(?i).efi)");
        for (String line : output.text()) {
            Matcher matcher = regex.matcher(line);
            if (!matcher.find()) continue;
            String name = matcher.group(1).trim();
            String gptUuid = matcher.group(2).trim();
            String efiPath = matcher.group(3).trim();
            String validEfiPath = efiPath.replaceAll("[^\\x20-\\x7E]", "").replace("\\", "/").replace("//", "/");
            if (validEfiPath.isEmpty()) continue;
            efiEntries.add(new EfiBootEntry(name, gptUuid, validEfiPath));
        }
        return efiEntries;
    }
}

