/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.objects;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.limine.entry.tool.formats.limine8.Limine;
import org.limine.entry.tool.objects.Config;
import org.limine.entry.tool.objects.EntryOptions;
import org.limine.entry.tool.processes.MacroReplacer;
import org.limine.entry.tool.processes.Utility;

public class TreeNode
implements Comparable<TreeNode> {
    private final List<String> configLines;
    private final LinkedList<TreeNode> nodes;
    private final int depth;
    private final String parentNodeName;
    private final String name;
    private final String cleanName;
    private EntryOptions options;
    private boolean enableLineBreak;

    public TreeNode(String name, int depth, String parentNodeName) {
        this.name = name;
        this.cleanName = Utility.cleanName(name);
        this.configLines = new ArrayList<String>();
        this.nodes = new LinkedList();
        this.depth = depth;
        this.parentNodeName = parentNodeName;
        this.enableLineBreak = false;
        this.options = null;
    }

    public void addConfigLine(String line) {
        this.configLines.add(line);
    }

    public void addNode(TreeNode node) {
        this.nodes.add(node);
    }

    public void addNode(int index, TreeNode node) {
        this.nodes.add(index, node);
    }

    public TreeNode findNodeByIDorName(Config config, int selectedDepth) {
        TreeNode node = this.findNodeByMachineID(config.machineID(), selectedDepth);
        if (node == null) {
            return this.findNodeByCleanName(config.targetOs(), config.machineID(), selectedDepth);
        }
        return node;
    }

    public TreeNode findNodeByCleanName(String nodeName, String machineID, int selectedDepth) {
        if (nodeName == null) {
            return null;
        }
        if (nodeName.isBlank()) {
            return null;
        }
        if (0 >= selectedDepth) {
            if (Objects.equals(this.cleanName, nodeName)) {
                if (this.options != null && this.options.getMachineID() != null && machineID != null) {
                    if (this.options.getMachineID().isEmpty() || this.options.getMachineID().equals(machineID)) {
                        return this;
                    }
                    return null;
                }
                return this;
            }
            return null;
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            TreeNode result = node.findNodeByCleanName(nodeName, machineID, selectedDepth);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int findPositionByLowerPriority(int priority) {
        int position = 0;
        for (TreeNode node : this.nodes) {
            if (priority > node.getOrCreateOptions().getPriority()) {
                return position;
            }
            ++position;
        }
        return position;
    }

    public TreeNode findNodeByMachineID(String machineID, int selectedDepth) {
        if (0 >= selectedDepth) {
            if (machineID.equals(this.getOrCreateOptions().getMachineID())) {
                return this;
            }
            return null;
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            TreeNode result = node.findNodeByMachineID(machineID, selectedDepth);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean searchNodeByName(String nodeName, int selectedDepth) {
        if (0 >= selectedDepth) {
            return this.name.trim().equals(nodeName);
        }
        --selectedDepth;
        for (TreeNode node : this.nodes) {
            if (!node.searchNodeByName(nodeName, selectedDepth)) continue;
            return true;
        }
        return false;
    }

    public void printTree(String prefix) {
        System.out.println(prefix + this.name + " (Depth: " + this.depth + ", Parent: " + this.parentNodeName + ")");
        for (String line : this.configLines) {
            System.out.println(prefix + line);
        }
        for (TreeNode node : this.nodes) {
            node.printTree(prefix);
        }
    }

    public String toString() {
        return "TreeNode{name='" + this.name + "', configBlock=" + String.valueOf(this.configLines) + ", depth=" + this.depth + ", parentNodeName='" + this.parentNodeName + "'}";
    }

    public List<String> getConfigLines() {
        return this.configLines;
    }

    public LinkedList<TreeNode> getNodes() {
        return this.nodes;
    }

    public boolean isEnableLineBreak() {
        return this.enableLineBreak;
    }

    public void setEnableLineBreak(boolean enableLineBreak) {
        this.enableLineBreak = enableLineBreak;
    }

    public String getName() {
        return this.name;
    }

    public String getCleanName() {
        return this.cleanName;
    }

    public EntryOptions getOrCreateOptions() {
        if (this.options == null) {
            this.options = new EntryOptions();
            for (String line : this.configLines) {
                if (!line.trim().startsWith(Limine.COMMENT.toString())) continue;
                this.options.parseComment(MacroReplacer.replaceMacros(line));
            }
        }
        return this.options;
    }

    public void setOptions(EntryOptions options) {
        this.options = options;
    }

    @Override
    public int compareTo(TreeNode other) {
        return this.cleanName.compareTo(other.cleanName);
    }
}

