/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.processes;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.limine.entry.tool.objects.Config;
import org.limine.entry.tool.objects.TreeNode;
import org.limine.entry.tool.processes.Utility;

public record LimineWriter(Config config) {
    public static void createDefaultLimineConfigFile(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(path.toFile()));){
            writer.write("### Read more at config document: https://codeberg.org/Limine/Limine/src/branch/v9.x/CONFIG.md\n#timeout: 3\n### Note: For \"default_entry\" to select a sub-entry within an OS menu, modify \"/OS name\" to \"/+OS name\" to keep its submenus visible.\ndefault_entry: 2\n#interface_branding: Your boot manager\n#interface_branding_color: 3\nhash_mismatch_panic: no\n \n \n");
        }
    }

    public void backup() {
        String limineConfigFilePath = Utility.buildPath(this.config.espPath(), "limine.conf");
        if (Utility.isFilePresent(limineConfigFilePath)) {
            String backupPath = limineConfigFilePath + ".old";
            boolean isBackupNeeded = true;
            if (Utility.isFilePresent(backupPath)) {
                isBackupNeeded = Utility.isFileOlderThan(backupPath, Config.CONFIG_BACKUP_THRESHOLD);
            }
            if (isBackupNeeded) {
                Utility.copyFile(limineConfigFilePath, backupPath, true, false, false);
            }
        }
    }

    public void save(TreeNode rootNode) {
        ArrayList<String> lines = new ArrayList<String>();
        this.writeNodeToLines(rootNode, lines, 0);
        String limineConfigPath = Utility.buildPath(this.config.espPath(), "limine.conf");
        Path limineTmpConfigPath = Paths.get(limineConfigPath + ".tmp", new String[0]);
        if (!Utility.isFilePresent(limineConfigPath)) {
            Utility.exitWithError("File path: " + limineConfigPath + " does not exit!");
            return;
        }
        try {
            Files.write(limineTmpConfigPath, lines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            Utility.runCommand("sync -f " + String.valueOf(limineTmpConfigPath), false, false);
            Utility.moveFile(limineTmpConfigPath.toString(), limineConfigPath, true, false, false);
            Utility.infoMessage("Updated:", limineConfigPath);
        }
        catch (IOException e) {
            Utility.errorMessage("Failed to write:", limineConfigPath);
            Utility.exitWithError("Reason:", e.getMessage());
        }
    }

    private void writeNodeToLines(TreeNode node, List<String> lines, int depth) {
        if (depth > 0) {
            lines.add(node.getName());
        }
        lines.addAll(node.getConfigLines());
        for (TreeNode childNode : node.getNodes()) {
            this.writeNodeToLines(childNode, lines, depth + 1);
        }
        if (node.isEnableLineBreak()) {
            lines.add("");
        }
    }
}

