/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool.formats.limine8;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.limine.entry.tool.formats.limine8.Limine;
import org.limine.entry.tool.objects.TreeNode;
import org.limine.entry.tool.processes.Utility;

public class LimineEntry {
    private final Limine protocol;
    private final List<URI> uris = new ArrayList<URI>();
    private final List<Other> others = new ArrayList<Other>();

    public LimineEntry(TreeNode node) {
        Limine foundProtocol = null;
        for (String line : node.getConfigLines()) {
            String value;
            String trimmed = line.trim();
            if (foundProtocol == null && trimmed.startsWith(Limine.PROTOCOL.toString())) {
                String protocolValue = trimmed.substring(Limine.PROTOCOL.toString().length()).trim();
                if (protocolValue.equals(Limine.PROTOCOL_EFI.toString())) {
                    foundProtocol = Limine.PROTOCOL_EFI;
                    continue;
                }
                if (protocolValue.equals(Limine.PROTOCOL_LINUX.toString())) {
                    foundProtocol = Limine.PROTOCOL_LINUX;
                    continue;
                }
                if (protocolValue.equals(Limine.PROTOCOL_EFI_CHAINLOAD.toString())) {
                    foundProtocol = Limine.PROTOCOL_EFI_CHAINLOAD;
                    continue;
                }
                if (protocolValue.equals(Limine.PROTOCOL_UEFI.toString())) {
                    foundProtocol = Limine.PROTOCOL_UEFI;
                    continue;
                }
                if (!protocolValue.equals(Limine.PROTOCOL_LIMINE.toString())) continue;
                foundProtocol = Limine.PROTOCOL_LIMINE;
                continue;
            }
            if (trimmed.startsWith(Limine.IMAGE_PATH.toString()) || trimmed.startsWith(Limine.MODULE_PATH.toString()) || trimmed.startsWith(Limine.KERNEL_PATH.toString()) || trimmed.startsWith(Limine.PATH.toString())) {
                String pathWithoutHash;
                String pathFunction;
                Limine pathProtocol = trimmed.startsWith(Limine.MODULE_PATH.toString()) ? Limine.MODULE_PATH : (trimmed.startsWith(Limine.IMAGE_PATH.toString()) ? Limine.IMAGE_PATH : (trimmed.startsWith(Limine.KERNEL_PATH.toString()) ? Limine.KERNEL_PATH : Limine.PATH));
                String valuePart = trimmed.substring(pathProtocol.toString().length()).trim();
                Pattern regex = Pattern.compile(Limine.PATH_RESOURCE_PATTERN.toString());
                Matcher match = regex.matcher(valuePart);
                String string = pathFunction = match.find() ? match.group() : "";
                if (pathFunction.isEmpty()) {
                    Utility.warnMessage("The URI is invalid", trimmed);
                    continue;
                }
                String pathPart = valuePart.substring(pathFunction.length()).trim();
                String hashComment = "";
                int hashIndex = pathPart.indexOf(Limine.HASH.toString());
                if (hashIndex >= 0) {
                    pathWithoutHash = pathPart.substring(0, hashIndex).trim();
                    hashComment = pathPart.substring(hashIndex + Limine.HASH.toString().length()).trim();
                } else {
                    pathWithoutHash = pathPart;
                }
                this.uris.add(new URI(pathProtocol, pathFunction, pathWithoutHash, hashComment));
                continue;
            }
            if (trimmed.startsWith(Limine.CMDLINE.toString())) {
                value = trimmed.substring(Limine.CMDLINE.toString().length()).trim();
                this.others.add(new Other(Limine.CMDLINE, value));
                continue;
            }
            if (!trimmed.startsWith(Limine.COMMENT.toString())) continue;
            value = trimmed.substring(Limine.COMMENT.toString().length()).trim();
            this.others.add(new Other(Limine.COMMENT, value));
        }
        this.protocol = foundProtocol;
    }

    public boolean isProtocolLinux() {
        return this.protocol == Limine.PROTOCOL_LINUX;
    }

    public boolean isProtocolEfi() {
        return this.protocol == Limine.PROTOCOL_EFI || this.protocol == Limine.PROTOCOL_UEFI || this.protocol == Limine.PROTOCOL_EFI_CHAINLOAD;
    }

    public boolean containsEfiPath(String pathArg, String efiFilePath) {
        if (!this.isProtocolEfi() || pathArg.isBlank()) {
            return false;
        }
        for (URI uri : this.uris) {
            if (uri.pathProtocol() != Limine.IMAGE_PATH && uri.pathProtocol() != Limine.PATH || !uri.pathFunction().contains(pathArg) || !Utility.removeSurroundingSlashes(uri.path()).equalsIgnoreCase(Utility.removeSurroundingSlashes(efiFilePath))) continue;
            return true;
        }
        return false;
    }

    public boolean containsKernelDirPath(String pathArg, String kernelFilePath) {
        if (!this.isProtocolLinux() || pathArg.isBlank()) {
            return false;
        }
        for (URI uri : this.uris) {
            if (uri.pathProtocol() != Limine.KERNEL_PATH && uri.pathProtocol() != Limine.PATH || !uri.pathFunction().contains(pathArg) || !Utility.startsWithIgnoreCase(Utility.removeSurroundingSlashes(uri.path()), Utility.removeSurroundingSlashes(kernelFilePath) + File.separator)) continue;
            return true;
        }
        return false;
    }

    public record URI(Limine pathProtocol, String pathFunction, String path, String other) {
    }

    public record Other(Limine schema, String value) {
    }
}

