/*
 * Decompiled with CFR 0.152.
 */
package org.limine.entry.tool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.limine.entry.tool.objects.Config;
import org.limine.entry.tool.objects.ConsoleColor;
import org.limine.entry.tool.objects.EfiBootEntry;
import org.limine.entry.tool.objects.EntryOptions;
import org.limine.entry.tool.processes.ConfigReader;
import org.limine.entry.tool.processes.EfiScanner;
import org.limine.entry.tool.processes.LimineManager;
import org.limine.entry.tool.processes.LimineReader;
import org.limine.entry.tool.processes.LimineWriter;
import org.limine.entry.tool.processes.Utility;

public class Main {
    public static void main(String[] args) throws IOException {
        String command;
        ArrayList<String> remainingArgs = new ArrayList<String>();
        String comment = "";
        EntryOptions entryOptions = new EntryOptions();
        boolean isArgComment = false;
        boolean isArgPriority = false;
        block42: for (String arg2 : args) {
            if (isArgComment) {
                if (arg2.startsWith("--")) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                comment = arg2;
                isArgComment = false;
                continue;
            }
            if (isArgPriority) {
                if (entryOptions.parseArg(arg2, EntryOptions.Key.ORDER_PRIORITY)) {
                    isArgPriority = false;
                    continue;
                }
                System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                Main.printHelp();
                return;
            }
            switch (arg2) {
                case "--quiet": {
                    Config.QUIET = true;
                    continue block42;
                }
                case "--help": {
                    Main.printHelp();
                    return;
                }
                case "--version": {
                    System.out.println(String.valueOf((Object)ConsoleColor.GREEN) + Utility.getVersion() + String.valueOf((Object)ConsoleColor.RESET));
                    return;
                }
                case "--comment": {
                    isArgComment = true;
                    continue block42;
                }
                case "--priority": {
                    isArgPriority = true;
                    continue block42;
                }
                case "--overwrite": {
                    entryOptions.setEntryOverwrite(true);
                    continue block42;
                }
                default: {
                    remainingArgs.add(arg2);
                }
            }
        }
        if (remainingArgs.isEmpty()) {
            System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
            Main.printHelp();
            return;
        }
        switch (command = (String)remainingArgs.get(0)) {
            case "--add": {
                if (remainingArgs.size() < 4) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String kernelName = (String)remainingArgs.get(1);
                String initramfsPath = (String)remainingArgs.get(2);
                String vmlinuzPath = (String)remainingArgs.get(3);
                String suffixName = remainingArgs.size() == 5 ? (String)remainingArgs.get(4) : "";
                Main.add(kernelName, comment, entryOptions, initramfsPath, vmlinuzPath, suffixName);
                return;
            }
            case "--add-uki": {
                if (remainingArgs.size() < 3) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String kernelName = (String)remainingArgs.get(1);
                String ukiPath = (String)remainingArgs.get(2);
                Main.addUki(kernelName, comment, entryOptions, ukiPath);
                return;
            }
            case "--add-efi": {
                if (remainingArgs.size() < 3) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String efiName = (String)remainingArgs.get(1);
                String efiPath = (String)remainingArgs.get(2);
                Main.addEfi(efiName, comment, entryOptions, efiPath);
                return;
            }
            case "--remove": {
                if (remainingArgs.size() != 2) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String kernelName = (String)remainingArgs.get(1);
                Main.remove(kernelName, false);
                return;
            }
            case "--remove-uki": {
                if (remainingArgs.size() != 2) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String kernelName = (String)remainingArgs.get(1);
                Main.remove(kernelName, true);
                return;
            }
            case "--remove-entry": {
                if (remainingArgs.size() != 2) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String kernelName = (String)remainingArgs.get(1);
                Main.removeEntry(kernelName);
                return;
            }
            case "--remove-efi": {
                if (remainingArgs.size() != 2) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String filePath = (String)remainingArgs.get(1);
                Main.removeEfi(filePath);
                return;
            }
            case "--remove-os": {
                if (remainingArgs.size() != 2) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String osNameOrMachineID = (String)remainingArgs.get(1);
                Main.removeOs(osNameOrMachineID);
                return;
            }
            case "--remove-all": {
                List<String> kernelNames = remainingArgs.stream().filter(arg -> !arg.startsWith("--")).toList();
                Main.removeAll(kernelNames);
                return;
            }
            case "--scan": {
                Main.scanEfiEntries();
                return;
            }
            case "--get-cmdline": {
                if (remainingArgs.size() != 2) {
                    System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
                    Main.printHelp();
                    return;
                }
                String kernelName = (String)remainingArgs.get(1);
                ConfigReader configReader = new ConfigReader();
                Config config = configReader.readConfig();
                System.out.println(config.getKernelCmdline(kernelName));
                return;
            }
        }
        System.err.println(String.valueOf((Object)ConsoleColor.RED_BOLD) + "Invalid arguments" + String.valueOf((Object)ConsoleColor.RESET));
        Main.printHelp();
    }

    private static void printHelp() {
        System.out.println("Usage: limine-entry-tool [option] [--quiet]\nOptions:\n       --add [kernel entry name] [path to initramfs] [path to vmlinuz] [any suffix name] --comment [any comment]\n       --add-uki [kernel entry name] [path to UKI file] --comment [any comment]\n       --add-efi [OS entry name] [path to EFI binary] --comment [any comment] --priority [number] --overwrite\n       --get-cmdline [kernel name]\n       --remove [kernel directory name]\n       --remove-uki [kernel file name]\n       --remove-entry [kernel entry name]\n       --remove-all [kernel name 1] [kernel name 2] [kernel name 3] ...\n       --remove-efi [path] : Remove an EFI boot entry that matches a specified bootable file path.\n       --remove-os [machine-ID or name] : Remove an OS entry matching a given machine-ID or OS name.\n       --scan : Scans available EFI entries for selection.\n       --version\n");
    }

    private static void add(String kernelName, String comment, EntryOptions kernelEntryOptions, String initramfsPath, String vmlinuzPath, String suffixName) throws IOException {
        boolean isNameValid = Utility.isValidFat32Name(kernelName);
        if (!isNameValid) {
            Utility.exitWithError("Kernel name: '" + kernelName + "' is invalid due to FAT32 naming rules: Spaces and other special characters are not allowed.");
            return;
        }
        kernelName = kernelName.trim();
        suffixName = suffixName.trim();
        comment = comment.trim();
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        LimineReader limine = new LimineReader(config);
        LimineManager manager = new LimineManager(limine.getTargetOsNode(), config);
        manager.add(kernelName, comment, kernelEntryOptions, initramfsPath, vmlinuzPath, suffixName);
        if (manager.isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void addUki(String kernelName, String comment, EntryOptions kernelEntryOptions, String ukiFilePath) throws IOException {
        boolean isNameValid;
        if (!Utility.isSystemAmd64()) {
            Utility.exitWithError("Your system is not using x86_64 architecture");
        }
        if (!Utility.isSystemEfi()) {
            Utility.exitWithError("Your system is not using EFI mode");
        }
        if (!(isNameValid = Utility.isValidFat32Name(kernelName))) {
            Utility.exitWithError("Kernel name: '" + kernelName + "' is invalid due to FAT32 naming rules: Spaces and other special characters are not allowed.");
            return;
        }
        kernelName = kernelName.trim();
        comment = comment.trim();
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        LimineReader limine = new LimineReader(config);
        LimineManager manager = new LimineManager(limine.getTargetOsNode(), config);
        manager.addUki(kernelName, comment, kernelEntryOptions, ukiFilePath);
        if (manager.isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void addEfi(String efiName, String comment, EntryOptions kernelEntryOptions, String efiFilePath) throws IOException {
        if (!Utility.isSystemAmd64()) {
            Utility.exitWithError("Your system is not using x86_64 architecture");
        }
        if (!Utility.isSystemEfi()) {
            Utility.exitWithError("Your system is not using EFI mode");
        }
        efiName = efiName.trim();
        comment = comment.trim();
        efiFilePath = efiFilePath.trim();
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        Config.ENABLE_OS_GENERATION = false;
        LimineReader limine = new LimineReader(config);
        boolean isUpdateNeeded = LimineManager.merge(limine.getRootNode(), efiName, comment, kernelEntryOptions, efiFilePath, config);
        if (isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void remove(String kernelName, boolean isUKI) throws IOException {
        boolean isNameValid = Utility.isValidFat32Name(kernelName);
        if (!isNameValid) {
            Utility.exitWithError("Kernel name: '" + kernelName + "' is invalid due to FAT32 naming rules: Spaces and other special characters are not allowed.");
            return;
        }
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        LimineReader limine = new LimineReader(config);
        LimineManager manager = new LimineManager(limine.getTargetOsNode(), config);
        manager.remove(kernelName.trim(), isUKI);
        if (manager.isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void removeEntry(String kernelName) throws IOException {
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        LimineReader limine = new LimineReader(config);
        LimineManager manager = new LimineManager(limine.getTargetOsNode(), config);
        manager.removeEntry(kernelName.trim());
        if (manager.isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void removeAll(List<String> kernelNames) throws IOException {
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        LimineReader limine = new LimineReader(config);
        LimineManager manager = new LimineManager(limine.getTargetOsNode(), config);
        for (String kernelName : kernelNames) {
            boolean isNameValid = Utility.isValidFat32Name(kernelName);
            if (isNameValid) {
                manager.remove(kernelName.trim(), true);
                manager.remove(kernelName.trim(), false);
                continue;
            }
            Utility.errorMessage("Kernel name: '" + kernelName + "' is invalid due to FAT32 naming rules: Spaces and other special characters are not allowed.");
        }
        if (manager.isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void removeEfi(String efiFilePath) throws IOException {
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        Config.ENABLE_OS_GENERATION = false;
        LimineReader limine = new LimineReader(config);
        boolean isUpdateNeeded = LimineManager.removeEfi(limine.getRootNode(), efiFilePath, config);
        if (isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void removeOs(String osNameOrMachineID) throws IOException {
        ConfigReader configReader = new ConfigReader();
        Config config = configReader.readConfig();
        Config.ENABLE_OS_GENERATION = false;
        LimineReader limine = new LimineReader(config);
        boolean isUpdateNeeded = LimineManager.removeOs(limine.getRootNode(), osNameOrMachineID, config);
        if (isUpdateNeeded) {
            LimineWriter writer = new LimineWriter(config);
            writer.backup();
            writer.save(limine.getRootNode());
        }
    }

    private static void scanEfiEntries() throws IOException {
        Config.QUIET = false;
        EfiBootEntry selectedEntry = EfiScanner.showEfiEntriesAndSelect();
        if (selectedEntry != null) {
            Utility.infoMessage("EFI entry added to Limine:", "\"" + selectedEntry.name() + "\", guid(" + selectedEntry.gptUuid() + "):" + selectedEntry.efiPath());
            Config.QUIET = true;
            EntryOptions options = new EntryOptions().setPriority(20).setEntryOverwrite(true);
            String mountPoint = Utility.getMountPoint(selectedEntry.gptUuid());
            if (mountPoint.isEmpty()) {
                String tempMountPoint = "/run/let";
                Utility.ensureDirectoryExists(tempMountPoint);
                Utility.runCommand("mount /dev/disk/by-partuuid/" + selectedEntry.gptUuid() + " " + tempMountPoint, false, true);
                Main.addEfi(selectedEntry.name(), selectedEntry.name(), options, tempMountPoint + selectedEntry.efiPath());
                Utility.runCommand("umount " + tempMountPoint, false, true);
            } else {
                Main.addEfi(selectedEntry.name(), selectedEntry.name(), options, mountPoint + selectedEntry.efiPath());
            }
        }
    }
}

