/* astal-tray-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalTray", gir_version = "0.1")]
namespace AstalTray {
	[CCode (cheader_filename = "astal-tray.h")]
	public class Tray : GLib.Object {
		public Tray ();
		/**
		 * Get the singleton instance of [class@AstalTray.Tray]
		 */
		public static unowned AstalTray.Tray get_default ();
		/**
		 * gets the TrayItem with the given item-id.
		 */
		public AstalTray.TrayItem get_item (string item_id);
		/**
		 * List of currently registered tray items
		 */
		public GLib.List<weak AstalTray.TrayItem> items { owned get; }
		/**
		 * ListModel containing the currently registered tray items.
		 */
		public GLib.ListModel items_model { get; }
		/**
		 * emitted when a new tray item was added.
		 */
		public signal void item_added (string item_id);
		/**
		 * emitted when a tray item was removed.
		 */
		public signal void item_removed (string item_id);
	}
	[CCode (cheader_filename = "astal-tray.h")]
	public class TrayItem : GLib.Object {
		/**
		 * tells the tray app that its menu is about to be opened,
		 * so it can update the menu if needed. You should call this method
		 * before openening the menu.
		 */
		public void about_to_show ();
		/**
		 * Send an activate request to the tray app.
		 */
		public void activate (int x, int y);
		/**
		 * Send a scroll request to the tray app.
		 * valid values for the orientation are "horizontal" and "vertical".
		 */
		public void scroll (int delta, string orientation);
		/**
		 * Send a secondary activate request to the tray app.
		 */
		public void secondary_activate (int x, int y);
		public string to_json_string ();
		/**
		 * The ActionGroup containing the actions for the menu. All actions have the `dbusmenu` prefix and are
		 * setup to work with the [property@AstalTray.TrayItem:menu-model]. Make sure to insert this action group
		 * into a parent widget of the menu, eg the MenuButton for which the MenuModel for this TrayItem is set.
		 */
		public GLib.ActionGroup? action_group { owned get; }
		/** The category this item belongs to */
		public AstalTray.Category category { get; private set; }
		/**
		 * Contains the items icon. This property is intended to be used with the gicon property
		 * of the Icon widget and the recommended way to display the icon.
		 * This property unifies the [property@AstalTray.TrayItem:icon-name],
		 * [property@AstalTray.TrayItem:icon-theme-path] and [property@AstalTray.TrayItem:icon-pixbuf] properties.
		 */
		public GLib.Icon gicon { get; private set; }
		/**
		 * The name of the icon. This should be looked up in the [property@AstalTray.TrayItem:icon-theme-path]
		 * if set or in the currently used icon theme otherwise.
		 * It is recommended to use the [property@AstalTray.TrayItem:gicon] property,
		 * which does the icon lookups for you.
		 */
		public string icon_name { owned get; }
		/**
		 * A pixbuf containing the icon.
		 * It is recommended to use the [property@AstalTray.TrayItem:gicon] property,
		 * which does the icon lookups for you.
		 */
		public Gdk.Pixbuf icon_pixbuf { owned get; }
		/**
		 * The icon theme path, where to look for the [property@AstalTray.TrayItem:icon-name].
		 * It is recommended to use the [property@AstalTray.TrayItem:gicon] property,
		 * which does the icon lookups for you.
		 */
		public string icon_theme_path { get; private set; }
		/** the id of the item. This id is specified by the tray app.*/
		public string id { get; private set; }
		/**
		 * If set, this only supports the menu, so showing the menu should be prefered
		 * over calling [method@AstalTray.TrayItem.activate].
		 */
		public bool is_menu { get; private set; }
		/** The id of the item used to uniquely identify the TrayItems by this lib.*/
		public string item_id { get; private set; }
		/**
		 * The MenuModel describing the menu for this TrayItem to be used with a MenuButton or PopoverMenu.
		 * The actions for this menu are defined in [property@AstalTray.TrayItem:action-group].
		 */
		public GLib.MenuModel? menu_model { owned get; }
		/** The object path to the dbusmenu */
		public GLib.ObjectPath menu_path { get; private set; }
		/** The current status of this item */
		public AstalTray.Status status { get; private set; }
		/** The Title of the TrayItem */
		public string title { get; private set; }
		/** The tooltip of this item */
		public AstalTray.Tooltip? tooltip { get; private set; }
		/**
		 * A markup representation of the tooltip. This is basically equvivalent
		 * to `tooltip.title \n tooltip.description`
		 */
		public string tooltip_markup { owned get; }
		/**
		 * A text representation of the tooltip. This is basically equvivalent
		 * to `tooltip.title \n tooltip.description.`
		 */
		public string tooltip_text { owned get; }
		public signal void changed ();
		public signal void ready ();
	}
	[CCode (cheader_filename = "astal-tray.h")]
	public struct Pixmap {
		public int width;
		public int height;
		public uint8[] bytes;
	}
	[CCode (cheader_filename = "astal-tray.h")]
	public struct Tooltip {
		public string icon_name;
		public AstalTray.Pixmap[] icon;
		public string title;
		public string description;
	}
	[CCode (cheader_filename = "astal-tray.h")]
	[DBus (use_string_marshalling = true)]
	public enum Category {
		[DBus (value = "ApplicationStatus")]
		[Description (nick = "ApplicationStatus")]
		APPLICATION,
		[DBus (value = "Communications")]
		[Description (nick = "Communications")]
		COMMUNICATIONS,
		[DBus (value = "SystemServices")]
		[Description (nick = "SystemServices")]
		SYSTEM,
		[DBus (value = "Hardware")]
		[Description (nick = "Hardware")]
		HARDWARE;
		public string to_nick ();
		public static AstalTray.Category from_string (string value) throws GLib.Error;
	}
	[CCode (cheader_filename = "astal-tray.h")]
	[DBus (use_string_marshalling = true)]
	public enum Status {
		[DBus (value = "Passive")]
		[Description (nick = "Passive")]
		PASSIVE,
		[DBus (value = "Active")]
		[Description (nick = "Active")]
		ACTIVE,
		[DBus (value = "NeedsAttention")]
		[Description (nick = "NeedsAttention")]
		NEEDS_ATTENTION;
		public string to_nick ();
		public static AstalTray.Status from_string (string value) throws GLib.Error;
	}
	[CCode (cheader_filename = "astal-tray.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-tray.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-tray.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-tray.h")]
	public const string VERSION;
	/**
	 * Get the singleton instance of [class@AstalTray.Tray]
	 */
	[CCode (cheader_filename = "astal-tray.h")]
	public static AstalTray.Tray get_default ();
}
