/* astal-notifd-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalNotifd", gir_version = "0.1")]
namespace AstalNotifd {
	/**
	 * Notification action.
	 */
	[CCode (cheader_filename = "astal-notifd.h")]
	public class Action : GLib.Object {
		public Action (string id, string label);
		/**
		 * Invoke this action.
		 * Note that this method just notifies the client that this action was invoked
		 * by the user. If for example this notification persists through the lifetime
		 * of the sending application this action will have no effect.
		 */
		public void invoke ();
		/** Id of this action. */
		public string id { get; set construct; }
		/** Label of this action that should be displayed to user. */
		public string label { get; set construct; }
		/** Emitted when the notification this action was added to invoked this action. */
		public signal void invoked ();
	}
	/**
	 * The Notification daemon.
	 *
	 * This class queues up to become the next daemon, while acting as a proxy in the meantime.
	 */
	[CCode (cheader_filename = "astal-notifd.h")]
	public class Notifd : GLib.Object {
		public Notifd ();
		/**
		 * Get the singleton instance
		 */
		public static AstalNotifd.Notifd get_default ();
		/**
		 * Gets the [class@AstalNotifd.Notification] with id or null if there is no such Notification.
		 */
		public AstalNotifd.Notification? get_notification (uint id);
		/**
		 * Timeout used for notifications that do not specify a timeout and let
		 * the server decide. Negative values result in no timeout. By default this is -1.
		 */
		public int default_timeout { get; set; }
		/**
		 * Indicate to frontends to not show popups to the user.
		 * This property does not have any effect on its own, its merely
		 * a value to use between the daemon process and proxies for frontends to use.
		 */
		public bool dont_disturb { get; set; }
		/**
		 * Ignore the timeout specified by incoming notifications.
		 * By default notifications can specify a timeout in milliseconds
		 * after which the daemon will resolve them even without user input.
		 */
		public bool ignore_timeout { get; set; }
		/**
		 * List of currently unresolved notifications.
		 */
		public GLib.List<weak AstalNotifd.Notification> notifications { get; }
		/**
		 * Emitted when the daemon receives a [class@AstalNotifd.Notification].
		 *
		 * @param id The ID of the Notification.
		 * @param replaced Indicates if an existing Notification was replaced.
		 */
		public signal void notified (uint id, bool replaced);
		/**
		 * Emitted when a [class@AstalNotifd.Notification] is resolved.
		 *
		 * @param id The ID of the Notification.
		 * @param reason The reason how the Notification was resolved.
		 */
		public signal void resolved (uint id, AstalNotifd.ClosedReason reason);
	}
	/**
	 * Class representing a notification.
	 */
	[CCode (cheader_filename = "astal-notifd.h")]
	public class Notification : GLib.Object {
		public Notification ();
		public AstalNotifd.Notification add_action (AstalNotifd.Action action);
		/**
		 * Resolve this notification with [enum@AstalNotifd.ClosedReason.DISMISSED_BY_USER].
		 */
		public void dismiss ();
		/**
		 * Resolve this notification with [enum@AstalNotifd.ClosedReason.EXPIRED].
		 * Note that there should be no reason to use this method because expiration should be
		 * left to the daemon.
		 */
		public void expire ();
		public GLib.Variant? get_hint (string name);
		/**
		 * Invoke an [class@AstalNotifd.Action] of this notification.
		 */
		public void invoke (string action_id);
		public AstalNotifd.Notification set_hint (string name, GLib.Variant value);
		/**
		 * Standard `action-icons` hint.
		 * Indicates whether [class@AstalNotifd.Action] identifier should be interpreted as a named icon.
		 */
		public bool action_icons { get; set; }
		/**
		 * List of [class@AstalNotifd.Action] of the notification.
		 * Can be invoked by calling [method@AstalNotifd.Notification.invoke] with the action's id.
		 */
		public GLib.List<weak AstalNotifd.Action> actions { get; }
		/** Icon name of the sending application. */
		public string app_icon { get; set; }
		/** Name of the sending application. */
		public string app_name { get; set; }
		/** Multi-line body of text, where each line is a paragraph. May contain markup. */
		public string body { get; set; }
		/**
		 * Standard `category` hint.
		 * [[https://specifications.freedesktop.org/notification-spec/latest/categories.html]]
		 */
		public string category { owned get; set; }
		/**
		 * Standard `desktop-entry` hint.
		 * Specifies the name of the desktop filename representing the calling program.
		 */
		public string desktop_entry { owned get; set; }
		/** Time in milliseconds after the notification expires. */
		public int32 expire_timeout { get; set; }
		/**
		 * Hints of the notification. Hints are a way to provide extra data to servers.
		 * To set hints on a `DRAFT` Notification use [method@AstalNotifd.Notification.set_hint]
		 * or the property setters for standard hints.
		 */
		public GLib.Variant hints { get; internal set; }
		/** Id of the notification. */
		public uint32 id { get; set; }
		/** Standard `image-path` hint. Path of an image  */
		public string image { owned get; set; }
		/**
		 * Standard `resident` hint.
		 * Indicates whether notification is kept after action invocation.
		 */
		public bool resident { get; set; }
		/**
		 * Standard `sound-file` hint.
		 * The path to a sound file to play when the notification pops up.
		 */
		public string sound_file { owned get; set; }
		/**
		 * Standard `sound-name` hint.
		 * A themeable named sound from to play when the notification pops up
		 */
		public string sound_name { owned get; set; }
		/** State of the notification. */
		public AstalNotifd.State state { get; internal set; }
		/** Single line overview of the notification. */
		public string summary { get; set; }
		/**
		 * Standard `suppress-sound` hint.
		 * Indicates to suppress playing any sounds.
		 */
		public bool suppress_sound { get; set; }
		/** Unix time of when the notification was sent or received. */
		public int64 time { get; internal set; }
		/**
		 * Standard `transient` hint.
		 * Indicates that the notification should be excluded from persistency.
		 */
		public bool transient { get; set; }
		/**
		 * Standard `urgency` hint.
		 * [enum@AstalNotifd.Urgency] level of the notification.
		 */
		public AstalNotifd.Urgency urgency { get; set; }
		/**
		 * Standard `x` hint.
		 * Specifies the X location on the screen that the notification should point to.
		 * The "y" hint must also be specified.
		 */
		public int x { get; set; }
		/**
		 * Standard `y` hint.
		 * Specifies the Y location on the screen that the notification should point to.
		 * The "x" hint must also be specified.
		 */
		public int y { get; set; }
		/**
		 * Emitted when an [class@AstalNotifd.Action] of this notification is invoked.
		 *
		 * @param action_id id of the invoked action
		 */
		public signal void invoked (string action_id);
		/**
		 * Emitted when this this notification is resolved.
		 *
		 * @param reason The reason how the Notification was resolved.
		 */
		public signal void resolved (AstalNotifd.ClosedReason reason);
	}
	[CCode (cheader_filename = "astal-notifd.h")]
	public enum ClosedReason {
		EXPIRED,
		DISMISSED_BY_USER,
		CLOSED,
		UNDEFINED
	}
	[CCode (cheader_filename = "astal-notifd.h")]
	public enum State {
		DRAFT,
		SENT,
		RECEIVED
	}
	[CCode (cheader_filename = "astal-notifd.h")]
	public enum Urgency {
		LOW,
		NORMAL,
		CRITICAL
	}
	[CCode (cheader_filename = "astal-notifd.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-notifd.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-notifd.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-notifd.h")]
	public const string VERSION;
	/**
	 * Get the singleton instance of [class@AstalNotifd.Notifd]
	 */
	[CCode (cheader_filename = "astal-notifd.h")]
	public static AstalNotifd.Notifd get_default ();
	/**
	 * Send a notification.
	 * This function does not depend on Notifd and can be used with any notification server.
	 * The [class@AstalNotifd.Notification] passed to this function is never the
	 * same instance that [method@AstalNotifd.Notifd.get_notification] returns.
	 * This function will set the state of the passed notification from `DRAFT` to `SENT`
	 * after which the notification can no longer be mutated.
	 */
	[CCode (cheader_filename = "astal-notifd.h")]
	public static async void send_notification (AstalNotifd.Notification notification) throws GLib.IOError, GLib.DBusError;
}
