/* astal-network-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalNetwork", gir_version = "0.1")]
namespace AstalNetwork {
	[CCode (cheader_filename = "astal-network.h")]
	public class AccessPoint : GLib.Object {
		/**
		 * Activates the first connection associated with this AccessPoint
		 * or creates a new SimpleConnection using "wpa-psk" and activates it.
		 * Returns whether the connection is the new active connection.
		 */
		public async void activate (string? password = null) throws GLib.Error;
		public GLib.GenericArray<NM.RemoteConnection> get_connections ();
		public string get_path ();
		public uint bandwidth { get; }
		public string bssid { owned get; }
		public NM.80211ApFlags flags { get; }
		public uint frequency { get; }
		public string icon_name { get; private set; }
		public int last_seen { get; }
		public uint max_bitrate { get; }
		public NM.80211Mode mode { get; }
		public bool requires_password { get; }
		public NM.80211ApSecurityFlags rsn_flags { get; }
		public string? ssid { owned get; }
		public uint8 strength { get; }
		public NM.80211ApSecurityFlags wpa_flags { get; }
	}
	[CCode (cheader_filename = "astal-network.h")]
	public class Network : GLib.Object {
		public Network ();
		public static AstalNetwork.Network get_default ();
		public NM.Client client { get; private set; }
		public AstalNetwork.Connectivity connectivity { get; }
		public AstalNetwork.Primary primary { get; private set; }
		public AstalNetwork.State state { get; }
		public AstalNetwork.Wifi? wifi { get; private set; }
		public AstalNetwork.Wired? wired { get; private set; }
	}
	[CCode (cheader_filename = "astal-network.h")]
	public class Wifi : GLib.Object {
		public async void deactivate_connection () throws GLib.Error;
		public void scan ();
		public GLib.List<weak AstalNetwork.AccessPoint> access_points { owned get; }
		public AstalNetwork.AccessPoint? active_access_point { get; private set; }
		public NM.ActiveConnection? active_connection { get; private set; }
		public uint bandwidth { get; private set; }
		public NM.DeviceWifi device { get; set construct; }
		public bool enabled { get; set; }
		public uint frequency { get; private set; }
		public string icon_name { get; private set; }
		public AstalNetwork.Internet internet { get; private set; }
		public bool is_hotspot { get; private set; }
		public bool scanning { get; private set; }
		public string ssid { get; private set; }
		public AstalNetwork.DeviceState state { get; private set; }
		public uint8 strength { get; private set; }
		public signal void state_changed (AstalNetwork.DeviceState new_state, AstalNetwork.DeviceState old_state, NM.DeviceStateReason reaseon);
	}
	[CCode (cheader_filename = "astal-network.h")]
	public class Wired : GLib.Object {
		public NM.ActiveConnection connection;
		public NM.DeviceEthernet device { get; set construct; }
		public string icon_name { get; private set; }
		public AstalNetwork.Internet internet { get; private set; }
		public uint speed { get; private set; }
		public AstalNetwork.DeviceState state { get; private set; }
	}
	[CCode (cheader_filename = "astal-network.h")]
	public enum Connectivity {
		UNKNOWN,
		NONE,
		PORTAL,
		LIMITED,
		FULL;
		public string to_string ();
	}
	[CCode (cheader_filename = "astal-network.h")]
	public enum DeviceState {
		UNKNOWN,
		UNMANAGED,
		UNAVAILABLE,
		DISCONNECTED,
		PREPARE,
		CONFIG,
		NEED_AUTH,
		IP_CONFIG,
		IP_CHECK,
		SECONDARIES,
		ACTIVATED,
		DEACTIVATING,
		FAILED;
		public string to_string ();
	}
	[CCode (cheader_filename = "astal-network.h")]
	public enum Internet {
		CONNECTED,
		CONNECTING,
		DISCONNECTED;
		public static AstalNetwork.Internet from_device (NM.Device device);
		public string to_string ();
	}
	[CCode (cheader_filename = "astal-network.h")]
	public enum Primary {
		UNKNOWN,
		WIRED,
		WIFI;
		public string to_string ();
		public static AstalNetwork.Primary from_connection_type (string type);
	}
	[CCode (cheader_filename = "astal-network.h")]
	public enum State {
		UNKNOWN,
		ASLEEP,
		DISCONNECTED,
		DISCONNECTING,
		CONNECTING,
		CONNECTED_LOCAL,
		CONNECTED_SITE,
		CONNECTED_GLOBAL;
		public string to_string ();
	}
	[CCode (cheader_filename = "astal-network.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-network.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-network.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-network.h")]
	public const string VERSION;
	[CCode (cheader_filename = "astal-network.h")]
	public static AstalNetwork.Network get_default ();
}
