/* astal-mpris-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalMpris", gir_version = "0.1")]
namespace AstalMpris {
	/**
	 * Manager object that monitors the session DBus for Mpris players to appear and disappear.
	 */
	[CCode (cheader_filename = "astal-mpris.h")]
	public class Mpris : GLib.Object, GLib.ListModel {
		public Mpris ();
		/**
		 * Gets the default singleton Mpris instance.
		 */
		public static AstalMpris.Mpris get_default ();
		/**
		 * List of currently available players.
		 */
		public GLib.List<weak AstalMpris.Player> players { get; }
		/**
		 * Emitted when a new mpris Player appears.
		 */
		public signal void player_added (AstalMpris.Player player);
		/**
		 * Emitted when a Player disappears.
		 */
		public signal void player_closed (AstalMpris.Player player);
	}
	/**
	 * Object which tracks players through their mpris DBus interface.
	 * The most simple way is to use [class@AstalMpris.Mpris] which tracks every player,
	 * but [class@AstalMpris.Player] can be constructed for dedicated players too.
	 */
	[CCode (cheader_filename = "astal-mpris.h")]
	public class Player : GLib.Object {
		/**
		 * Construct a Player that tracks a dbus name. For example "org.mpris.MediaPlayer2.spotify".
		 * The "org.mpris.MediaPlayer2." prefix can be omitted so simply "spotify" would mean the same.
		 * [property@AstalMpris.Player:available] indicates whether the player is actually running or not.
		 *
		 * @param name dbus name of the player.
		 */
		public Player (string name);
		/**
		 * Lookup a key from [property@AstalMpris.Player:metadata].
		 * This method is useful for languages that fail to introspect hashtables.
		 */
		public GLib.Variant? get_meta (string key);
		/**
		 * Change [property@AstalMpris.Player:loop_status] from none to track,
		 * from track to playlist, from playlist to none.
		 */
		public void loop ();
		/**
		 * Skips to the next track in the tracklist.
		 * If there is no next track (and endless playback and track repeat are both off), stop playback.
		 * If [property@AstalMpris.Player:can_go_next] is `false` this method has no effect.
		 */
		public void next ();
		/**
		 * uri scheme should be an element of [property@AstalMpris.Player:supported_uri_schemes]
		 * and the mime-type should match one of the elements of [property@AstalMpris.Player:supported_mime_types].
		 *
		 * @param uri Uri of the track to load.
		 */
		public void open_uri (string uri);
		/**
		 * Pauses playback.
		 * If playback is already paused, this has no effect.
		 * If [property@AstalMpris.Player:can_pause] is `false` this method has no effect.
		 */
		public void pause ();
		/**
		 * Starts or resumes playback.
		 * If already playing, this has no effect.
		 * If paused, playback resumes from the current position.
		 * If [property@AstalMpris.Player:can_play] is `false` this method has no effect.
		 */
		public void play ();
		/**
		 * Pauses playback.
		 * If playback is already paused, resumes playback.
		 * If playback is stopped, starts playback.
		 */
		public void play_pause ();
		/**
		 * Skips to the previous track in the tracklist.
		 * If there is no previous track (and endless playback and track repeat are both off), stop playback.
		 * If [property@AstalMpris.Player:can_go_previous] is `false` this method has no effect.
		 */
		public void previous ();
		/**
		 * Causes the media player to stop running.
		 * The media player may refuse to allow clients to shut it down.
		 * In this case, the [property@AstalMpris.Player:can_quit] property is false and this method does nothing.
		 */
		public void quit ();
		/**
		 * Brings the player's user interface to the front using any appropriate mechanism available.
		 * The media player may be unable to control how its user interface is displayed,
		 * or it may not have a graphical user interface at all.
		 * In this case, the [property@AstalMpris.Player:can_raise] is `false` and this method does nothing.
		 */
		public void raise ();
		/**
		 * Toggle [property@AstalMpris.Player:shuffle_status].
		 */
		public void shuffle ();
		/**
		 * Stops playback.
		 * If playback is already stopped, this has no effect.
		 * If [property@AstalMpris.Player:can_control] is `false` this method has no effect.
		 */
		public void stop ();
		/**
		 * Toggle [property@AstalMpris.Player:fullscreen] state.
		 */
		public void toggle_fullscreen ();
		/**
		 * Title of the currently playing album.
		 */
		public string album { get; private set; }
		/**
		 * Artists of the currently playing album.
		 */
		public string album_artist { get; private set; }
		/**
		 * The location of an image representing the track or album.
		 * You might prefer using [property@AstalMpris.Player:cover_art].
		 */
		public string art_url { get; private set; }
		/**
		 * Artists of the currently playing track.
		 */
		public string artist { get; private set; }
		/**
		 * Indicates if [property@AstalMpris.Player:bus_name] is available on dbus.
		 */
		public bool available { get; private set; }
		/**
		 * Full dbus nama of this player.
		 */
		public string bus_name { get; private set; }
		/**
		 * Indicates if the player can be controlled with
		 * methods such as [method@AstalMpris.Player.play_pause].
		 */
		public bool can_control { get; private set; }
		/**
		 * Indicates if invoking [method@AstalMpris.Player.next] has effect.
		 */
		public bool can_go_next { get; private set; }
		/**
		 * Indicates if invoking [method@AstalMpris.Player.previous] has effect.
		 */
		public bool can_go_previous { get; private set; }
		/**
		 * Indicates if invoking [method@AstalMpris.Player.pause] has effect.
		 */
		public bool can_pause { get; private set; }
		/**
		 * Indicates if invoking [method@AstalMpris.Player.play] has effect.
		 */
		public bool can_play { get; private set; }
		/**
		 * Indicates if [method@AstalMpris.Player.quit] has any effect.
		 */
		public bool can_quit { get; private set; }
		/**
		 * Indicates if [method@AstalMpris.Player.raise] has any effect.
		 */
		public bool can_raise { get; private set; }
		/**
		 * Indicates if setting [property@AstalMpris.Player:position] has effect.
		 */
		public bool can_seek { get; private set; }
		/**
		 * Indicates if [method@AstalMpris.Player.toggle_fullscreen] has any effect.
		 */
		public bool can_set_fullscreen { get; private set; }
		/**
		 * Comments of the currently playing track.
		 */
		public string comments { get; private set; }
		/**
		 * Composers of the currently playing track.
		 */
		public string composer { get; private set; }
		/**
		 * Path of the cached [property@AstalMpris.Player:art_url].
		 */
		public string cover_art { get; private set; }
		/**
		 * The base name of a .desktop file
		 */
		public string entry { get; private set; }
		/**
		 * Indicates if the player is occupying the fullscreen. This is typically used for videos.
		 * Use [method@AstalMpris.Player.toggle_fullscreen] to toggle fullscreen state.
		 */
		public bool fullscreen { get; private set; }
		/**
		 * A human friendly name to identify the player.
		 */
		public string identity { get; private set; }
		/**
		 * Length of the currently playing track in seconds.
		 */
		public double length { get; private set; }
		/**
		 * The current loop/repeat status.
		 */
		public AstalMpris.Loop loop_status { get; set; }
		/**
		 * Lyrics of the currently playing track.
		 */
		public string lyrics { get; private set; }
		/**
		 * The maximum value which the [property@AstalMpris.Player:rate] can take.
		 */
		public double maximum_rate { get; private set; }
		/**
		 * Metadata of this player.
		 */
		public GLib.Variant metadata { get; private set; }
		/**
		 * The minimum value which the [property@AstalMpris.Player:rate] can take.
		 */
		public double minimum_rate { get; private set; }
		/**
		 * The current playback status.
		 */
		public AstalMpris.PlaybackStatus playback_status { get; private set; }
		/**
		 * The current position of the track in seconds or -1 when it is unsupported.
		 * To get a progress percentage simply divide this with [property@AstalMpris.Player:length].
		 */
		public double position { get; set; }
		/**
		 * The current playback rate.
		 */
		public double rate { get; set; }
		/**
		 * The current shuffle status.
		 */
		public AstalMpris.Shuffle shuffle_status { get; set; }
		/**
		 * The mime-types supported by the player.
		 */
		public string[] supported_mime_types { get; private set; }
		/**
		 * The URI schemes supported by the media player.
		 * This can be viewed as protocols supported by the player in almost all cases.
		 * Almost every media player will include support for the "file" scheme.
		 * Other common schemes are "http" and "rtsp".
		 */
		public string[] supported_uri_schemes { get; private set; }
		/**
		 * Title of the currently playing track.
		 */
		public string title { get; private set; }
		/**
		 * Currently playing track's id.
		 */
		public string trackid { get; private set; }
		/**
		 * The current volume level between 0 and 1 or -1 when it is unsupported.
		 */
		public double volume { get; set; }
	}
	[CCode (cheader_filename = "astal-mpris.h")]
	public enum Loop {
		UNSUPPORTED,
		/** The playback will stop when there are no more tracks to play. */
		NONE,
		/** The current track will start again from the begining once it has finished playing. */
		TRACK,
		/** The playback loops through a list of tracks. */
		PLAYLIST;
	}
	[CCode (cheader_filename = "astal-mpris.h")]
	public enum PlaybackStatus {
		PLAYING,
		PAUSED,
		STOPPED;
	}
	[CCode (cheader_filename = "astal-mpris.h")]
	public enum Shuffle {
		UNSUPPORTED,
		/** Playback is progressing through a playlist in some other order. */
		ON,
		/** Playback is progressing linearly through a playlist. */
		OFF;
	}
	[CCode (cheader_filename = "astal-mpris.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-mpris.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-mpris.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-mpris.h")]
	public const string VERSION;
	/**
	 * Gets the default singleton Mpris instance.
	 */
	[CCode (cheader_filename = "astal-mpris.h")]
	public static AstalMpris.Mpris get_default ();
}
