/* astal-battery-0.1.vapi generated by valac 0.56.18-dirty, do not modify. */

[CCode (gir_namespace = "AstalBattery", gir_version = "0.1")]
namespace AstalBattery {
	/**
	 * Client for a UPower [[https://upower.freedesktop.org/docs/Device.html|device]].
	 */
	[CCode (cheader_filename = "astal-battery.h")]
	public class Device : GLib.Object {
		public Device (GLib.ObjectPath path) throws GLib.Error;
		/** Get the DisplayDevice. */
		public static AstalBattery.Device? get_default ();
		/**
		 * An icon name in the form of "battery-level-$percentage-$state-symbolic".
		 */
		public string battery_icon_name { get; private set; }
		/**
		 * The level of the battery for devices which do not report a percentage
		 * but rather a coarse battery level. If the value is None.
		 * then the device does not support coarse battery reporting,
		 * and the [property@AstalBattery.Device:percentage] should be used instead.
		 */
		public AstalBattery.BatteryLevel battery_level { get; private set; }
		/**
		 * The capacity of the power source expressed as a percentage between 0 and 1.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double capacity { get; private set; }
		/**
		 * The number of charge cycles as defined by the TCO certification,
		 * or -1 if that value is unknown or not applicable.
		 */
		public int charge_cycles { get; private set; }
		/**
		 * Indicates if [property@AstalBattery.Device:state] is charging or fully charged.
		 */
		public bool charging { get; private set; }
		/**
		 * If it is [enum@AstalBattery.Type.BATTERY], you will need to verify that the
		 * property power-supply has the value `true` before considering it as a laptop battery.
		 * Otherwise it will likely be the battery for a device of an unknown type.
		 */
		public AstalBattery.Type device_type { get; private set; }
		/**
		 * An icon name that can be used to represent this device's [property@AstalBattery.Device:device_type].
		 */
		public string device_type_icon { get; private set; }
		/**
		 * A string representation of this device's [property@AstalBattery.Device:device_type].
		 */
		public string device_type_name { get; private set; }
		/**
		 * Amount of energy (measured in Wh) currently available in the power source.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double energy { get; private set; }
		/**
		 * Amount of energy (measured in Wh) in the power source when it's considered to be empty.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double energy_empty { get; private set; }
		/**
		 * Amount of energy (measured in Wh) in the power source when it's considered full.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double energy_full { get; private set; }
		/**
		 * Amount of energy (measured in Wh) the power source is designed to hold when it's considered full.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double energy_full_design { get; private set; }
		/**
		 * Amount of energy being drained from the source, measured in W.
		 * If positive, the source is being discharged, if negative it's being charged.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double energy_rate { get; private set; }
		/**
		 * An icon name representing this Device.
		 *
		 * NOTE: [property@AstalBattery.Device:battery_icon_name] might be a better fit
		 * as it is calculated from percentage.
		 */
		public string icon_name { owned get; private set; }
		/**
		 * Indicates if [property@AstalBattery.Device:device_type] is not line power or unknown.
		 */
		public bool is_battery { get; private set; }
		/**
		 * If the power source is present in the bay.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public bool is_present { get; private set; }
		/**
		 * If the power source is rechargeable.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public bool is_rechargable { get; private set; }
		/** Luminosity being recorded by the meter. */
		public double luminosity { get; private set; }
		/** Name of the model of this battery. */
		public string model { owned get; private set; }
		/**
		 * Native path of the power source. This is the sysfs path,
		 * for example /sys/devices/LNXSYSTM:00/device:00/PNP0C0A:00/power_supply/BAT0.
		 * It is blank if the device is being driven by a user space driver.
		 */
		public string native_path { owned get; private set; }
		/**
		 * Whether power is currently being provided through line power.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.LINE_POWER].
		 */
		public bool online { get; private set; }
		/**
		 * The amount of energy left in the power source expressed as a percentage between 0 and 1.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 * The percentage will be an approximation if [property@AstalBattery.Device:battery_level]
		 * is set to something other than None.
		 */
		public double percentage { get; private set; }
		/**
		 * If the power device is used to supply the system.
		 * This would be set `true` for laptop batteries and UPS devices,
		 * but set to `false` for wireless mice or PDAs.
		 */
		public bool power_supply { get; private set; }
		/** Unique serial number of the battery. */
		public string serial { owned get; private set; }
		/**
		 * The battery power state.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public AstalBattery.State state { get; private set; }
		/**
		 * Technology used in the battery:
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public AstalBattery.Technology technology { get; private set; }
		/**
		 * The temperature of the device in degrees Celsius.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public double temperature { get; private set; }
		/**
		 * Number of seconds until the power source is considered empty. Is set to 0 if unknown.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public int64 time_to_empty { get; private set; }
		/**
		 * Number of seconds until the power source is considered full. Is set to 0 if unknown.
		 *
		 * This property is only valid if [property@AstalBattery.Device:device_type] is [enum@AstalBattery.Type.BATTERY].
		 */
		public int64 time_to_full { get; private set; }
		/**
		 * The point in time (seconds since the Epoch)
		 * that data was read from the power source.
		 */
		public uint64 update_time { get; private set; }
		/** Name of the vendor of the battery. */
		public string vendor { owned get; private set; }
		/** Voltage in the Cell or being recorded by the meter. */
		public double voltage { get; private set; }
		/** Warning level of the battery. */
		public AstalBattery.WarningLevel warning_level { get; private set; }
	}
	/**
	 * Client for the UPower [[https://upower.freedesktop.org/docs/UPower.html|dbus interface]].
	 */
	[CCode (cheader_filename = "astal-battery.h")]
	public class UPower : GLib.Object {
		public UPower ();
		/**
		 * When the system's power supply is critical (critically low batteries or UPS),
		 * the system will take this action.
		 */
		public string critical_action { owned get; }
		public string daemon_version { owned get; }
		/** List of UPower devices. */
		public GLib.List<weak AstalBattery.Device> devices { owned get; }
		/** A composite device that represents the battery status. */
		public AstalBattery.Device display_device { owned get; }
		/** Indicates if the laptop lid is closed where the display cannot be seen. */
		public bool lid_is_closed { get; }
		/** Indicates if the system has a lid device. */
		public bool lid_is_present { get; }
		/** Indicates whether the system is running on battery power. */
		public bool on_battery { get; }
		/** Emitted when a new device is connected. */
		public signal void device_added (AstalBattery.Device device);
		/** Emitted a new device is disconnected. */
		public signal void device_removed (AstalBattery.Device device);
	}
	[CCode (cheader_filename = "astal-battery.h", type_signature = "u")]
	public enum BatteryLevel {
		UNKNOWN,
		NONE,
		LOW,
		CRITICIAL,
		NORMAL,
		HIGH,
		FULL
	}
	[CCode (cheader_filename = "astal-battery.h", type_signature = "u")]
	public enum State {
		UNKNOWN,
		CHARGING,
		DISCHARGING,
		EMPTY,
		FULLY_CHARGED,
		PENDING_CHARGE,
		PENDING_DISCHARGE
	}
	[CCode (cheader_filename = "astal-battery.h", type_signature = "u")]
	public enum Technology {
		UNKNOWN,
		LITHIUM_ION,
		LITHIUM_POLYMER,
		LITHIUM_IRON_PHOSPHATE,
		LEAD_ACID,
		NICKEL_CADMIUM,
		NICKEL_METAL_HYDRIDE
	}
	[CCode (cheader_filename = "astal-battery.h", type_signature = "u")]
	public enum Type {
		UNKNOWN,
		LINE_POWER,
		BATTERY,
		UPS,
		MONITOR,
		MOUSE,
		KEYBOARD,
		PDA,
		PHONE,
		MEDIA_PLAYER,
		TABLET,
		COMPUTER,
		GAMING_INPUT,
		PEN,
		TOUCHPAD,
		MODEM,
		NETWORK,
		HEADSET,
		SPEAKERS,
		HEADPHONES,
		VIDEO,
		OTHER_AUDIO,
		REMOVE_CONTROL,
		PRINTER,
		SCANNER,
		CAMERA,
		WEARABLE,
		TOY,
		BLUETOOTH_GENERIC;
	}
	[CCode (cheader_filename = "astal-battery.h", type_signature = "u")]
	public enum WarningLevel {
		UNKNOWN,
		NONE,
		DISCHARGING,
		LOW,
		CRITICIAL,
		ACTION
	}
	[CCode (cheader_filename = "astal-battery.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "astal-battery.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "astal-battery.h")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "astal-battery.h")]
	public const string VERSION;
	/** Get the DisplayDevice. */
	[CCode (cheader_filename = "astal-battery.h")]
	public static AstalBattery.Device get_default ();
}
