/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.client.jdk;

import ai.grazie.client.common.HTTPClient;
import ai.grazie.client.common.model.HTTPResponse;
import ai.grazie.client.common.model.Multipart;
import ai.grazie.client.common.model.RequestOptions;
import ai.grazie.model.cloud.HeaderCollection;
import ai.grazie.model.cloud.HeaderCollectionKt;
import ai.grazie.model.cloud.exceptions.HTTPConnectionError;
import ai.grazie.model.cloud.exceptions.HTTPStatusException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0012\u001a\u00020\t2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\u0014H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/grazie/client/jdk/GrazieJdkHTTPClient;", "Lai/grazie/client/common/HTTPClient;", "delegate", "Ljava/net/http/HttpClient;", "timeout", "Ljava/time/Duration;", "<init>", "(Ljava/net/http/HttpClient;Ljava/time/Duration;)V", "send", "Lai/grazie/client/common/model/HTTPResponse;", "url", "", "content", "", "options", "Lai/grazie/client/common/model/RequestOptions;", "Lai/grazie/client/common/model/Multipart;", "get", "handle", "body", "Lkotlin/Function0;", "Ljava/net/http/HttpResponse;", "append", "Ljava/net/http/HttpRequest$Builder;", "headers", "Lai/grazie/model/cloud/HeaderCollection;", "Companion", "client-common"})
public final class GrazieJdkHTTPClient
implements HTTPClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpClient delegate;
    @NotNull
    private final Duration timeout;
    @NotNull
    private static final GrazieJdkHTTPClient Default;

    public GrazieJdkHTTPClient(@NotNull HttpClient delegate, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.delegate = delegate;
        this.timeout = timeout;
    }

    public /* synthetic */ GrazieJdkHTTPClient(HttpClient httpClient, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            duration = Duration.ofSeconds(10L);
        }
        this(httpClient, duration);
    }

    @Override
    @NotNull
    public HTTPResponse send(@NotNull String url, @NotNull byte[] content, @NotNull RequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        return this.handle((Function0<? extends HttpResponse<byte[]>>)((Function0)() -> GrazieJdkHTTPClient.send$lambda$0(this, url, options, content)));
    }

    @Override
    @NotNull
    public HTTPResponse send(@NotNull String url, @NotNull RequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        return this.handle((Function0<? extends HttpResponse<byte[]>>)((Function0)() -> GrazieJdkHTTPClient.send$lambda$1(this, url, options)));
    }

    @Override
    @NotNull
    public HTTPResponse send(@NotNull String url, @NotNull Multipart content, @NotNull RequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        throw new IllegalStateException("That client does not support Multipart".toString());
    }

    @Override
    @NotNull
    public HTTPResponse get(@NotNull String url, @NotNull RequestOptions options) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)options), (String)"options");
        return this.handle((Function0<? extends HttpResponse<byte[]>>)((Function0)() -> GrazieJdkHTTPClient.get$lambda$2(this, url, options)));
    }

    private final HTTPResponse handle(Function0<? extends HttpResponse<byte[]>> body) {
        HTTPResponse hTTPResponse;
        try {
            HttpResponse response2 = (HttpResponse)body.invoke();
            int code = response2.statusCode();
            if (!(200 <= code ? code < 300 : false)) {
                Map<String, List<String>> map2 = response2.headers().map();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"map(...)");
                throw HTTPStatusException.Companion.from$default((HTTPStatusException.Companion)HTTPStatusException.Companion, (int)code, (HeaderCollection)HeaderCollectionKt.of((HeaderCollection.Companion)HeaderCollection.Companion, map2), null, null, (int)8, null);
            }
            Map<String, List<String>> map3 = response2.headers().map();
            Intrinsics.checkNotNullExpressionValue(map3, (String)"map(...)");
            hTTPResponse = new HTTPResponse(HeaderCollectionKt.of((HeaderCollection.Companion)HeaderCollection.Companion, map3), code, (byte[])response2.body());
        }
        catch (IOException e) {
            throw new HTTPConnectionError(null, (Throwable)e);
        }
        return hTTPResponse;
    }

    private final HttpRequest.Builder append(HttpRequest.Builder $this$append, HeaderCollection headers) {
        for (String key : headers.getKeys()) {
            String[] values;
            if (headers.get(key) == null) continue;
            for (String value : values) {
                $this$append.header(key, value);
            }
        }
        return $this$append;
    }

    private static final HttpResponse send$lambda$0(GrazieJdkHTTPClient this$0, String $url, RequestOptions $options, byte[] $content) {
        HttpClient httpClient = this$0.delegate;
        HttpRequest.Builder builder = HttpRequest.newBuilder(new URI($url)).header("Content-Type", "application/json");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"header(...)");
        HttpResponse<byte[]> httpResponse = httpClient.send(this$0.append(builder, $options.getHeaders()).timeout(this$0.timeout).POST(HttpRequest.BodyPublishers.ofByteArray($content)).build(), HttpResponse.BodyHandlers.ofByteArray());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"send(...)");
        return httpResponse;
    }

    private static final HttpResponse send$lambda$1(GrazieJdkHTTPClient this$0, String $url, RequestOptions $options) {
        HttpClient httpClient = this$0.delegate;
        HttpRequest.Builder builder = HttpRequest.newBuilder(new URI($url));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        HttpResponse<byte[]> httpResponse = httpClient.send(this$0.append(builder, $options.getHeaders()).timeout(this$0.timeout).POST(HttpRequest.BodyPublishers.ofString("")).build(), HttpResponse.BodyHandlers.ofByteArray());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"send(...)");
        return httpResponse;
    }

    private static final HttpResponse get$lambda$2(GrazieJdkHTTPClient this$0, String $url, RequestOptions $options) {
        HttpClient httpClient = this$0.delegate;
        HttpRequest.Builder builder = HttpRequest.newBuilder(new URI($url));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        HttpResponse<byte[]> httpResponse = httpClient.send(this$0.append(builder, $options.getHeaders()).timeout(this$0.timeout).GET().build(), HttpResponse.BodyHandlers.ofByteArray());
        Intrinsics.checkNotNullExpressionValue(httpResponse, (String)"send(...)");
        return httpResponse;
    }

    static {
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)httpClient, (String)"build(...)");
        Default = new GrazieJdkHTTPClient(httpClient, null, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/grazie/client/jdk/GrazieJdkHTTPClient$Companion;", "", "<init>", "()V", "Default", "Lai/grazie/client/jdk/GrazieJdkHTTPClient;", "getDefault", "()Lai/grazie/client/jdk/GrazieJdkHTTPClient;", "client-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GrazieJdkHTTPClient getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

