/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.llm.definitions;

import ai.grazie.model.cloud.ContentType;
import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.chat.v5.LLMChatMediaMessage;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lai/grazie/model/llm/definitions/MediaDataDefinition;", "", "supportedTypes", "", "Lai/grazie/model/cloud/ContentType;", "getSupportedTypes", "()Ljava/util/Set;", "maxNumber", "", "getMaxNumber", "()Ljava/lang/Integer;", "validateMediaData", "", "name", "", "chat", "Lai/grazie/model/llm/chat/v5/LLMChat;", "Companion", "model-llm"})
@SourceDebugExtension(value={"SMAP\nMediaDataDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MediaDataDefinition.kt\nai/grazie/model/llm/definitions/MediaDataDefinition\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,49:1\n4135#2,11:50\n*S KotlinDebug\n*F\n+ 1 MediaDataDefinition.kt\nai/grazie/model/llm/definitions/MediaDataDefinition\n*L\n21#1:50,11\n*E\n"})
public interface MediaDataDefinition {
    @NotNull
    public static final Companion Companion = ai.grazie.model.llm.definitions.MediaDataDefinition$Companion.$$INSTANCE;

    @NotNull
    public Set<ContentType> getSupportedTypes();

    @Nullable
    public Integer getMaxNumber();

    /*
     * WARNING - void declaration
     */
    default public void validateMediaData(@NotNull String name, @NotNull LLMChat chat) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        LLMChatMessage[] lLMChatMessageArray = chat.getMessages();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LLMChatMediaMessage)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mediaElements = (List)destination$iv$iv;
        if (this.getSupportedTypes().isEmpty()) {
            ExtensionsKt.requireOrBadRequest((boolean)mediaElements.isEmpty(), () -> MediaDataDefinition.validateMediaData$lambda$0(name));
        }
        Integer n = this.getMaxNumber();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            ExtensionsKt.requireOrBadRequest((mediaElements.size() <= it ? 1 : 0) != 0, () -> MediaDataDefinition.validateMediaData$lambda$2$lambda$1(it, mediaElements));
        }
        for (LLMChatMediaMessage mediaMessage : mediaElements) {
            ExtensionsKt.requireOrBadRequest((boolean)this.getSupportedTypes().contains(mediaMessage.getMediaType()), () -> MediaDataDefinition.validateMediaData$lambda$3(mediaMessage, this));
        }
    }

    private static String validateMediaData$lambda$0(String $name) {
        return "Media data is not supported for chat " + $name;
    }

    private static String validateMediaData$lambda$2$lambda$1(int $it, List $mediaElements) {
        return "Too many multimedia messages. Maximum allowed is " + $it + ", but found " + $mediaElements.size();
    }

    private static String validateMediaData$lambda$3(LLMChatMediaMessage $mediaMessage, MediaDataDefinition this$0) {
        return "Media data type " + $mediaMessage.getMediaType() + " is not supported. Supported types: " + CollectionsKt.joinToString$default((Iterable)this$0.getSupportedTypes(), null, null, null, (int)0, null, null, (int)63, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/grazie/model/llm/definitions/MediaDataDefinition$Companion;", "", "<init>", "()V", "EMPTY", "Lai/grazie/model/llm/definitions/MediaDataDefinition;", "getEMPTY", "()Lai/grazie/model/llm/definitions/MediaDataDefinition;", "model-llm"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final MediaDataDefinition EMPTY;

        private Companion() {
        }

        @NotNull
        public final MediaDataDefinition getEMPTY() {
            return EMPTY;
        }

        static {
            $$INSTANCE = new Companion();
            EMPTY = new MediaDataDefinition(){
                private final Set<ContentType> supportedTypes;
                private final Integer maxNumber;
                {
                    this.supportedTypes = SetsKt.emptySet();
                }

                public Set<ContentType> getSupportedTypes() {
                    return this.supportedTypes;
                }

                public Integer getMaxNumber() {
                    return this.maxNumber;
                }
            };
        }
    }
}

