/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.model.llm.definitions;

import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.LLMChatRole;
import ai.grazie.model.llm.chat.tool.LLMTool;
import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.chat.v5.LLMChatAssistantMessageTool;
import ai.grazie.model.llm.chat.v5.LLMChatMessage;
import ai.grazie.model.llm.chat.v5.LLMChatToolMessage;
import ai.grazie.model.llm.definitions.LLMFeatureDefinition;
import ai.grazie.model.llm.definitions.MediaDataDefinition;
import ai.grazie.model.llm.definitions.ParameterDefinition;
import ai.grazie.model.llm.definitions.RoleDefinition;
import ai.grazie.model.llm.utils.AttributesExtensionKt;
import ai.grazie.utils.attributes.Attributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fJ$\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0'J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0005H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J%\u0010+\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\tH\u00c6\u0003JM\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072$\b\u0002\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\tH\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u00d6\u0003J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u00020 H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00064"}, d2={"Lai/grazie/model/llm/definitions/ChatDefinition;", "Lai/grazie/model/llm/definitions/LLMFeatureDefinition;", "roleDefinition", "Lai/grazie/model/llm/definitions/RoleDefinition;", "parameterDefinition", "Lai/grazie/model/llm/definitions/ParameterDefinition;", "multimediaDataDefinition", "Lai/grazie/model/llm/definitions/MediaDataDefinition;", "options", "", "Lai/grazie/utils/attributes/Attributes$Key;", "Lkotlin/Function1;", "Lai/grazie/utils/attributes/Attributes;", "Lai/grazie/model/llm/definitions/OptionConfigurer;", "<init>", "(Lai/grazie/model/llm/definitions/RoleDefinition;Lai/grazie/model/llm/definitions/ParameterDefinition;Lai/grazie/model/llm/definitions/MediaDataDefinition;Ljava/util/Map;)V", "getRoleDefinition", "()Lai/grazie/model/llm/definitions/RoleDefinition;", "getParameterDefinition", "()Lai/grazie/model/llm/definitions/ParameterDefinition;", "getMultimediaDataDefinition", "()Lai/grazie/model/llm/definitions/MediaDataDefinition;", "getOptions", "()Ljava/util/Map;", "supportedRoles", "", "Lai/grazie/model/llm/chat/LLMChatRole;", "getSupportedRoles", "()Ljava/util/Set;", "validateChat", "", "name", "", "chat", "Lai/grazie/model/llm/chat/v5/LLMChat;", "parameters", "applyOptions", "profileName", "attributes", "", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "model-llm"})
@SourceDebugExtension(value={"SMAP\nChatDefinition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatDefinition.kt\nai/grazie/model/llm/definitions/ChatDefinition\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n13467#2,2:110\n12567#2,2:112\n12567#2,2:114\n13469#2:120\n4135#2,11:121\n4135#2,11:136\n1557#3:116\n1628#3,3:117\n1557#3:132\n1628#3,3:133\n1557#3:147\n1628#3,3:148\n1797#3,3:151\n*S KotlinDebug\n*F\n+ 1 ChatDefinition.kt\nai/grazie/model/llm/definitions/ChatDefinition\n*L\n37#1:110,2\n39#1:112,2\n40#1:114,2\n37#1:120\n53#1:121,11\n55#1:136,11\n44#1:116\n44#1:117,3\n53#1:132\n53#1:133,3\n55#1:147\n55#1:148,3\n71#1:151,3\n*E\n"})
public final class ChatDefinition
implements LLMFeatureDefinition {
    @NotNull
    private final RoleDefinition roleDefinition;
    @NotNull
    private final ParameterDefinition parameterDefinition;
    @NotNull
    private final MediaDataDefinition multimediaDataDefinition;
    @NotNull
    private final Map<Attributes.Key, Function1<Attributes, Attributes>> options;

    public ChatDefinition(@NotNull RoleDefinition roleDefinition, @NotNull ParameterDefinition parameterDefinition, @NotNull MediaDataDefinition multimediaDataDefinition, @NotNull Map<Attributes.Key, ? extends Function1<? super Attributes, ? extends Attributes>> options) {
        Intrinsics.checkNotNullParameter((Object)roleDefinition, (String)"roleDefinition");
        Intrinsics.checkNotNullParameter((Object)parameterDefinition, (String)"parameterDefinition");
        Intrinsics.checkNotNullParameter((Object)multimediaDataDefinition, (String)"multimediaDataDefinition");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.roleDefinition = roleDefinition;
        this.parameterDefinition = parameterDefinition;
        this.multimediaDataDefinition = multimediaDataDefinition;
        this.options = options;
    }

    public /* synthetic */ ChatDefinition(RoleDefinition roleDefinition, ParameterDefinition parameterDefinition, MediaDataDefinition mediaDataDefinition, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mediaDataDefinition = MediaDataDefinition.Companion.getEMPTY();
        }
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        this(roleDefinition, parameterDefinition, mediaDataDefinition, map);
    }

    @NotNull
    public final RoleDefinition getRoleDefinition() {
        return this.roleDefinition;
    }

    @Override
    @NotNull
    public ParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    @NotNull
    public final MediaDataDefinition getMultimediaDataDefinition() {
        return this.multimediaDataDefinition;
    }

    @NotNull
    public final Map<Attributes.Key, Function1<Attributes, Attributes>> getOptions() {
        return this.options;
    }

    @NotNull
    public final Set<LLMChatRole> getSupportedRoles() {
        return this.roleDefinition.getSupportedRoles();
    }

    /*
     * WARNING - void declaration
     */
    public final void validateChat(@NotNull String name, @NotNull LLMChat chat, @NotNull Attributes parameters) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        ExtensionsKt.requireOrBadRequest((!(chat.getMessages().length == 0) ? 1 : 0) != 0, ChatDefinition::validateChat$lambda$0);
        this.multimediaDataDefinition.validateMediaData(name, chat);
        LLMChatMessage[] $this$forEachIndexed$iv = chat.getMessages();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (LLMChatMessage item$iv : $this$forEachIndexed$iv) {
            Object element$iv;
            void message;
            int n = index$iv++;
            LLMChatMessage lLMChatMessage = item$iv;
            int index = n;
            boolean bl = false;
            if (message instanceof LLMChatToolMessage) {
                boolean bl2;
                block14: {
                    boolean bl3;
                    Object it;
                    int n2;
                    int n3;
                    boolean $i$f$any;
                    LLMChatMessage[] $this$any$iv;
                    block13: {
                        $this$any$iv = chat.getMessages();
                        $i$f$any = false;
                        n3 = $this$any$iv.length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            it = element$iv = $this$any$iv[n2];
                            boolean bl4 = false;
                            if (!(it instanceof LLMChatAssistantMessageTool && Intrinsics.areEqual((Object)((LLMChatAssistantMessageTool)it).getId(), (Object)((LLMChatToolMessage)message).getId()))) continue;
                            bl3 = true;
                            break block13;
                        }
                        bl3 = false;
                    }
                    ExtensionsKt.requireOrBadRequest((boolean)bl3, ChatDefinition::validateChat$lambda$9$lambda$2);
                    $this$any$iv = chat.getMessages();
                    $i$f$any = false;
                    n3 = $this$any$iv.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        it = element$iv = $this$any$iv[n2];
                        boolean bl5 = false;
                        if (!(it instanceof LLMChatAssistantMessageTool && Intrinsics.areEqual((Object)((LLMChatAssistantMessageTool)it).getToolName(), (Object)((LLMChatToolMessage)message).getToolName()))) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
                ExtensionsKt.requireOrBadRequest((boolean)bl2, ChatDefinition::validateChat$lambda$9$lambda$4);
            }
            if (message instanceof LLMChatAssistantMessageTool) {
                boolean bl6;
                List<LLMTool> list = AttributesExtensionKt.getTools(parameters);
                if (list != null) {
                    void $this$mapTo$iv$iv3;
                    Iterable $this$map$iv3 = list;
                    boolean $i$f$map = false;
                    element$iv = $this$map$iv3;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void it;
                        LLMTool lLMTool = (LLMTool)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl7 = false;
                        collection.add(it.getName());
                    }
                    bl6 = ((List)destination$iv$iv).contains(((LLMChatAssistantMessageTool)message).getToolName());
                } else {
                    bl6 = false;
                }
                ExtensionsKt.requireOrBadRequest((boolean)bl6, ChatDefinition::validateChat$lambda$9$lambda$6);
            }
            LLMChatMessage previousMessage = (LLMChatMessage)ArraysKt.getOrNull((Object[])chat.getMessages(), (int)(index - 1));
            if (message instanceof LLMChatToolMessage) {
                ExtensionsKt.requireOrBadRequest((previousMessage instanceof LLMChatAssistantMessageTool || previousMessage instanceof LLMChatToolMessage ? 1 : 0) != 0, ChatDefinition::validateChat$lambda$9$lambda$7);
            }
            LLMChatMessage nextMessage = (LLMChatMessage)ArraysKt.getOrNull((Object[])chat.getMessages(), (int)(index + 1));
            if (!(message instanceof LLMChatAssistantMessageTool)) continue;
            ExtensionsKt.requireOrBadRequest((nextMessage instanceof LLMChatToolMessage || nextMessage instanceof LLMChatAssistantMessageTool ? 1 : 0) != 0, ChatDefinition::validateChat$lambda$9$lambda$8);
        }
        Object $this$filterIsInstance$iv = chat.getMessages();
        boolean $i$f$filterIsInstance = false;
        LLMChatMessage[] lLMChatMessageArray = $this$filterIsInstance$iv;
        LLMChatMessage[] destination$iv$iv = (LLMChatMessage[])new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof LLMChatAssistantMessageTool)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            LLMChatAssistantMessageTool element$iv$iv = (LLMChatAssistantMessageTool)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getId());
        }
        List assistantToolMessages = (List)destination$iv$iv;
        ExtensionsKt.requireOrBadRequest((CollectionsKt.toSet((Iterable)assistantToolMessages).size() == assistantToolMessages.size() ? 1 : 0) != 0, ChatDefinition::validateChat$lambda$11);
        Object $this$filterIsInstance$iv2 = chat.getMessages();
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LLMChatToolMessage)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LLMChatToolMessage element$iv$iv = (LLMChatToolMessage)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(it.getId());
        }
        List toolMessages = (List)destination$iv$iv2;
        ExtensionsKt.requireOrBadRequest((CollectionsKt.toSet((Iterable)toolMessages).size() == toolMessages.size() ? 1 : 0) != 0, ChatDefinition::validateChat$lambda$13);
        this.roleDefinition.validateMessages(name, chat.getMessages());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Attributes applyOptions(@NotNull String profileName, @NotNull Attributes attributes, @NotNull List<? extends Attributes.Key> options) {
        Intrinsics.checkNotNullParameter((Object)profileName, (String)"profileName");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Iterable $this$fold$iv = options;
        boolean $i$f$fold = false;
        Attributes accumulator$iv = attributes;
        for (Object element$iv : $this$fold$iv) {
            void option;
            Attributes.Key key = (Attributes.Key)element$iv;
            Attributes acc = accumulator$iv;
            boolean bl = false;
            Function1<Attributes, Attributes> configurator = this.options.get(option);
            ExtensionsKt.requireNotNullOrBadRequest(configurator, () -> ChatDefinition.applyOptions$lambda$15$lambda$14((Attributes.Key)option, profileName));
            accumulator$iv = (Attributes)configurator.invoke((Object)acc);
        }
        return accumulator$iv;
    }

    @NotNull
    public final RoleDefinition component1() {
        return this.roleDefinition;
    }

    @NotNull
    public final ParameterDefinition component2() {
        return this.parameterDefinition;
    }

    @NotNull
    public final MediaDataDefinition component3() {
        return this.multimediaDataDefinition;
    }

    @NotNull
    public final Map<Attributes.Key, Function1<Attributes, Attributes>> component4() {
        return this.options;
    }

    @NotNull
    public final ChatDefinition copy(@NotNull RoleDefinition roleDefinition, @NotNull ParameterDefinition parameterDefinition, @NotNull MediaDataDefinition multimediaDataDefinition, @NotNull Map<Attributes.Key, ? extends Function1<? super Attributes, ? extends Attributes>> options) {
        Intrinsics.checkNotNullParameter((Object)roleDefinition, (String)"roleDefinition");
        Intrinsics.checkNotNullParameter((Object)parameterDefinition, (String)"parameterDefinition");
        Intrinsics.checkNotNullParameter((Object)multimediaDataDefinition, (String)"multimediaDataDefinition");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        return new ChatDefinition(roleDefinition, parameterDefinition, multimediaDataDefinition, options);
    }

    public static /* synthetic */ ChatDefinition copy$default(ChatDefinition chatDefinition, RoleDefinition roleDefinition, ParameterDefinition parameterDefinition, MediaDataDefinition mediaDataDefinition, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            roleDefinition = chatDefinition.roleDefinition;
        }
        if ((n & 2) != 0) {
            parameterDefinition = chatDefinition.parameterDefinition;
        }
        if ((n & 4) != 0) {
            mediaDataDefinition = chatDefinition.multimediaDataDefinition;
        }
        if ((n & 8) != 0) {
            map = chatDefinition.options;
        }
        return chatDefinition.copy(roleDefinition, parameterDefinition, mediaDataDefinition, map);
    }

    @NotNull
    public String toString() {
        return "ChatDefinition(roleDefinition=" + this.roleDefinition + ", parameterDefinition=" + this.parameterDefinition + ", multimediaDataDefinition=" + this.multimediaDataDefinition + ", options=" + this.options + ")";
    }

    public int hashCode() {
        int result = this.roleDefinition.hashCode();
        result = result * 31 + this.parameterDefinition.hashCode();
        result = result * 31 + this.multimediaDataDefinition.hashCode();
        result = result * 31 + ((Object)this.options).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChatDefinition)) {
            return false;
        }
        ChatDefinition chatDefinition = (ChatDefinition)other;
        if (!Intrinsics.areEqual((Object)this.roleDefinition, (Object)chatDefinition.roleDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameterDefinition, (Object)chatDefinition.parameterDefinition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.multimediaDataDefinition, (Object)chatDefinition.multimediaDataDefinition)) {
            return false;
        }
        return Intrinsics.areEqual(this.options, chatDefinition.options);
    }

    private static final String validateChat$lambda$0() {
        return "Chat messages cannot be empty";
    }

    private static final String validateChat$lambda$9$lambda$2() {
        return "LLMChatToolMessage must have the same tool call id as LLMChatAssistantMessageTool";
    }

    private static final String validateChat$lambda$9$lambda$4() {
        return "LLMChatToolMessage must have the same tool name as LLMChatAssistantMessageTool";
    }

    private static final String validateChat$lambda$9$lambda$6() {
        return "LLMChatAssistantMessageTool must have a tool name that is specified in the tools list in the parameters";
    }

    private static final String validateChat$lambda$9$lambda$7() {
        return "LLMChatToolMessage must be a response to a preceding LLMChatAssistantMessageTool";
    }

    private static final String validateChat$lambda$9$lambda$8() {
        return "LLMChatAssistantMessageTool require a response LLMChatToolMessage";
    }

    private static final String validateChat$lambda$11() {
        return "LLMChatAssistantMessageTools tool call ids are not unique";
    }

    private static final String validateChat$lambda$13() {
        return "LLMChatToolMessages tool call ids are not unique";
    }

    private static final String applyOptions$lambda$15$lambda$14(Attributes.Key $option, String $profileName) {
        return "Option " + $option.getFqdn() + "} is not supported for " + $profileName + " profile";
    }
}

