/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.toolbox.platform.image.internal;

import com.jetbrains.toolbox.platform.image.ImageType;
import com.jetbrains.toolbox.platform.image.internal.ImageData;
import com.jetbrains.toolbox.platform.resource.ResourceReader;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a,\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006\u001a\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006\"\u0018\u0010\u000b\u001a\u00020\u0004*\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"readImageData", "Lcom/jetbrains/toolbox/platform/image/internal/ImageData;", "Lcom/jetbrains/toolbox/platform/resource/ResourceReader;", "resourceName", "", "isDark", "", "type", "Lcom/jetbrains/toolbox/platform/image/ImageType;", "allowTint", "themeSuffix", "fileExtension", "getFileExtension", "(Lcom/jetbrains/toolbox/platform/image/ImageType;)Ljava/lang/String;", "imageDataType", "resourcePath", "image"})
@ApiStatus.Internal
public final class ImageResourceImplKt {
    @Nullable
    public static final ImageData readImageData(@NotNull ResourceReader $this$readImageData, @NotNull String resourceName, boolean isDark, @NotNull ImageType type, boolean allowTint) {
        Intrinsics.checkNotNullParameter((Object)$this$readImageData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        byte[] byArray = $this$readImageData.readBytes(resourceName + ImageResourceImplKt.themeSuffix(isDark) + ImageResourceImplKt.getFileExtension(type));
        if (byArray == null && (byArray = $this$readImageData.readBytes(resourceName + ImageResourceImplKt.getFileExtension(type))) == null) {
            return null;
        }
        byte[] bytes = byArray;
        return new ImageData(bytes, type, allowTint);
    }

    private static final String themeSuffix(boolean isDark) {
        return isDark ? "_dark" : "_light";
    }

    @NotNull
    public static final String getFileExtension(@NotNull ImageType $this$fileExtension) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$fileExtension), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$fileExtension.ordinal()]) {
            case 1 -> ".svg";
            case 2 -> ".png";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final ImageType imageDataType(String resourcePath) {
        ImageType imageType;
        if (StringsKt.endsWith$default((String)resourcePath, (String)".svg", (boolean)false, (int)2, null)) {
            imageType = ImageType.SVG;
        } else if (StringsKt.endsWith$default((String)resourcePath, (String)".png", (boolean)false, (int)2, null)) {
            imageType = ImageType.PNG;
        } else {
            throw new IllegalArgumentException("Unknown resource type by " + resourcePath);
        }
        return imageType;
    }

    @Nullable
    public static final ImageData readImageData(@NotNull ResourceReader $this$readImageData, @NotNull String resourcePath, boolean allowTint) {
        Intrinsics.checkNotNullParameter((Object)$this$readImageData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        ImageType imageDataType = ImageResourceImplKt.imageDataType(resourcePath);
        byte[] byArray = $this$readImageData.readBytes(resourcePath);
        if (byArray == null) {
            return null;
        }
        byte[] bytes = byArray;
        return new ImageData(bytes, imageDataType, allowTint);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageType.values().length];
            try {
                nArray[ImageType.SVG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageType.PNG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

