/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.rpc.krpc.client.internal;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.rpc.internal.utils.map.ConcurrentHashMap_jvmKt;
import kotlinx.rpc.internal.utils.map.RpcInternalConcurrentHashMap;
import kotlinx.rpc.internal.utils.thread.RpcInternalThreadLocal;
import kotlinx.rpc.krpc.client.internal.StreamCall;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\f\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00062\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0012\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R)\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001e\u00a8\u0006!"}, d2={"Lkotlinx/rpc/krpc/client/internal/ClientStreamContext;", "", "", "connectionId", "<init>", "(Ljava/lang/Long;)V", "T", "", "callId", "serviceId", "Lkotlin/Function0;", "body", "scoped", "(Ljava/lang/String;JLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lkotlinx/coroutines/flow/Flow;", "value", "Lkotlinx/serialization/KSerializer;", "elementKind", "registerClientStream", "(Lkotlinx/coroutines/flow/Flow;Lkotlinx/serialization/KSerializer;)Ljava/lang/String;", "Ljava/lang/Long;", "Lkotlinx/rpc/internal/utils/map/RpcInternalConcurrentHashMap;", "", "Lkotlinx/rpc/krpc/client/internal/StreamCall;", "streams", "Lkotlinx/rpc/internal/utils/map/RpcInternalConcurrentHashMap;", "getStreams", "()Lkotlinx/rpc/internal/utils/map/RpcInternalConcurrentHashMap;", "Lkotlinx/rpc/internal/utils/thread/RpcInternalThreadLocal;", "currentCallId", "Lkotlinx/rpc/internal/utils/thread/RpcInternalThreadLocal;", "currentServiceId", "Companion", "krpc-client"})
public final class ClientStreamContext {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private final Long connectionId;
    @NotNull
    private final RpcInternalConcurrentHashMap<String, List<StreamCall>> streams;
    @NotNull
    private final RpcInternalThreadLocal<String> currentCallId;
    @NotNull
    private final RpcInternalThreadLocal<Long> currentServiceId;
    @NotNull
    private volatile /* synthetic */ long streamIdCounter;
    private static final /* synthetic */ AtomicLongFieldUpdater streamIdCounter$FU;
    @NotNull
    private static final String STREAM_ID_PREFIX = "stream:";

    public ClientStreamContext(@Nullable Long connectionId) {
        this.connectionId = connectionId;
        this.streams = ConcurrentHashMap_jvmKt.RpcInternalConcurrentHashMap$default((int)0, (int)1, null);
        this.currentCallId = new RpcInternalThreadLocal();
        this.currentServiceId = new RpcInternalThreadLocal();
        this.streamIdCounter = 0L;
    }

    @NotNull
    public final RpcInternalConcurrentHashMap<String, List<StreamCall>> getStreams() {
        return this.streams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T scoped(@NotNull String callId, long serviceId, @NotNull Function0<? extends T> body) {
        Intrinsics.checkNotNullParameter((Object)callId, (String)"callId");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        try {
            this.currentCallId.set((Object)callId);
            this.currentServiceId.set((Object)serviceId);
            Object object = body.invoke();
            return (T)object;
        }
        finally {
            this.currentCallId.remove();
            this.currentServiceId.remove();
        }
    }

    @NotNull
    public final String registerClientStream(@NotNull Flow<?> value, @NotNull KSerializer<?> elementKind) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(elementKind, (String)"elementKind");
        String string = (String)this.currentCallId.get();
        if (string == null) {
            throw new IllegalStateException("No call id".toString());
        }
        String callId = string;
        Long l = (Long)this.currentServiceId.get();
        if (l == null) {
            throw new IllegalStateException("No service id".toString());
        }
        long serviceId = l;
        String streamId = STREAM_ID_PREFIX + streamIdCounter$FU.getAndIncrement(this);
        StreamCall stream = new StreamCall(callId, streamId, value, elementKind, this.connectionId, serviceId);
        this.streams.merge((Object)callId, (Object)CollectionsKt.listOf((Object)stream), ClientStreamContext::registerClientStream$lambda$0);
        return streamId;
    }

    private static final List registerClientStream$lambda$0(List old, List list) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)list, (String)"new");
        return CollectionsKt.plus((Collection)old, (Iterable)list);
    }

    static {
        streamIdCounter$FU = AtomicLongFieldUpdater.newUpdater(ClientStreamContext.class, "streamIdCounter");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkotlinx/rpc/krpc/client/internal/ClientStreamContext$Companion;", "", "<init>", "()V", "", "STREAM_ID_PREFIX", "Ljava/lang/String;", "krpc-client"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

