/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.security.cert.Certificate;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nCertificateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateUtils.kt\norg/jetbrains/zip/signer/signer/CertificateUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,210:1\n1563#2:211\n1634#2,3:212\n1740#2,3:215\n1563#2:218\n1634#2,3:219\n3544#2,7:226\n13472#3:222\n13472#3,2:223\n13473#3:225\n*S KotlinDebug\n*F\n+ 1 CertificateUtils.kt\norg/jetbrains/zip/signer/signer/CertificateUtils\n*L\n56#1:211\n56#1:212,3\n88#1:215,3\n105#1:218\n105#1:219,3\n167#1:226,7\n131#1:222\n135#1:223,2\n131#1:225\n*E\n"})
public final class CertificateUtils {
    @NotNull
    public static final CertificateUtils INSTANCE = new CertificateUtils();
    @NotNull
    private static final Date farAwayDate;

    private CertificateUtils() {
    }

    public final boolean isValidCertificateChain(@NotNull List<? extends Certificate> certs) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(certs, (String)"certs");
            Iterable $this$all$iv = CollectionsKt.zipWithNext((Iterable)certs);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isSignedBy((Certificate)it.getFirst(), (Certificate)it.getSecond())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isSignedBy(Certificate $this$isSignedBy, Certificate other) {
        boolean bl;
        try {
            $this$isSignedBy.verify(other.getPublicKey());
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    static {
        Date date = Date.from(LocalDate.of(9999, 12, 31).atStartOfDay().toInstant(ZoneOffset.UTC));
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(...)");
        farAwayDate = date;
    }
}

