/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.proto.SignatureDataProto;

public final class SignatureData {
    @NotNull
    private final SignatureAlgorithm algorithm;
    @NotNull
    private final byte[] signatureBytes;
    @NotNull
    private final SignatureDataProto protobufRepresentation;

    private SignatureData(SignatureAlgorithm algorithm, byte[] signatureBytes, SignatureDataProto protobufRepresentation) {
        this.algorithm = algorithm;
        this.signatureBytes = signatureBytes;
        this.protobufRepresentation = protobufRepresentation;
    }

    @NotNull
    public final SignatureAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public SignatureData(@NotNull SignatureDataProto protobufRepresentation) {
        Intrinsics.checkNotNullParameter((Object)protobufRepresentation, (String)"protobufRepresentation");
        SignatureDataProto.AlgorithmId algorithmId = protobufRepresentation.getAlgorithmId();
        Intrinsics.checkNotNullExpressionValue((Object)algorithmId, (String)"getAlgorithmId(...)");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.Companion.fromProtobufEnum(algorithmId);
        byte[] byArray = protobufRepresentation.getSignatureBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        this(signatureAlgorithm, byArray, protobufRepresentation);
    }
}

