/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.datasource;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;

public final class SeekableByteChannelDataSource
implements DataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SeekableByteChannel channel;
    private final long offset;
    @Nullable
    private final Long size;

    public SeekableByteChannelDataSource(@NotNull SeekableByteChannel channel, long offset, @Nullable Long size) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.offset = offset;
        this.size = size;
        if (this.offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + this.size);
        }
        if (this.size != null && this.size < 0L) {
            throw new IndexOutOfBoundsException("size: " + this.size);
        }
    }

    public /* synthetic */ SeekableByteChannelDataSource(SeekableByteChannel seekableByteChannel, long l, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        this(seekableByteChannel, l, l2);
    }

    @Override
    public long size() {
        Long l = this.size;
        return l != null ? l.longValue() : this.channel.size();
    }

    @Override
    @NotNull
    public SeekableByteChannelDataSource slice(long offset, long size) {
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        return offset == 0L && size == sourceSize ? this : new SeekableByteChannelDataSource(this.channel, this.offset + offset, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(long offset, int size, @NotNull ByteBuffer dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        if (size == 0) {
            return;
        }
        if (size > dest.remaining()) {
            throw new BufferOverflowException();
        }
        long offsetInFile = this.offset + offset;
        int prevLimit = dest.limit();
        try {
            int chunkSize;
            dest.limit(dest.position() + size);
            for (int remaining = size; remaining > 0; remaining -= chunkSize) {
                this.channel.position(offsetInFile);
                chunkSize = this.channel.read(dest);
                offsetInFile += (long)chunkSize;
            }
        }
        finally {
            dest.limit(prevLimit);
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size) {
        if (size < 0) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        ByteBuffer result2 = ByteBuffer.allocate(size);
        Intrinsics.checkNotNull((Object)result2);
        this.copyTo(offset, size, result2);
        result2.flip();
        return result2;
    }

    public static final class Companion {
        private Companion() {
        }

        private final void checkChunkValid(long offset, long size, long sourceSize) {
            long endOffset = offset + size;
            if (offset < 0L) {
                throw new IndexOutOfBoundsException("offset: " + offset);
            }
            if (size < 0L) {
                throw new IndexOutOfBoundsException("size: " + size);
            }
            if (offset > sourceSize) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + sourceSize + ')');
            }
            if (endOffset < offset) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
            }
            if (endOffset > sourceSize) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + sourceSize + ')');
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

