/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public abstract sealed class TextMateSelectorToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TextMateSelectorToken COMMA = new SignToken(',');
    @NotNull
    private static final TextMateSelectorToken LPAREN = new SignToken('(');
    @NotNull
    private static final TextMateSelectorToken RPAREN = new SignToken(')');
    @NotNull
    private static final TextMateSelectorToken PIPE = new SignToken('|');
    @NotNull
    private static final TextMateSelectorToken MINUS = new SignToken('-');
    @NotNull
    private static final TextMateSelectorToken HAT = new SignToken('^');

    private TextMateSelectorToken() {
    }

    public /* synthetic */ TextMateSelectorToken(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TextMateSelectorToken getCOMMA() {
            return COMMA;
        }

        @NotNull
        public final TextMateSelectorToken getLPAREN() {
            return LPAREN;
        }

        @NotNull
        public final TextMateSelectorToken getRPAREN() {
            return RPAREN;
        }

        @NotNull
        public final TextMateSelectorToken getPIPE() {
            return PIPE;
        }

        @NotNull
        public final TextMateSelectorToken getMINUS() {
            return MINUS;
        }

        @NotNull
        public final TextMateSelectorToken getHAT() {
            return HAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class PriorityToken
    extends TextMateSelectorToken {
        @NotNull
        private final TextMateWeigh.Priority priority;

        public PriorityToken(@NotNull TextMateWeigh.Priority priority) {
            Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
            super(null);
            this.priority = priority;
        }

        @NotNull
        public final TextMateWeigh.Priority getPriority() {
            return this.priority;
        }

        @NotNull
        public String toString() {
            return "PriorityToken(priority=" + this.priority + ")";
        }

        public int hashCode() {
            return this.priority.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PriorityToken)) {
                return false;
            }
            PriorityToken priorityToken = (PriorityToken)other;
            return this.priority == priorityToken.priority;
        }
    }

    public static final class SelectorToken
    extends TextMateSelectorToken {
        @NotNull
        private final String text;

        public SelectorToken(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super(null);
            this.text = text2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public String toString() {
            return "SelectorToken(text=" + this.text + ")";
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SelectorToken)) {
                return false;
            }
            SelectorToken selectorToken = (SelectorToken)other;
            return Intrinsics.areEqual((Object)this.text, (Object)selectorToken.text);
        }
    }

    public static final class SignToken
    extends TextMateSelectorToken {
        private final char sign;

        public SignToken(char sign) {
            super(null);
            this.sign = sign;
        }

        @NotNull
        public String toString() {
            return "SignToken(sign=" + this.sign + ")";
        }

        public int hashCode() {
            return Character.hashCode(this.sign);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SignToken)) {
                return false;
            }
            SignToken signToken = (SignToken)other;
            return this.sign == signToken.sign;
        }
    }
}

