/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorLexer;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.logging.TextMateLogger;

public final class TextMateSelectorParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence myHighlightingSelector;
    @NotNull
    private final List<TextMateSelectorToken> myTokens;
    private int myIndex;
    @NotNull
    private static final TextMateLogger LOG = MultiplatformKt.getLogger(Reflection.getOrCreateKotlinClass(TextMateSelectorParser.class));

    public TextMateSelectorParser(@NotNull CharSequence myHighlightingSelector) {
        Intrinsics.checkNotNullParameter((Object)myHighlightingSelector, (String)"myHighlightingSelector");
        this.myHighlightingSelector = myHighlightingSelector;
        this.myTokens = TextMateSelectorLexer.INSTANCE.tokenize(this.myHighlightingSelector);
    }

    @Nullable
    public final Node parse() {
        Node result2 = this.parseSelectorList();
        if (!this.eof()) {
            LOG.error((Function0<String>)((Function0)() -> TextMateSelectorParser.parse$lambda$0(this)));
        }
        return result2;
    }

    private final Node parseSelectorList() {
        List list2;
        Node node2 = this.parseConjunction();
        if (node2 == null || !Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getCOMMA())) {
            return node2;
        }
        List $this$parseSelectorList_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$parseSelectorList_u24lambda_u240.add(node2);
        while (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getCOMMA())) {
            this.advance();
            Node child2 = this.parseConjunction();
            if (child2 == null) break;
            $this$parseSelectorList_u24lambda_u240.add(child2);
        }
        List list3 = CollectionsKt.build((List)list2);
        return new SelectorList(list3);
    }

    private final Node parseConjunction() {
        List list2;
        Node node2 = this.parseScopeSelector();
        if (node2 == null || !Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getPIPE())) {
            return node2;
        }
        List $this$parseConjunction_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$parseConjunction_u24lambda_u240.add(node2);
        while (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getPIPE())) {
            this.advance();
            Node child2 = this.parseScopeSelector();
            if (child2 == null) break;
            $this$parseConjunction_u24lambda_u240.add(child2);
        }
        List list3 = CollectionsKt.build((List)list2);
        return new Conjunction(list3);
    }

    private final Node parseScopeSelector() {
        return this.parseScopeNode(false);
    }

    private final Node parseScopeExclusion() {
        return this.parseScopeNode(true);
    }

    private final Node parseScopeNode(boolean isExclusion) {
        TextMateWeigh.Priority priority;
        TextMateSelectorToken token2 = this.getCurrentToken();
        if (token2 instanceof TextMateSelectorToken.PriorityToken) {
            this.advance();
            priority = ((TextMateSelectorToken.PriorityToken)token2).getPriority();
        } else {
            priority = TextMateWeigh.Priority.NORMAL;
        }
        TextMateWeigh.Priority priority2 = priority;
        boolean startMatch = Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getHAT());
        if (startMatch) {
            this.advance();
        }
        List children = new ArrayList();
        List exclusions = new ArrayList();
        Node next2 = this.parseSelector();
        while (next2 != null) {
            children.add(next2);
            next2 = this.parseSelector();
        }
        while ((!isExclusion || children.isEmpty()) && Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getMINUS())) {
            this.advance();
            Node exclusion = this.parseScopeExclusion();
            if (exclusion == null) continue;
            exclusions.add(exclusion);
        }
        return !((Collection)children).isEmpty() || !((Collection)exclusions).isEmpty() ? (Node)new ScopeSelector(children, exclusions, startMatch, priority2) : null;
    }

    private final Node parseSelector() {
        Node node2;
        TextMateSelectorToken token2 = this.getCurrentToken();
        if (Intrinsics.areEqual((Object)token2, (Object)TextMateSelectorToken.Companion.getLPAREN())) {
            this.advance();
            Node result2 = this.parseSelectorList();
            if (Intrinsics.areEqual((Object)this.getCurrentToken(), (Object)TextMateSelectorToken.Companion.getRPAREN())) {
                this.advance();
            }
            return result2;
        }
        if (token2 instanceof TextMateSelectorToken.SelectorToken) {
            this.advance();
            node2 = new Selector(((TextMateSelectorToken.SelectorToken)token2).getText());
        } else {
            node2 = null;
        }
        return node2;
    }

    private final TextMateSelectorToken getCurrentToken() {
        return this.myIndex < this.myTokens.size() ? this.myTokens.get(this.myIndex) : null;
    }

    private final void advance() {
        int n = this.myIndex;
        this.myIndex = n + 1;
    }

    private final boolean eof() {
        return this.myIndex >= this.myTokens.size();
    }

    private static final String parse$lambda$0(TextMateSelectorParser this$0) {
        return "Cannot parse highlighting selector: " + this$0.myHighlightingSelector;
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nTextMateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Conjunction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1563#2:229\n1634#2,3:230\n295#2,2:233\n*S KotlinDebug\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Conjunction\n*L\n224#1:229\n224#1:230,3\n224#1:233,2\n*E\n"})
    private static final class Conjunction
    implements Node {
        @NotNull
        private final List<Node> children;

        public Conjunction(@NotNull List<? extends Node> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.children = children;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope2) {
            TextMateWeigh textMateWeigh;
            Object v0;
            block3: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
                Iterable $this$map$iv = this.children;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Node node2 = (Node)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.weigh(scope2));
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TextMateWeigh it = (TextMateWeigh)element$iv;
                    boolean bl = false;
                    if (!(it.getWeigh() > 0)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((textMateWeigh = (TextMateWeigh)v0) == null) {
                textMateWeigh = TextMateWeigh.Companion.getZERO();
            }
            return textMateWeigh;
        }
    }

    public static interface Node {
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope var1);
    }

    private static final class ScopeSelector
    implements Node {
        @NotNull
        private final List<Node> children;
        @NotNull
        private final List<Node> exclusions;
        private final boolean startMatch;
        @NotNull
        private final TextMateWeigh.Priority priority;

        public ScopeSelector(@NotNull List<? extends Node> children, @NotNull List<? extends Node> exclusions, boolean startMatch, @NotNull TextMateWeigh.Priority priority) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
            Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
            this.children = children;
            this.exclusions = exclusions;
            this.startMatch = startMatch;
            this.priority = priority;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope2) {
            void var3_6;
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            for (Node node2 : this.exclusions) {
                if (node2.weigh(scope2).getWeigh() <= 0) continue;
                return TextMateWeigh.Companion.getZERO();
            }
            if (scope2.getLevel() > 100) {
                return TextMateWeigh.Companion.getZERO();
            }
            ArrayDeque highlightingSelectors = new ArrayDeque();
            for (Node child2 : this.children) {
                highlightingSelectors.addLast((Object)child2);
            }
            if (highlightingSelectors.isEmpty()) {
                highlightingSelectors.addLast((Object)new Selector(""));
            }
            TextMateScope textMateScope = scope2;
            Node currentHighlightingSelector = (Node)highlightingSelectors.last();
            int nestingWeigh = 100;
            int result2 = 0;
            while (!highlightingSelectors.isEmpty() && var3_6 != null) {
                TextMateWeigh weigh;
                TextMateWeigh textMateWeigh = weigh = currentHighlightingSelector instanceof Selector ? ((Selector)currentHighlightingSelector).weigh((TextMateScope)var3_6) : currentHighlightingSelector.weigh(scope2);
                if (weigh.getWeigh() > 0) {
                    result2 += weigh.getWeigh() * nestingWeigh;
                    highlightingSelectors.removeLast();
                    if (!highlightingSelectors.isEmpty()) {
                        currentHighlightingSelector = (Node)highlightingSelectors.last();
                    }
                }
                --nestingWeigh;
                TextMateScope textMateScope2 = var3_6.getParent();
            }
            if (!highlightingSelectors.isEmpty()) {
                return TextMateWeigh.Companion.getZERO();
            }
            return new TextMateWeigh(!this.startMatch || var3_6 == null || var3_6.isEmpty() ? result2 : 0, this.priority);
        }
    }

    @SourceDebugExtension(value={"SMAP\nTextMateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Selector\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,228:1\n1104#2,3:229\n*S KotlinDebug\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$Selector\n*L\n151#1:229,3\n*E\n"})
    private static final class Selector
    implements Node {
        @NotNull
        private final String selector;

        public Selector(@NotNull String selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            this.selector = selector;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope2) {
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            CharSequence scopeName = scope2.getScopeName();
            if (scopeName != null && (((CharSequence)this.selector).length() == 0 || StringsKt.startsWith$default((CharSequence)scopeName, (CharSequence)(this.selector + "."), (boolean)false, (int)2, null) || StringsKt.contentEquals((CharSequence)scopeName, (CharSequence)this.selector))) {
                void $this$count$iv;
                CharSequence charSequence = this.selector;
                int n = 1000 - scope2.getDotsCount();
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int j = 0; j < $this$count$iv.length(); ++j) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(j);
                    boolean bl = false;
                    if (!(it == '.')) continue;
                    ++count$iv;
                }
                int n2 = count$iv;
                TextMateWeigh.Priority priority = TextMateWeigh.Priority.NORMAL;
                int n3 = n + n2;
                return new TextMateWeigh(n3, priority);
            }
            return TextMateWeigh.Companion.getZERO();
        }
    }

    @SourceDebugExtension(value={"SMAP\nTextMateSelectorParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSelectorParser.kt\norg/jetbrains/plugins/textmate/language/syntax/selector/TextMateSelectorParser$SelectorList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1#2:229\n*E\n"})
    private static final class SelectorList
    implements Node {
        @NotNull
        private final List<Node> children;

        public SelectorList(@NotNull List<? extends Node> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.children = children;
        }

        @Override
        @NotNull
        public TextMateWeigh weigh(@NotNull TextMateScope scope2) {
            TextMateWeigh textMateWeigh;
            Comparable comparable;
            Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
            Iterator iterator2 = ((Iterable)this.children).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                Node it = (Node)iterator2.next();
                boolean bl = false;
                Comparable comparable2 = it.weigh(scope2);
                while (iterator2.hasNext()) {
                    Node it2 = (Node)iterator2.next();
                    $i$a$-maxOfOrNull-TextMateSelectorParser$SelectorList$weigh$1 = false;
                    Comparable comparable3 = it2.weigh(scope2);
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            if ((textMateWeigh = (TextMateWeigh)comparable) == null) {
                textMateWeigh = TextMateWeigh.Companion.getZERO();
            }
            return textMateWeigh;
        }
    }
}

