/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.language.TextMateInterner;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.RawLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxIncludeRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNodeImpl;
import org.jetbrains.plugins.textmate.language.syntax.TextMateRawCapture;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

@SourceDebugExtension(value={"SMAP\nTextMateSyntaxTableBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n216#2,2:341\n1869#3,2:343\n1563#3:345\n1634#3,3:346\n1869#3,2:349\n1869#3,2:351\n1869#3,2:353\n1869#3,2:355\n*S KotlinDebug\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n*L\n44#1:341,2\n50#1:343,2\n63#1:345\n63#1:346,3\n98#1:349,2\n103#1:351,2\n125#1:353,2\n142#1:355,2\n*E\n"})
public final class TextMateSyntaxTableBuilder {
    @NotNull
    private final TextMateInterner interner;
    @NotNull
    private final AtomicInteger currentRuleId;
    @NotNull
    private final AtomicReference<PersistentMap<CharSequence, RawLanguageDescriptor>> syntaxNodes;

    public TextMateSyntaxTableBuilder(@NotNull TextMateInterner interner) {
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        this.interner = interner;
        this.currentRuleId = new AtomicInteger(0);
        this.syntaxNodes = new AtomicReference(ExtensionsKt.persistentMapOf());
    }

    @Nullable
    public final CharSequence addSyntax(@NotNull Plist plist) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        RawLanguageDescriptor rawLanguageDescriptor = this.loadLanguageDescriptor(plist);
        if (rawLanguageDescriptor != null) {
            RawLanguageDescriptor languageDescriptor = rawLanguageDescriptor;
            boolean bl = false;
            MultiplatformKt.update(this.syntaxNodes, arg_0 -> TextMateSyntaxTableBuilder.addSyntax$lambda$0$0(languageDescriptor, arg_0));
            charSequence = languageDescriptor.getScopeName();
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    @NotNull
    public final TextMateSyntaxTableCore build() {
        Map ruleIdToReferenceRuleId = new LinkedHashMap();
        Map compiledRules = new LinkedHashMap();
        Map languageDescriptors = new LinkedHashMap();
        TextMateSyntaxTableCore syntaxTable = new TextMateSyntaxTableCore(languageDescriptors);
        PersistentMap<CharSequence, RawLanguageDescriptor> syntaxNodes = this.syntaxNodes.get();
        Map $this$forEach$iv = syntaxNodes;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            TextMateLanguageDescriptor compiledNode;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            CharSequence scopeName = (CharSequence)entry.getKey();
            RawLanguageDescriptor rawLanguageDescriptor = (RawLanguageDescriptor)entry.getValue();
            if (rawLanguageDescriptor.compile((Map<CharSequence, RawLanguageDescriptor>)syntaxNodes, compiledRules, ruleIdToReferenceRuleId, syntaxTable) == null) continue;
            boolean bl2 = false;
            languageDescriptors.put(scopeName, compiledNode);
        }
        SyntaxNodeDescriptor[] rulesRepository = new SyntaxNodeDescriptor[ruleIdToReferenceRuleId.size()];
        Iterable $this$forEach$iv2 = ruleIdToReferenceRuleId.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            rulesRepository[((Number)it.getValue()).intValue()] = compiledRules.get(it.getKey());
        }
        syntaxTable.setRulesRepository$intellij_textmate_core(rulesRepository);
        return syntaxTable;
    }

    /*
     * WARNING - void declaration
     */
    private final RawLanguageDescriptor loadLanguageDescriptor(Plist plist) {
        String scopeNameValue;
        PListValue scopeNamePlistValue;
        PListValue pListValue = scopeNamePlistValue = plist.getPlistValue(Constants.StringKey.SCOPE_NAME.getValue());
        String string = scopeNameValue = pListValue != null ? pListValue.getString() : null;
        if (scopeNameValue != null) {
            List list2;
            SyntaxRawNodeImpl rootSyntaxRawNode = this.loadRealNode(plist, null);
            Object object = plist.getPlistValue("injections");
            if (object != null && (object = ((PListValue)object).getPlist()) != null && (object = ((Plist)object).entries()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    PListValue value2 = (PListValue)entry.getValue();
                    collection.add(TuplesKt.to((Object)key, (Object)this.loadRealNode(value2.getPlist(), rootSyntaxRawNode)));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List rawInjections = list2;
            return new RawLanguageDescriptor(this.interner.intern(scopeNameValue), rootSyntaxRawNode, rawInjections);
        }
        return null;
    }

    private final SyntaxRawNodeImpl loadRealNode(Plist plist, SyntaxRawNode parentBuilder) {
        int ruleId = AtomicsKt.fetchAndIncrement((AtomicInteger)this.currentRuleId);
        SyntaxRawNodeImpl result2 = new SyntaxRawNodeImpl(ruleId, parentBuilder);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            Iterable $this$forEach$iv;
            PListValue pListValue = entry.getValue();
            String key = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.Companion.fromName(key);
            if (stringKey != null) {
                if (pListValue.getString() != null) {
                    String stringValue;
                    boolean bl = false;
                    result2.setStringAttribute(stringKey, this.interner.intern(stringValue));
                }
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.Companion.fromName(key);
            if (captureKey != null) {
                if (this.loadCaptures(pListValue.getPlist(), result2) != null) {
                    TextMateRawCapture[] captures;
                    boolean bl = false;
                    result2.setCaptures(captureKey, captures);
                }
                continue;
            }
            if (StringsKt.equals((String)"repository", (String)key, (boolean)true)) {
                $this$forEach$iv = pListValue.getPlist().entries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry2 = (Map.Entry)element$iv;
                    boolean bl = false;
                    String key2 = (String)entry2.getKey();
                    PListValue value2 = (PListValue)entry2.getValue();
                    result2.appendRepository(key2, this.loadNestedSyntax(value2.getPlist(), result2));
                }
                continue;
            }
            if (!StringsKt.equals((String)"patterns", (String)key, (boolean)true)) continue;
            $this$forEach$iv = pListValue.getArray();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PListValue value3 = (PListValue)element$iv;
                boolean bl = false;
                result2.addChild(this.loadNestedSyntax(value3.getPlist(), result2));
            }
        }
        return result2;
    }

    private final SyntaxRawNode loadNestedSyntax(Plist plist, SyntaxRawNodeImpl parentBuilder) {
        PListValue pListValue = plist.getPlistValue("include");
        String include = pListValue != null ? pListValue.getString() : null;
        return include != null ? (SyntaxRawNode)new SyntaxIncludeRawNode(AtomicsKt.fetchAndIncrement((AtomicInteger)this.currentRuleId), parentBuilder, include) : (SyntaxRawNode)this.loadRealNode(plist, parentBuilder);
    }

    private final TextMateRawCapture[] loadCaptures(Plist captures, SyntaxRawNode parent) {
        Map map2 = new LinkedHashMap();
        int maxGroupIndex = 0;
        maxGroupIndex = -1;
        Iterable $this$forEach$iv = captures.entries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            PListValue value2 = (PListValue)entry.getValue();
            Integer n = StringsKt.toIntOrNull((String)key);
            if (n == null) continue;
            int index = ((Number)n).intValue();
            boolean bl2 = false;
            Plist captureDict = value2.getPlist();
            PListValue captureName = captureDict.getPlistValue("name");
            if (captureName != null) {
                Integer n2 = index;
                String string = captureName.getString();
                if (string == null) {
                    string = "";
                }
                map2.put(n2, new TextMateRawCapture.Name(this.interner.intern(string)));
            } else {
                map2.put(index, new TextMateRawCapture.Rule(this.loadRealNode(captureDict, parent)));
            }
            maxGroupIndex = Math.max(maxGroupIndex, index);
        }
        if (maxGroupIndex < 0 || map2.isEmpty()) {
            return null;
        }
        TextMateRawCapture[] result2 = new TextMateRawCapture[maxGroupIndex + 1];
        Iterable $this$forEach$iv2 = map2.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry e = (Map.Entry)element$iv;
            boolean bl = false;
            result2[((Number)e.getKey()).intValue()] = e.getValue();
        }
        return result2;
    }

    private static final PersistentMap addSyntax$lambda$0$0(RawLanguageDescriptor $languageDescriptor, PersistentMap it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.put($languageDescriptor.getScopeName(), $languageDescriptor);
    }
}

