/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import java.util.concurrent.atomic.AtomicReference;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.atomics.TextMateAtomicsKt;
import org.jetbrains.plugins.textmate.concurrent.TextMateLock;
import org.jetbrains.plugins.textmate.concurrent.TextMateThreadLocal;
import org.jetbrains.plugins.textmate.concurrent.TextMateThreadLocalJvmKt;
import org.jetbrains.plugins.textmate.logging.Slf4jTextMateLogger;
import org.jetbrains.plugins.textmate.logging.TextMateLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiplatformKt {
    public static final <T> void update(@NotNull AtomicReference<T> $this$update, @NotNull Function1<? super T, ? extends T> f) {
        Intrinsics.checkNotNullParameter($this$update, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        TextMateAtomicsKt.updateAndGet($this$update, f);
    }

    @NotNull
    public static final TextMateLogger getLogger(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Logger logger = LoggerFactory.getLogger((Class)JvmClassMappingKt.getJavaClass(clazz));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        return new Slf4jTextMateLogger(logger);
    }

    @NotNull
    public static final <T> TextMateThreadLocal<T> createTextMateThreadLocal() {
        return TextMateThreadLocalJvmKt.createTextMateThreadLocalJvm();
    }

    @NotNull
    public static final TextMateLock createTextMateLock() {
        return TextMateThreadLocalJvmKt.createTextMateLockJvm();
    }
}

