/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.TeamCityCheckAttemptStatus;

public final class TeamCityCheckAttempt {
    @NotNull
    private final UUID id;
    private final int number;
    @NotNull
    private final String buildId;
    @NotNull
    private final String buildUrl;
    @NotNull
    private final Instant startedAt;
    @Nullable
    private final Instant finishedAt;
    @NotNull
    private final TeamCityCheckAttemptStatus status;
    @Nullable
    private final Integer failedTestsNumber;
    @Nullable
    private final Integer failedBuildsNumber;
    @Nullable
    private final Integer failedToStartBuildsNumber;

    public TeamCityCheckAttempt(@NotNull UUID id, int number, @NotNull String buildId, @NotNull String buildUrl, @NotNull Instant startedAt, @Nullable Instant finishedAt, @NotNull TeamCityCheckAttemptStatus status2, @Nullable Integer failedTestsNumber, @Nullable Integer failedBuildsNumber, @Nullable Integer failedToStartBuildsNumber) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter((Object)buildUrl, (String)"buildUrl");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
        this.id = id;
        this.number = number;
        this.buildId = buildId;
        this.buildUrl = buildUrl;
        this.startedAt = startedAt;
        this.finishedAt = finishedAt;
        this.status = status2;
        this.failedTestsNumber = failedTestsNumber;
        this.failedBuildsNumber = failedBuildsNumber;
        this.failedToStartBuildsNumber = failedToStartBuildsNumber;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public String toString() {
        return "TeamCityCheckAttempt(id=" + this.id + ", number=" + this.number + ", buildId=" + this.buildId + ", buildUrl=" + this.buildUrl + ", startedAt=" + this.startedAt + ", finishedAt=" + this.finishedAt + ", status=" + this.status + ", failedTestsNumber=" + this.failedTestsNumber + ", failedBuildsNumber=" + this.failedBuildsNumber + ", failedToStartBuildsNumber=" + this.failedToStartBuildsNumber + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.number);
        result2 = result2 * 31 + this.buildId.hashCode();
        result2 = result2 * 31 + this.buildUrl.hashCode();
        result2 = result2 * 31 + this.startedAt.hashCode();
        result2 = result2 * 31 + (this.finishedAt == null ? 0 : this.finishedAt.hashCode());
        result2 = result2 * 31 + this.status.hashCode();
        result2 = result2 * 31 + (this.failedTestsNumber == null ? 0 : ((Object)this.failedTestsNumber).hashCode());
        result2 = result2 * 31 + (this.failedBuildsNumber == null ? 0 : ((Object)this.failedBuildsNumber).hashCode());
        result2 = result2 * 31 + (this.failedToStartBuildsNumber == null ? 0 : ((Object)this.failedToStartBuildsNumber).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TeamCityCheckAttempt)) {
            return false;
        }
        TeamCityCheckAttempt teamCityCheckAttempt = (TeamCityCheckAttempt)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)teamCityCheckAttempt.id)) {
            return false;
        }
        if (this.number != teamCityCheckAttempt.number) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildId, (Object)teamCityCheckAttempt.buildId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildUrl, (Object)teamCityCheckAttempt.buildUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startedAt, (Object)teamCityCheckAttempt.startedAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.finishedAt, (Object)teamCityCheckAttempt.finishedAt)) {
            return false;
        }
        if (this.status != teamCityCheckAttempt.status) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failedTestsNumber, (Object)teamCityCheckAttempt.failedTestsNumber)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failedBuildsNumber, (Object)teamCityCheckAttempt.failedBuildsNumber)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.failedToStartBuildsNumber, (Object)teamCityCheckAttempt.failedToStartBuildsNumber);
    }
}

