/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.patronus.client.model.Principal;
import org.jetbrains.patronus.client.model.Robot;

public final class RobotsList {
    @NotNull
    private final Principal me;
    @NotNull
    private final List<Robot> robots;
    @NotNull
    private final Instant start;
    @NotNull
    private final Instant end;

    public RobotsList(@NotNull Principal me, @NotNull List<Robot> robots, @NotNull Instant start2, @NotNull Instant end) {
        Intrinsics.checkNotNullParameter((Object)me, (String)"me");
        Intrinsics.checkNotNullParameter(robots, (String)"robots");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        this.me = me;
        this.robots = robots;
        this.start = start2;
        this.end = end;
    }

    @NotNull
    public final List<Robot> getRobots() {
        return this.robots;
    }

    @NotNull
    public String toString() {
        return "RobotsList(me=" + this.me + ", robots=" + this.robots + ", start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result2 = this.me.hashCode();
        result2 = result2 * 31 + ((Object)this.robots).hashCode();
        result2 = result2 * 31 + this.start.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RobotsList)) {
            return false;
        }
        RobotsList robotsList = (RobotsList)other;
        if (!Intrinsics.areEqual((Object)this.me, (Object)robotsList.me)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.robots, robotsList.robots)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)robotsList.start)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)robotsList.end);
    }
}

