/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.model;

import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCommit {
    @NotNull
    private final String hash;
    @NotNull
    private final String url;
    @NotNull
    private final String subject;
    @NotNull
    private final String author;
    @NotNull
    private final String committer;
    @Nullable
    private final Instant authorDate;
    @Nullable
    private final Instant committerDate;

    public GitCommit(@NotNull String hash, @NotNull String url, @NotNull String subject, @NotNull String author, @NotNull String committer, @Nullable Instant authorDate, @Nullable Instant committerDate) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.hash = hash;
        this.url = url;
        this.subject = subject;
        this.author = author;
        this.committer = committer;
        this.authorDate = authorDate;
        this.committerDate = committerDate;
    }

    @NotNull
    public String toString() {
        return "GitCommit(hash=" + this.hash + ", url=" + this.url + ", subject=" + this.subject + ", author=" + this.author + ", committer=" + this.committer + ", authorDate=" + this.authorDate + ", committerDate=" + this.committerDate + ")";
    }

    public int hashCode() {
        int result2 = this.hash.hashCode();
        result2 = result2 * 31 + this.url.hashCode();
        result2 = result2 * 31 + this.subject.hashCode();
        result2 = result2 * 31 + this.author.hashCode();
        result2 = result2 * 31 + this.committer.hashCode();
        result2 = result2 * 31 + (this.authorDate == null ? 0 : this.authorDate.hashCode());
        result2 = result2 * 31 + (this.committerDate == null ? 0 : this.committerDate.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitCommit)) {
            return false;
        }
        GitCommit gitCommit = (GitCommit)other;
        if (!Intrinsics.areEqual((Object)this.hash, (Object)gitCommit.hash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)gitCommit.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subject, (Object)gitCommit.subject)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.author, (Object)gitCommit.author)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.committer, (Object)gitCommit.committer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.authorDate, (Object)gitCommit.authorDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.committerDate, (Object)gitCommit.committerDate);
    }
}

