/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.patronus.client.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.patronus.api.dto.git.GitCommitDto;
import org.jetbrains.patronus.api.dto.robot.ExternalLinkTypeDto;
import org.jetbrains.patronus.api.dto.robot.PrincipalDto;
import org.jetbrains.patronus.api.dto.robot.PushModeDto;
import org.jetbrains.patronus.api.dto.robot.RobotChangesListDto;
import org.jetbrains.patronus.api.dto.robot.RobotChangesListTypeDto;
import org.jetbrains.patronus.api.dto.robot.RobotChangesSpaceLinkDto;
import org.jetbrains.patronus.api.dto.robot.RobotDto;
import org.jetbrains.patronus.api.dto.robot.RobotListDto;
import org.jetbrains.patronus.api.dto.robot.RobotStatusDto;
import org.jetbrains.patronus.api.dto.robot.RobotTeamCityChecksDto;
import org.jetbrains.patronus.api.dto.robot.RobotTypeDto;
import org.jetbrains.patronus.api.dto.robot.RobotsListDto;
import org.jetbrains.patronus.api.dto.robot.SourceBranchDeletePolicyDto;
import org.jetbrains.patronus.api.dto.robot.TeamCityCheckDto;
import org.jetbrains.patronus.api.dto.robot.TestReferenceUpdateModeDto;
import org.jetbrains.patronus.client.mappers.GitKt;
import org.jetbrains.patronus.client.mappers.TeamCityKt;
import org.jetbrains.patronus.client.model.GitCommit;
import org.jetbrains.patronus.client.model.Principal;
import org.jetbrains.patronus.client.model.PushMode;
import org.jetbrains.patronus.client.model.Robot;
import org.jetbrains.patronus.client.model.RobotChanges;
import org.jetbrains.patronus.client.model.RobotChangesSpaceLink;
import org.jetbrains.patronus.client.model.RobotChangesType;
import org.jetbrains.patronus.client.model.RobotChecks;
import org.jetbrains.patronus.client.model.RobotStatus;
import org.jetbrains.patronus.client.model.RobotType;
import org.jetbrains.patronus.client.model.RobotsList;
import org.jetbrains.patronus.client.model.SourceBranchDeletePolicy;
import org.jetbrains.patronus.client.model.TestReferenceUpdateMode;

@SourceDebugExtension(value={"SMAP\nrobot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 robot.kt\norg/jetbrains/patronus/client/mappers/RobotKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,205:1\n1557#2:206\n1628#2,3:207\n1557#2:210\n1628#2,3:211\n1557#2:214\n1628#2,3:215\n1557#2:218\n1628#2,3:219\n1557#2:222\n1628#2,3:223\n1246#2,4:228\n1557#2:232\n1628#2,3:233\n1557#2:236\n1628#2,3:237\n462#3:226\n412#3:227\n*S KotlinDebug\n*F\n+ 1 robot.kt\norg/jetbrains/patronus/client/mappers/RobotKt\n*L\n59#1:206\n59#1:207,3\n100#1:210\n100#1:211,3\n101#1:214\n101#1:215,3\n118#1:218\n118#1:219,3\n174#1:222\n174#1:223,3\n180#1:228,4\n185#1:232\n185#1:233,3\n199#1:236\n199#1:237,3\n180#1:226\n180#1:227\n*E\n"})
public final class RobotKt {
    @NotNull
    public static final Robot toModel(@NotNull RobotDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        String string = $this$toModel.getName();
        UUID uUID = $this$toModel.getId();
        String string2 = $this$toModel.getRepository();
        String string3 = $this$toModel.getSourceBranch();
        String string4 = $this$toModel.getTargetBranch();
        Instant instant = $this$toModel.getStartDateTime();
        Instant instant2 = $this$toModel.getFinishDateTime();
        RobotStatus robotStatus = RobotKt.toModel($this$toModel.getStatus());
        String string5 = $this$toModel.getCancellationReason();
        Principal principal2 = RobotKt.toModel($this$toModel.getOwner());
        String string6 = $this$toModel.getSpaceReviewKey();
        String string7 = $this$toModel.getSpaceReviewUrl();
        PushMode pushMode = RobotKt.toModel($this$toModel.getPushMode());
        RobotType robotType = RobotKt.toModel($this$toModel.getType());
        boolean bl = $this$toModel.isEmergency();
        return new Robot(string, uUID, pushMode, robotType, string2, string3, string4, instant, instant2, robotStatus, string5, principal2, string6, string7, bl);
    }

    @NotNull
    public static final Robot toModel(@NotNull RobotListDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        String string = $this$toModel.getName();
        UUID uUID = $this$toModel.getId();
        String string2 = $this$toModel.getRepository();
        String string3 = $this$toModel.getSourceBranch();
        String string4 = $this$toModel.getTargetBranch();
        Instant instant = $this$toModel.getStartDateTime();
        Instant instant2 = $this$toModel.getFinishDateTime();
        RobotStatus robotStatus = RobotKt.toModel($this$toModel.getStatus());
        String string5 = $this$toModel.getCancellationReason();
        Principal principal2 = RobotKt.toModel($this$toModel.getOwner());
        String string6 = $this$toModel.getSpaceReviewKey();
        String string7 = $this$toModel.getSpaceReviewUrl();
        PushMode pushMode = RobotKt.toModel($this$toModel.getPushMode());
        RobotType robotType = RobotKt.toModel($this$toModel.getType());
        boolean bl = $this$toModel.isEmergency();
        return new Robot(string, uUID, pushMode, robotType, string2, string3, string4, instant, instant2, robotStatus, string5, principal2, string6, string7, bl);
    }

    @NotNull
    public static final Principal toModel(@NotNull PrincipalDto $this$toModel) {
        Principal principal2;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        PrincipalDto principalDto = $this$toModel;
        if (principalDto instanceof PrincipalDto.UserDto) {
            principal2 = new Principal.User(((PrincipalDto.UserDto)$this$toModel).getId(), ((PrincipalDto.UserDto)$this$toModel).getName(), ((PrincipalDto.UserDto)$this$toModel).getEmail());
        } else if (principalDto instanceof PrincipalDto.SpaceApplicationDto) {
            principal2 = new Principal.Application(((PrincipalDto.SpaceApplicationDto)$this$toModel).getId(), ((PrincipalDto.SpaceApplicationDto)$this$toModel).getName());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return principal2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RobotsList toModel(@NotNull RobotsListDto $this$toModel) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Iterable iterable = $this$toModel.getRobots();
        Principal principal2 = RobotKt.toModel($this$toModel.getMe());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RobotListDto robotListDto = (RobotListDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RobotKt.toModel((RobotListDto)it));
        }
        Instant instant = $this$toModel.getEnd();
        Instant instant2 = $this$toModel.getStart();
        List list2 = (List)destination$iv$iv;
        Principal principal3 = principal2;
        return new RobotsList(principal3, list2, instant2, instant);
    }

    @NotNull
    public static final RobotStatus toModel(@NotNull RobotStatusDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toModel), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toModel.ordinal()]) {
            case 1 -> RobotStatus.RUNNING;
            case 2 -> RobotStatus.CANCELING;
            case 3 -> RobotStatus.CANCELED;
            case 4 -> RobotStatus.SUCCESS;
            case 5 -> RobotStatus.FAILURE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final PushMode toModel(@NotNull PushModeDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toModel), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toModel.ordinal()]) {
            case 1 -> PushMode.DRY_RUN;
            case 2 -> PushMode.REBASE;
            case 3 -> PushMode.REBASE_AUTOSQUASH;
            case 4 -> PushMode.SQUASH_ALL;
            case 5 -> PushMode.MERGE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final RobotType toModel(@NotNull RobotTypeDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toModel), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$3[$this$toModel.ordinal()]) {
            case 1 -> RobotType.WEB_UI;
            case 2 -> RobotType.SAFE_PUSH;
            case 3 -> RobotType.SPACE_REVIEW_CHERRY_PICK;
            case 4 -> RobotType.PATRONUS_CHERRY_PICK;
            case 5 -> RobotType.SPACE_SAFE_MERGE;
            case 6 -> RobotType.CUSTOM;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final RobotChanges toModel(@NotNull RobotChangesListDto $this$toModel) {
        Collection<RobotChangesSpaceLink> collection;
        RobotChangesSpaceLinkDto it;
        Collection<GitCommit> collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Iterable iterable = $this$toModel.getTopCommits();
        int n = $this$toModel.getCommitsNumber();
        RobotChangesType robotChangesType = RobotKt.toModel($this$toModel.getType());
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            GitCommitDto gitCommitDto = (GitCommitDto)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(GitKt.toModel((GitCommitDto)((Object)it)));
        }
        collection2 = (List)destination$iv$iv;
        $this$map$iv = $this$toModel.getSpaceLinks();
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RobotChangesSpaceLinkDto)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RobotKt.toModel(it));
        }
        Collection<RobotChangesSpaceLink> collection3 = collection = (List)destination$iv$iv;
        Collection<GitCommit> collection4 = collection2;
        int n2 = n;
        RobotChangesType robotChangesType2 = robotChangesType;
        return new RobotChanges(robotChangesType2, n2, (List<GitCommit>)collection4, (List<RobotChangesSpaceLink>)collection3);
    }

    @NotNull
    public static final RobotChangesType toModel(@NotNull RobotChangesListTypeDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toModel), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$4[$this$toModel.ordinal()]) {
            case 1 -> RobotChangesType.NOT_LOADED;
            case 2 -> RobotChangesType.PENDING;
            case 3 -> RobotChangesType.DELIVERED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final RobotChangesSpaceLink toModel(@NotNull RobotChangesSpaceLinkDto $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return new RobotChangesSpaceLink($this$toModel.getProjectName(), $this$toModel.getProjectKey(), $this$toModel.getChangesLink());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RobotChecks toModel(@NotNull RobotTeamCityChecksDto $this$toModel) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Iterable iterable = $this$toModel.getTeamCityChecks();
        UUID uUID = $this$toModel.getRobotId();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TeamCityCheckDto teamCityCheckDto = (TeamCityCheckDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TeamCityKt.toModel((TeamCityCheckDto)it));
        }
        List list2 = (List)destination$iv$iv;
        UUID uUID2 = uUID;
        return new RobotChecks(uUID2, list2);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;
        public static final /* synthetic */ int[] $EnumSwitchMapping$5;
        public static final /* synthetic */ int[] $EnumSwitchMapping$6;
        public static final /* synthetic */ int[] $EnumSwitchMapping$7;
        public static final /* synthetic */ int[] $EnumSwitchMapping$8;
        public static final /* synthetic */ int[] $EnumSwitchMapping$9;

        static {
            int[] nArray = new int[RobotStatusDto.values().length];
            try {
                nArray[RobotStatusDto.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotStatusDto.CANCELING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotStatusDto.CANCELED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotStatusDto.SUCCESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotStatusDto.FAILURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PushModeDto.values().length];
            try {
                nArray[PushModeDto.DRY_RUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushModeDto.REBASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushModeDto.REBASE_AUTOSQUASH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushModeDto.SQUASH_ALL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushModeDto.MERGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PushMode.values().length];
            try {
                nArray[PushMode.DRY_RUN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushMode.REBASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushMode.REBASE_AUTOSQUASH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushMode.SQUASH_ALL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PushMode.MERGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[RobotTypeDto.values().length];
            try {
                nArray[RobotTypeDto.WEB_UI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotTypeDto.SAFE_PUSH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotTypeDto.SPACE_REVIEW_CHERRY_PICK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotTypeDto.PATRONUS_CHERRY_PICK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotTypeDto.SPACE_SAFE_MERGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotTypeDto.CUSTOM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[RobotChangesListTypeDto.values().length];
            try {
                nArray[RobotChangesListTypeDto.NOT_LOADED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotChangesListTypeDto.PENDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RobotChangesListTypeDto.DELIVERED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$4 = nArray;
            nArray = new int[ExternalLinkTypeDto.values().length];
            try {
                nArray[ExternalLinkTypeDto.YOUTRACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalLinkTypeDto.SPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalLinkTypeDto.EA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalLinkTypeDto.HTTP_LINK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$5 = nArray;
            nArray = new int[TestReferenceUpdateModeDto.values().length];
            try {
                nArray[TestReferenceUpdateModeDto.INHERIT_PUSH_MODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestReferenceUpdateModeDto.NO_UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$6 = nArray;
            nArray = new int[TestReferenceUpdateMode.values().length];
            try {
                nArray[TestReferenceUpdateMode.INHERIT_PUSH_MODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestReferenceUpdateMode.NO_UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$7 = nArray;
            nArray = new int[SourceBranchDeletePolicy.values().length];
            try {
                nArray[SourceBranchDeletePolicy.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceBranchDeletePolicy.ON_SUCCESS_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceBranchDeletePolicy.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$8 = nArray;
            nArray = new int[SourceBranchDeletePolicyDto.values().length];
            try {
                nArray[SourceBranchDeletePolicyDto.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceBranchDeletePolicyDto.ON_SUCCESS_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceBranchDeletePolicyDto.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$9 = nArray;
        }
    }
}

