/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.nativecerts;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class NativeTrustedRootsInternalUtils {
    private static final String _OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
    public static final boolean isWindows = _OS_NAME.startsWith("windows");
    public static final boolean isMac = _OS_NAME.startsWith("mac");
    public static final boolean isLinux = _OS_NAME.startsWith("linux");

    public static String renderExceptionMessage(@NotNull String message2, @NotNull Throwable exception) {
        StringWriter throwableText = new StringWriter();
        exception.printStackTrace(new PrintWriter(throwableText));
        return message2 + ": " + exception.getMessage() + "\n" + String.valueOf(throwableText);
    }

    public static X509Certificate parseCertificate(byte[] bytes2) {
        try {
            return NativeTrustedRootsInternalUtils.parseCertificate(bytes2, CertificateFactory.getInstance("X.509"));
        }
        catch (Throwable e) {
            CertificateFactory bcProvider;
            Logger logger = Logger.getLogger(NativeTrustedRootsInternalUtils.class.getName());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(NativeTrustedRootsInternalUtils.renderExceptionMessage("Unable to parse certificate with a standard X509 parser, falling back to BouncyCastle", e));
            }
            try {
                bcProvider = CertificateFactory.getInstance("X.509", BouncyCastleLazyProvider.INSTANCE);
            }
            catch (CertificateException ex) {
                throw new RuntimeException(ex);
            }
            return NativeTrustedRootsInternalUtils.parseCertificate(bytes2, bcProvider);
        }
    }

    static X509Certificate parseCertificate(byte[] bytes2, CertificateFactory cf) {
        try {
            X509Certificate certificate2 = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes2));
            certificate2.getPublicKey();
            return certificate2;
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BouncyCastleLazyProvider {
        public static final BouncyCastleProvider INSTANCE = new BouncyCastleProvider();
    }
}

