/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.crystal.traversal;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.focus.FocusRequester;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.crystal.traversal.TraversalTargetState;

@SourceDebugExtension(value={"SMAP\nTraversalContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TraversalContext.kt\norg/jetbrains/crystal/traversal/TraversalContext\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 4 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1101#2:62\n1083#2,2:63\n85#3:65\n340#4:66\n516#4:67\n472#4:68\n563#4:69\n516#4:70\n44#4:71\n472#4:72\n490#4,6:73\n516#4:79\n472#4:81\n516#4:82\n472#4:83\n1#5:80\n*S KotlinDebug\n*F\n+ 1 TraversalContext.kt\norg/jetbrains/crystal/traversal/TraversalContext\n*L\n11#1:62\n11#1:63,2\n13#1:65\n36#1:66\n36#1:67\n36#1:68\n40#1:69\n40#1:70\n40#1:71\n40#1:72\n43#1:73,6\n46#1:79\n50#1:81\n54#1:82\n58#1:83\n*E\n"})
public final class TraversalContext {
    private final int pageSize;
    @NotNull
    private final MutableVector<TraversalTargetState> targets;
    @NotNull
    private final MutableState<Integer> _version;
    public static final int $stable = MutableVector.$stable;

    public TraversalContext(int pageSize) {
        this.pageSize = pageSize;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.targets = new MutableVector<TraversalTargetState>(new TraversalTargetState[capacity$iv$iv], 0);
        this._version = SnapshotStateKt.mutableStateOf$default(0, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int getVersion() {
        void $this$getValue$iv;
        State state2 = this._version;
        TraversalContext traversalContext = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    public final void invalidate() {
        this._version.setValue((((Number)this._version.getValue()).intValue() + 1) % 10);
    }

    public final void addTarget(@NotNull TraversalTargetState target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.targets.add(target);
    }

    public final void removeTarget(@NotNull TraversalTargetState target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.targets.remove(target);
    }

    public final void up() {
        this.up(1);
    }

    public final void down() {
        this.down(1);
    }

    public final void pageUp() {
        this.up(this.pageSize);
    }

    public final void pageDown() {
        this.down(this.pageSize);
    }

    public final void home() {
        block2: {
            Object object;
            Object v0;
            MutableVector<TraversalTargetState> this_$iv = this.targets;
            boolean $i$f$firstOrNull = false;
            MutableVector<TraversalTargetState> this_$iv$iv = this_$iv;
            boolean $i$f$isEmpty = false;
            if (this_$iv$iv.getSize() == 0) {
                v0 = null;
            } else {
                this_$iv$iv = this_$iv;
                int index$iv$iv = 0;
                boolean $i$f$get = false;
                v0 = this_$iv$iv.content[index$iv$iv];
            }
            if ((object = (TraversalTargetState)v0) == null || (object = ((TraversalTargetState)object).getFocusRequester()) == null) break block2;
            FocusRequester.requestFocus-3ESFkO8$default((FocusRequester)object, 0, 1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void end() {
        block2: {
            Object object;
            Object v0;
            MutableVector<TraversalTargetState> this_$iv = this.targets;
            boolean $i$f$lastOrNull = false;
            MutableVector<TraversalTargetState> this_$iv$iv = this_$iv;
            boolean $i$f$isEmpty = false;
            if (this_$iv$iv.getSize() == 0) {
                v0 = null;
            } else {
                void index$iv$iv;
                this_$iv$iv = this_$iv;
                MutableVector<TraversalTargetState> this_$iv$iv22 = this_$iv;
                boolean $i$f$getLastIndex = false;
                int this_$iv$iv22 = this_$iv$iv22.getSize() - 1;
                boolean $i$f$get = false;
                v0 = this_$iv$iv.content[index$iv$iv];
            }
            if ((object = (TraversalTargetState)v0) == null || (object = ((TraversalTargetState)object).getFocusRequester()) == null) break block2;
            FocusRequester.requestFocus-3ESFkO8$default((FocusRequester)object, 0, 1, null);
        }
    }

    private final int getFocusedIndex() {
        int n;
        block1: {
            MutableVector<TraversalTargetState> this_$iv = this.targets;
            boolean $i$f$indexOfFirst = false;
            T[] content$iv = this_$iv.content;
            int size$iv = this_$iv.getSize();
            for (int i$iv = 0; i$iv < size$iv; ++i$iv) {
                TraversalTargetState it = (TraversalTargetState)content$iv[i$iv];
                boolean bl = false;
                if (!it.isFocused()) continue;
                n = i$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private final void up(int count) {
        void this_$iv;
        MutableVector<TraversalTargetState> this_$iv2 = this.targets;
        boolean $i$f$isEmpty = false;
        if (this_$iv2.getSize() == 0) {
            return;
        }
        int it22 = this.getFocusedIndex();
        boolean bl = false;
        int focusedIndex = it22 == -1 ? this.targets.getSize() : it22;
        int nextFocusedIndex = Math.max(focusedIndex - count, 0);
        MutableVector<TraversalTargetState> it22 = this.targets;
        int index$iv = nextFocusedIndex;
        boolean $i$f$get = false;
        FocusRequester.requestFocus-3ESFkO8$default(((TraversalTargetState)this_$iv.content[index$iv]).getFocusRequester(), 0, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void down(int count) {
        void this_$iv;
        MutableVector<TraversalTargetState> this_$iv2 = this.targets;
        boolean $i$f$isEmpty = false;
        if (this_$iv2.getSize() == 0) {
            return;
        }
        int focusedIndex = this.getFocusedIndex();
        int nextFocusedIndex = Math.min(focusedIndex + count, this.targets.getSize() - 1);
        MutableVector<TraversalTargetState> mutableVector = this.targets;
        int index$iv = nextFocusedIndex;
        boolean $i$f$get = false;
        FocusRequester.requestFocus-3ESFkO8$default(((TraversalTargetState)this_$iv.content[index$iv]).getFocusRequester(), 0, 1, null);
    }
}

