/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.crystal.animations;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.AnimationFrameInfo;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Codec;
import org.jetbrains.skia.Image;

@SourceDebugExtension(value={"SMAP\nGifAnimation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GifAnimation.kt\norg/jetbrains/crystal/animations/GifAnimation\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,78:1\n11561#2:79\n11896#2,3:80\n85#3:83\n113#3,2:84\n*S KotlinDebug\n*F\n+ 1 GifAnimation.kt\norg/jetbrains/crystal/animations/GifAnimation\n*L\n45#1:79\n45#1:80,3\n50#1:83\n50#1:84,2\n*E\n"})
final class GifAnimation {
    @NotNull
    private final Codec codec;
    @NotNull
    private final Bitmap bitmap;
    @NotNull
    private final List<Long> durations;
    private final long totalDuration;
    private long startTime;
    private int lastFrame;
    private long lastDuration;
    @NotNull
    private final MutableState frame$delegate;

    /*
     * WARNING - void declaration
     */
    public GifAnimation(@NotNull Codec codec2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$bitmap_u24lambda_u240;
        AnimationFrameInfo[] animationFrameInfoArray;
        Intrinsics.checkNotNullParameter((Object)codec2, (String)"codec");
        this.codec = codec2;
        AnimationFrameInfo[] animationFrameInfoArray2 = animationFrameInfoArray = new Bitmap();
        GifAnimation gifAnimation = this;
        boolean $i$a$-apply-GifAnimation$bitmap$22 = false;
        $this$bitmap_u24lambda_u240.allocPixels(this.codec.getImageInfo());
        gifAnimation.bitmap = animationFrameInfoArray;
        animationFrameInfoArray = this.codec.getFramesInfo();
        gifAnimation = this;
        boolean $i$f$map = false;
        void $i$a$-apply-GifAnimation$bitmap$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_13 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((long)it.getDuration() * 1000000L);
        }
        gifAnimation.durations = (List)destination$iv$iv;
        this.totalDuration = CollectionsKt.sumOfLong((Iterable)this.durations);
        this.startTime = -1L;
        this.frame$delegate = SnapshotStateKt.mutableStateOf$default(0, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int getFrame() {
        void $this$getValue$iv;
        State state2 = this.frame$delegate;
        GifAnimation gifAnimation = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrame(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.frame$delegate;
        GifAnimation gifAnimation = this;
        Object var4_4 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue(value$iv);
    }

    public final void update(long nanoTime) {
        if (this.startTime == -1L) {
            this.startTime = nanoTime;
        }
        this.setFrame(this.frameOf((nanoTime - this.startTime) % this.totalDuration));
    }

    private final int frameOf(long time2) {
        long t2 = this.lastDuration;
        int n = this.durations.size();
        for (int frame = this.lastFrame; frame < n; ++frame) {
            if (t2 >= time2) {
                this.lastFrame = frame;
                this.lastDuration = t2;
                return frame;
            }
            t2 += ((Number)this.durations.get(frame)).longValue();
        }
        this.lastFrame = 0;
        this.lastDuration = 0L;
        return 0;
    }

    public final void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.codec.readPixels(this.bitmap, this.getFrame());
        canvas.drawImage(Image.Companion.makeFromBitmap(this.bitmap), 0.0f, 0.0f);
    }
}

