/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.crystal;

import androidx.compose.foundation.ScrollState;
import androidx.compose.ui.unit.Density;
import java.util.List;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.crystal.TabSwitchTabPosition;
import org.jetbrains.crystal.animations.AnimationsKt;

final class TabSwitchScrollableTabData {
    @NotNull
    private final ScrollState scrollState;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Integer selectedTab;
    @Nullable
    private Integer tabRowWidth;
    @Nullable
    private Job job;

    public TabSwitchScrollableTabData(@NotNull ScrollState scrollState, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.scrollState = scrollState;
        this.coroutineScope = coroutineScope;
    }

    public final void onLaidOut(@NotNull Density density, int edgeOffset, @NotNull List<TabSwitchTabPosition> tabPositions, int selectedTab, int tabRowWidth) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)density, (String)"density");
                Intrinsics.checkNotNullParameter(tabPositions, (String)"tabPositions");
                Integer n = this.selectedTab;
                int n2 = selectedTab;
                if (n == null || n != n2) break block2;
                Integer n3 = this.tabRowWidth;
                n2 = tabRowWidth;
                if (n3 != null && n3 == n2) break block3;
            }
            this.selectedTab = selectedTab;
            this.tabRowWidth = tabRowWidth;
            TabSwitchTabPosition tabSwitchTabPosition = (TabSwitchTabPosition)CollectionsKt.getOrNull(tabPositions, (int)selectedTab);
            if (tabSwitchTabPosition != null) {
                TabSwitchTabPosition it = tabSwitchTabPosition;
                boolean bl = false;
                int calculatedOffset = this.calculateTabOffset(it, density, edgeOffset, tabPositions);
                Job job2 = this.job;
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                }
                this.job = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, calculatedOffset, null){
                    int label;
                    final /* synthetic */ TabSwitchScrollableTabData this$0;
                    final /* synthetic */ int $calculatedOffset;
                    {
                        this.this$0 = $receiver;
                        this.$calculatedOffset = $calculatedOffset;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = TabSwitchScrollableTabData.access$getScrollState$p(this.this$0).animateScrollTo(this.$calculatedOffset, AnimationsKt.fastTween$default(0, null, 0, 7, null), (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    private final int calculateTabOffset(TabSwitchTabPosition $this$calculateTabOffset, Density density, int edgeOffset, List<TabSwitchTabPosition> tabPositions) {
        Density $this$calculateTabOffset_u24lambda_u240 = density;
        boolean bl = false;
        int totalTabRowWidth = $this$calculateTabOffset_u24lambda_u240.roundToPx-0680j_4(((TabSwitchTabPosition)CollectionsKt.last(tabPositions)).getRight-D9Ej5fM()) + edgeOffset;
        int visibleWidth = totalTabRowWidth - this.scrollState.getMaxValue();
        int tabOffset = $this$calculateTabOffset_u24lambda_u240.roundToPx-0680j_4($this$calculateTabOffset.getLeft-D9Ej5fM());
        int scrollerCenter = visibleWidth / 2;
        int tabWidth = $this$calculateTabOffset_u24lambda_u240.roundToPx-0680j_4($this$calculateTabOffset.getWidth-D9Ej5fM());
        int centeredTabOffset = tabOffset - (scrollerCenter - tabWidth / 2);
        int availableSpace = RangesKt.coerceAtLeast((int)(totalTabRowWidth - visibleWidth), (int)0);
        return RangesKt.coerceIn((int)centeredTabOffset, (int)0, (int)availableSpace);
    }

    public static final /* synthetic */ ScrollState access$getScrollState$p(TabSwitchScrollableTabData $this) {
        return $this.scrollState;
    }
}

