/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.crystal;

import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.runtime.Composer;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.text.TextStyle;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.crystal.TabSwitchItem;
import org.jetbrains.crystal.TabSwitchKt;

public final class TabSwitchItemImpl
implements TabSwitchItem {
    @NotNull
    private final Function3<TextStyle, Composer, Integer, Unit> tabContent;
    @NotNull
    private final Modifier modifier;
    @Nullable
    private final String badge;
    @Nullable
    private final Function2<Composer, Integer, Unit> tooltip;
    private final boolean scrollable;
    private final boolean enabled;
    @NotNull
    private final PaddingValues contentPadding;
    @NotNull
    private final Function2<Composer, Integer, Unit> content;

    public TabSwitchItemImpl(@NotNull Function3<? super TextStyle, ? super Composer, ? super Integer, Unit> tabContent2, @NotNull Modifier modifier2, @Nullable String badge, @Nullable Function2<? super Composer, ? super Integer, Unit> tooltip2, boolean scrollable, boolean enabled, @NotNull PaddingValues contentPadding2, @NotNull Function2<? super Composer, ? super Integer, Unit> content2) {
        Intrinsics.checkNotNullParameter(tabContent2, (String)"tabContent");
        Intrinsics.checkNotNullParameter((Object)modifier2, (String)"modifier");
        Intrinsics.checkNotNullParameter((Object)contentPadding2, (String)"contentPadding");
        Intrinsics.checkNotNullParameter(content2, (String)"content");
        this.tabContent = tabContent2;
        this.modifier = modifier2;
        this.badge = badge;
        this.tooltip = tooltip2;
        this.scrollable = scrollable;
        this.enabled = enabled;
        this.contentPadding = contentPadding2;
        this.content = content2;
    }

    public /* synthetic */ TabSwitchItemImpl(Function3 function3, Modifier modifier2, String string, Function2 function2, boolean bl, boolean bl2, PaddingValues paddingValues, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            modifier2 = Modifier.Companion;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            function2 = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        if ((n & 0x40) != 0) {
            paddingValues = TabSwitchKt.getDefaultTabSwitchContentPadding();
        }
        this((Function3<? super TextStyle, ? super Composer, ? super Integer, Unit>)function3, modifier2, string, (Function2<? super Composer, ? super Integer, Unit>)function2, bl, bl2, paddingValues, (Function2<? super Composer, ? super Integer, Unit>)function22);
    }

    @Override
    @NotNull
    public Function3<TextStyle, Composer, Integer, Unit> getTabContent() {
        return this.tabContent;
    }

    @Override
    @NotNull
    public Modifier getModifier() {
        return this.modifier;
    }

    @Override
    @Nullable
    public String getBadge() {
        return this.badge;
    }

    @Override
    @Nullable
    public Function2<Composer, Integer, Unit> getTooltip() {
        return this.tooltip;
    }

    @Override
    public boolean getScrollable() {
        return this.scrollable;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @NotNull
    public PaddingValues getContentPadding() {
        return this.contentPadding;
    }

    @Override
    @NotNull
    public Function2<Composer, Integer, Unit> getContent() {
        return this.content;
    }

    @NotNull
    public String toString() {
        return "TabSwitchItemImpl(tabContent=" + this.tabContent + ", modifier=" + this.modifier + ", badge=" + this.badge + ", tooltip=" + this.tooltip + ", scrollable=" + this.scrollable + ", enabled=" + this.enabled + ", contentPadding=" + this.contentPadding + ", content=" + this.content + ")";
    }

    public int hashCode() {
        int result2 = this.tabContent.hashCode();
        result2 = result2 * 31 + this.modifier.hashCode();
        result2 = result2 * 31 + (this.badge == null ? 0 : this.badge.hashCode());
        result2 = result2 * 31 + (this.tooltip == null ? 0 : this.tooltip.hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.scrollable);
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        result2 = result2 * 31 + this.contentPadding.hashCode();
        result2 = result2 * 31 + this.content.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TabSwitchItemImpl)) {
            return false;
        }
        TabSwitchItemImpl tabSwitchItemImpl = (TabSwitchItemImpl)other;
        if (!Intrinsics.areEqual(this.tabContent, tabSwitchItemImpl.tabContent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.modifier, (Object)tabSwitchItemImpl.modifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.badge, (Object)tabSwitchItemImpl.badge)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tooltip, tabSwitchItemImpl.tooltip)) {
            return false;
        }
        if (this.scrollable != tabSwitchItemImpl.scrollable) {
            return false;
        }
        if (this.enabled != tabSwitchItemImpl.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contentPadding, (Object)tabSwitchItemImpl.contentPadding)) {
            return false;
        }
        return Intrinsics.areEqual(this.content, tabSwitchItemImpl.content);
    }
}

