/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.LocalParsingResult;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.LinkParserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineLinkParser
implements SequentialParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator2.getType() != null) {
            LocalParsingResult inlineLink;
            if (Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.LBRACKET) && (inlineLink = Companion.parseInlineLink(iterator2)) != null) {
                iterator2 = inlineLink.getIteratorPosition().advance();
                result2 = result2.withOtherParsingResult(inlineLink);
                continue;
            }
            delegateIndices.put(iterator2.getIndex());
            iterator2 = iterator2.advance();
        }
        return result2.withFurtherProcessing(delegateIndices.get());
    }

    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LocalParsingResult parseInlineLink(@NotNull TokensCache.Iterator iterator2) {
            Object object;
            Object object2;
            LocalParsingResult linkTitle;
            LocalParsingResult linkDestination;
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            int startIndex = iterator2.getIndex();
            TokensCache.Iterator it = iterator2;
            LocalParsingResult localParsingResult = LinkParserUtil.Companion.parseLinkText(it);
            if (localParsingResult == null) {
                return null;
            }
            LocalParsingResult linkText = localParsingResult;
            it = linkText.getIteratorPosition();
            if (!Intrinsics.areEqual((Object)it.rawLookup(1), (Object)MarkdownTokenTypes.LPAREN)) {
                return null;
            }
            if (Intrinsics.areEqual((Object)(it = it.advance().advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((linkDestination = LinkParserUtil.Companion.parseLinkDestination(it)) != null && Intrinsics.areEqual((Object)(it = linkDestination.getIteratorPosition().advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if ((linkTitle = LinkParserUtil.Companion.parseLinkTitle(it)) != null && Intrinsics.areEqual((Object)(it = linkTitle.getIteratorPosition().advance()).getType(), (Object)MarkdownTokenTypes.EOL)) {
                it = it.advance();
            }
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownTokenTypes.RPAREN)) {
                return null;
            }
            return new LocalParsingResult(it, (Collection<SequentialParser.Node>)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus(linkText.getParsedNodes(), (Iterable)((object2 = linkDestination) != null && (object2 = ((LocalParsingResult)object2).getParsedNodes()) != null ? (Iterable)object2 : (Iterable)CollectionsKt.emptyList())), (Iterable)((object = linkTitle) != null && (object = ((LocalParsingResult)object).getParsedNodes()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList())), (Object)new SequentialParser.Node(new IntRange(startIndex, it.getIndex() + 1), MarkdownElementTypes.INLINE_LINK)), linkText.getRangesToProcessFurther());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

