/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

public final class EmphStrongDelimiterParser
extends DelimiterParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public int scan(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator iterator2, @NotNull List<DelimiterParser.Info> delimiters) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
        if (!Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.EMPH)) {
            return 0;
        }
        int stepsToAdvance = 1;
        TokensCache.Iterator rightIterator = iterator2;
        char marker = DelimiterParser.Companion.getType(rightIterator);
        for (int index = 0; index < 50 && Intrinsics.areEqual((Object)rightIterator.rawLookup(1), (Object)MarkdownTokenTypes.EMPH) && DelimiterParser.Companion.getType(rightIterator.advance()) == marker; ++index) {
            rightIterator = rightIterator.advance();
            ++stepsToAdvance;
        }
        Pair<Boolean, Boolean> pair = this.canOpenClose(tokens, iterator2, rightIterator, marker == '*');
        boolean canOpen = (Boolean)pair.component1();
        boolean canClose = (Boolean)pair.component2();
        int n = stepsToAdvance;
        for (int index = 0; index < n; ++index) {
            DelimiterParser.Info info = new DelimiterParser.Info(MarkdownTokenTypes.EMPH, iterator2.getIndex() + index, stepsToAdvance, canOpen, canClose, marker, 0, 64, null);
            delimiters.add(info);
        }
        return stepsToAdvance;
    }

    @Override
    public void process(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator iterator2, @NotNull List<DelimiterParser.Info> delimiters, @NotNull SequentialParser.ParsingResultBuilder result2) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        boolean isStrong = false;
        int n = ((Collection)delimiters).size() + -1;
        if (0 <= n) {
            do {
                int index = n--;
                if (isStrong) {
                    isStrong = false;
                    continue;
                }
                DelimiterParser.Info opener = delimiters.get(index);
                if (!Intrinsics.areEqual((Object)opener.getTokenType(), (Object)MarkdownTokenTypes.EMPH) || opener.getCloserIndex() == -1) continue;
                isStrong = Companion.areAdjacentSameMarkers(delimiters, index, opener.getCloserIndex());
                DelimiterParser.Info closer = delimiters.get(opener.getCloserIndex());
                SequentialParser.Node node2 = isStrong ? new SequentialParser.Node(new IntRange(opener.getPosition() - 1, closer.getPosition() + 2), MarkdownElementTypes.STRONG) : new SequentialParser.Node(new IntRange(opener.getPosition(), closer.getPosition() + 1), MarkdownElementTypes.EMPH);
                result2.withNode(node2);
            } while (0 <= n);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public final boolean areAdjacentSameMarkers(@NotNull List<DelimiterParser.Info> delimiters, int openerIndex, int closerIndex) {
            Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
            DelimiterParser.Info opener = delimiters.get(openerIndex);
            DelimiterParser.Info closer = delimiters.get(closerIndex);
            return openerIndex > 0 && delimiters.get(openerIndex - 1).getCloserIndex() == opener.getCloserIndex() + 1 && delimiters.get(openerIndex - 1).getMarker() == opener.getMarker() && delimiters.get(openerIndex - 1).getPosition() == opener.getPosition() - 1 && delimiters.get(opener.getCloserIndex() + 1).getPosition() == closer.getPosition() + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

