/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers.impl;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.RangesListBuilder;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

public final class BacktickParser
implements SequentialParser {
    @Override
    @NotNull
    public SequentialParser.ParsingResult parse(@NotNull TokensCache tokens, @NotNull List<IntRange> rangesToGlue) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(rangesToGlue, (String)"rangesToGlue");
        SequentialParser.ParsingResultBuilder result2 = new SequentialParser.ParsingResultBuilder();
        RangesListBuilder delegateIndices = new RangesListBuilder();
        TokensCache.Iterator iterator2 = new TokensCache.RangesListIterator(tokens, rangesToGlue);
        while (iterator2.getType() != null) {
            TokensCache.Iterator endIterator;
            if ((Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) && (endIterator = this.findOfSize(iterator2.advance(), this.getLength(iterator2, true))) != null) {
                result2.withNode(new SequentialParser.Node(new IntRange(iterator2.getIndex(), endIterator.getIndex() + 1), MarkdownElementTypes.CODE_SPAN));
                iterator2 = endIterator.advance();
                continue;
            }
            delegateIndices.put(iterator2.getIndex());
            iterator2 = iterator2.advance();
        }
        return result2.withFurtherProcessing(delegateIndices.get());
    }

    private final TokensCache.Iterator findOfSize(TokensCache.Iterator it, int length) {
        TokensCache.Iterator iterator2 = it;
        while (iterator2.getType() != null) {
            if ((Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.BACKTICK) || Intrinsics.areEqual((Object)iterator2.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) && this.getLength(iterator2, false) == length) {
                return iterator2;
            }
            iterator2 = iterator2.advance();
        }
        return null;
    }

    private final int getLength(TokensCache.Iterator info, boolean canEscape) {
        int toSubtract = 0;
        if (Intrinsics.areEqual((Object)info.getType(), (Object)MarkdownTokenTypes.ESCAPED_BACKTICKS)) {
            toSubtract = canEscape ? 2 : 1;
        }
        return info.getLength() - toSubtract;
    }
}

