/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.html.CommonDefsImplJvmKt;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;

public final class SequentialParserUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public static final class Companion {
        private Companion() {
        }

        public final boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return CommonDefsImplJvmKt.isWhitespace(info.charLookup(lookup));
        }

        public final boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return CommonDefsImplJvmKt.isPunctuation(info.charLookup(lookup));
        }

        @NotNull
        public final List<IntRange> filterBlockquotes(@NotNull TokensCache tokensCache, @NotNull IntRange textRange) {
            Intrinsics.checkNotNullParameter((Object)tokensCache, (String)"tokensCache");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            ArrayList<IntRange> result2 = new ArrayList<IntRange>();
            int lastStart = textRange.getFirst();
            int R = textRange.getLast();
            int i2 = lastStart;
            int n = R - 1;
            if (i2 <= n) {
                while (true) {
                    if (Intrinsics.areEqual((Object)new TokensCache.Iterator(tokensCache, i2).getType(), (Object)MarkdownTokenTypes.BLOCK_QUOTE)) {
                        if (lastStart < i2) {
                            result2.add(new IntRange(lastStart, i2 - 1));
                        }
                        lastStart = i2 + 1;
                    }
                    if (i2 == n) break;
                    ++i2;
                }
            }
            if (lastStart < R) {
                result2.add(new IntRange(lastStart, R));
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

