/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SequentialParser {
    @NotNull
    public ParsingResult parse(@NotNull TokensCache var1, @NotNull List<IntRange> var2);

    public static final class Node {
        @NotNull
        private final IntRange range;
        @NotNull
        private final IElementType type;

        public Node(@NotNull IntRange range, @NotNull IElementType type2) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            this.range = range;
            this.type = type2;
        }

        @NotNull
        public final IntRange getRange() {
            return this.range;
        }

        @NotNull
        public final IElementType getType() {
            return this.type;
        }

        @NotNull
        public String toString() {
            return "Node(range=" + this.range + ", type=" + this.type + ')';
        }

        public int hashCode() {
            int result2 = this.range.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node2 = (Node)other;
            if (!Intrinsics.areEqual((Object)this.range, (Object)node2.range)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)node2.type);
        }
    }

    public static interface ParsingResult {
        @NotNull
        public Collection<Node> getParsedNodes();

        @NotNull
        public Collection<List<IntRange>> getRangesToProcessFurther();
    }

    public static final class ParsingResultBuilder
    implements ParsingResult {
        @NotNull
        private final Collection<Node> _parsedNodes = new ArrayList();
        @NotNull
        private final Collection<List<IntRange>> _rangesToProcessFurther = new ArrayList();

        @Override
        @NotNull
        public Collection<Node> getParsedNodes() {
            return this._parsedNodes;
        }

        @Override
        @NotNull
        public Collection<List<IntRange>> getRangesToProcessFurther() {
            return this._rangesToProcessFurther;
        }

        @NotNull
        public final ParsingResultBuilder withNode(@NotNull Node result2) {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            this._parsedNodes.add(result2);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withFurtherProcessing(@NotNull List<IntRange> ranges) {
            Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
            this._rangesToProcessFurther.add(ranges);
            return this;
        }

        @NotNull
        public final ParsingResultBuilder withOtherParsingResult(@NotNull ParsingResult parsingResult) {
            Intrinsics.checkNotNullParameter((Object)parsingResult, (String)"parsingResult");
            this._parsedNodes.addAll(parsingResult.getParsedNodes());
            this._rangesToProcessFurther.addAll(parsingResult.getRangesToProcessFurther());
            return this;
        }
    }
}

