/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.sequentialparsers;

import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserUtil;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DelimiterParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public abstract int scan(@NotNull TokensCache var1, @NotNull TokensCache.Iterator var2, @NotNull List<Info> var3);

    public abstract void process(@NotNull TokensCache var1, @NotNull TokensCache.Iterator var2, @NotNull List<Info> var3, @NotNull SequentialParser.ParsingResultBuilder var4);

    @NotNull
    public Pair<Boolean, Boolean> canOpenClose(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator left, @NotNull TokensCache.Iterator right, boolean canSplitText) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        boolean isLeftFlanking = this.isLeftFlankingRun(left, right);
        boolean isRightFlanking = this.isRightFlankingRun(tokens, left, right);
        boolean canOpen = canSplitText ? isLeftFlanking : isLeftFlanking && (!isRightFlanking || SequentialParserUtil.Companion.isPunctuation(left, -1));
        boolean canClose = canSplitText ? isRightFlanking : isRightFlanking && (!isLeftFlanking || SequentialParserUtil.Companion.isPunctuation(right, 1));
        return TuplesKt.to((Object)canOpen, (Object)canClose);
    }

    public boolean isLeftFlankingRun(@NotNull TokensCache.Iterator leftIt, @NotNull TokensCache.Iterator rightIt) {
        Intrinsics.checkNotNullParameter((Object)leftIt, (String)"leftIt");
        Intrinsics.checkNotNullParameter((Object)rightIt, (String)"rightIt");
        return !this.isWhitespace(rightIt, 1) && (!this.isPunctuation(rightIt, 1) || this.isWhitespace(leftIt, -1) || this.isPunctuation(leftIt, -1));
    }

    public boolean isRightFlankingRun(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator leftIt, @NotNull TokensCache.Iterator rightIt) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)leftIt, (String)"leftIt");
        Intrinsics.checkNotNullParameter((Object)rightIt, (String)"rightIt");
        return leftIt.charLookup(-1) != Companion.getType(leftIt) && !this.isWhitespace(leftIt, -1) && (!this.isPunctuation(leftIt, -1) || this.isWhitespace(rightIt, 1) || this.isPunctuation(rightIt, 1));
    }

    public boolean isWhitespace(@NotNull TokensCache.Iterator info, int lookup) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return SequentialParserUtil.Companion.isWhitespace(info, lookup);
    }

    public boolean isPunctuation(@NotNull TokensCache.Iterator info, int lookup) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return SequentialParserUtil.Companion.isPunctuation(info, lookup);
    }

    public static final class Companion {
        private Companion() {
        }

        public final char getType(@NotNull TokensCache.Iterator iterator2) {
            Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
            return iterator2.getFirstChar();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class Info {
        @NotNull
        private final IElementType tokenType;
        private final int position;
        private final int length;
        private boolean canOpen;
        private boolean canClose;
        private char marker;
        private int closerIndex;

        public Info(@NotNull IElementType tokenType, int position, int length, boolean canOpen, boolean canClose, char marker, int closerIndex) {
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            this.tokenType = tokenType;
            this.position = position;
            this.length = length;
            this.canOpen = canOpen;
            this.canClose = canClose;
            this.marker = marker;
            this.closerIndex = closerIndex;
        }

        public /* synthetic */ Info(IElementType iElementType, int n, int n2, boolean bl, boolean bl2, char c, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n2 = 0;
            }
            if ((n4 & 0x40) != 0) {
                n3 = -1;
            }
            this(iElementType, n, n2, bl, bl2, c, n3);
        }

        @NotNull
        public final IElementType getTokenType() {
            return this.tokenType;
        }

        public final int getPosition() {
            return this.position;
        }

        public final int getLength() {
            return this.length;
        }

        public final boolean getCanOpen() {
            return this.canOpen;
        }

        public final void setCanOpen(boolean bl) {
            this.canOpen = bl;
        }

        public final boolean getCanClose() {
            return this.canClose;
        }

        public final void setCanClose(boolean bl) {
            this.canClose = bl;
        }

        public final char getMarker() {
            return this.marker;
        }

        public final int getCloserIndex() {
            return this.closerIndex;
        }

        public final void setCloserIndex(int n) {
            this.closerIndex = n;
        }

        @NotNull
        public String toString() {
            return "Info(tokenType=" + this.tokenType + ", position=" + this.position + ", length=" + this.length + ", canOpen=" + this.canOpen + ", canClose=" + this.canClose + ", marker=" + this.marker + ", closerIndex=" + this.closerIndex + ')';
        }

        public int hashCode() {
            int result2 = this.tokenType.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.position);
            result2 = result2 * 31 + Integer.hashCode(this.length);
            result2 = result2 * 31 + Boolean.hashCode(this.canOpen);
            result2 = result2 * 31 + Boolean.hashCode(this.canClose);
            result2 = result2 * 31 + Character.hashCode(this.marker);
            result2 = result2 * 31 + Integer.hashCode(this.closerIndex);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Info)) {
                return false;
            }
            Info info = (Info)other;
            if (!Intrinsics.areEqual((Object)this.tokenType, (Object)info.tokenType)) {
                return false;
            }
            if (this.position != info.position) {
                return false;
            }
            if (this.length != info.length) {
                return false;
            }
            if (this.canOpen != info.canOpen) {
                return false;
            }
            if (this.canClose != info.canClose) {
                return false;
            }
            if (this.marker != info.marker) {
                return false;
            }
            return this.closerIndex == info.closerIndex;
        }
    }
}

